/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSLNode_HPP
#define HWSLNode_HPP

#include "hws.h"

//  The LLData class is a node contained in the DList class.
//  LLData provides a linked list node which contains a name-value
//  pair along with the length of the value.
class DllExport HWSLNode {

  // Public access
  public:

     // Member functions
     HWSLNode(char * dName, int dLength, void * dValue);
     ~HWSLNode();              // Destructor.

     // Data members
     char          *name;      // Name of attribute or segment.
     int           length;     // Number of bytes in data.
     void          *data;      // Pointer to data buffer.
     HWSLNode      *next;      // Pointer to next HWSLNode object.
     HWSLNode      *prev;      // Pointer to previous HWSLNode object.
};

#endif
