/**********************************************************************/
/*                                                                    */
/* (C) Copyright IBM Corp. 1994                                       */
/* All Rights Reserved                                                */
/* Licensed Materials - Property of IBM                               */
/*                                                                    */
/**********************************************************************/
#ifndef HWSLPAGE_HPP
#define HWSLPAGE_HPP

#include "hws.h"
#include "hwsseg.hpp"

//  HWSLPageDesc is a class which represents the LPAGE specification
//  of an input or output message descriptor in the MFS source.
class DllExport HWSLPageDesc {

  // Public access
  public:

     // Member functions
     HWSLPageDesc(char *lName, CONDType cType, Condition *cData);
     ~HWSLPageDesc();

     //  Add the passed segment to the Seg chain.
     int addSeg( HWSSegDesc *seg);

     // Data members
     HWSLPageDesc  *next;           // NULL if input message; pointer to next
                                    // of possible multiple output LPAGEs.
     HWSSegDesc    *firstSegment;   // Pointer to first of possible multiple
                                    // message segments in LPAGE.  SEG will be
                                    // created if not in definition.
	 // following data members are set by the constructor
     char          *name;           // Name of LPAGE.
     CONDType      condType;        // Type of condition: NONE, MFLD, MFLDPP, SEGOFF
     Condition     *condData;       // Conditional test for LPAGE.
                                    // The client will set this based on the
                                    // COND= statement.
	 // following data members are set when this lpage is added to msg
     MSGOption     option;          // Message option.
     MSGType       type;            // Message type (input or output).

     char          *nextName;       // Name of NXT= .
};

#endif
