/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSLPGF_HPP
#define HWSLPGF_HPP

#include "hwslpage.hpp"

class HWSDList;
class HWSLNode;
class HWSConverter;
class HWSError;

//  The HWSLPageFormat class inherits from HWSLPageDesc class to inherit
//  all the information about the LPAGE.
//  HWSLPageFormat enhances the parent class by providing methods
//  to format the logical pages.
class DllExport HWSLPageFormat : public HWSLPageDesc {

  // Public access
  public:

     // Member functions
     HWSLPageFormat(char *lName, CONDType cType, Condition *cData);
     ~HWSLPageFormat();               // Destructor.

     // Error code range:           1200-1299
     // Internal error code range:  9200-9299

     // This method applies the COND= test to the segment to see
     // if this is the right LPage to use to format the message.
     int testCOND( HWSError *errStruc, HWSLNode *segment, HWSConverter *convObj );

     HWSDList  *formatIn( HWSError *errStruc, HWSDList *fldList, HWSConverter *convObj );
     HWSDList  *formatOut( HWSError *errStruc, char *MODName, HWSDList *segList, HWSConverter *convObj );

};

#endif
