/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef HWSPW_HPP
#define HWSPW_HPP

#include "hws.h"

/*--------------------------------------------------------------------*/
/* The HWSPassData class provides "user exit" capability for the      */
/* purposes of                                                        */
/*                                                                    */
/*     - encrypting the password to text, or                          */
/*     - encrypting the password to binary                            */
/*                                                                    */
/* One of the methods encrypt2Text or encrypt2Bin is invoked by       */
/* IMS Web Runtime prior to setting the PassTckt field in the         */
/* User Data segment of the OTMA message.  The PassTckt field         */
/* is used for both the password and the passticket.                  */
/*                                                                    */
/*--------------------------------------------------------------------*/
class DllExport HWSPassData {

   /*-----------------------------------------------------------------*/
   /* Public methods and attributes.                                  */
   /*-----------------------------------------------------------------*/
   public:

   HWSPassData( int length );
   ~HWSPassData();

   /*-----------------------------------------------------------------*/
   /* Encrypt text password to text.                                  */
   /*-----------------------------------------------------------------*/
   char *encrypt2Text( char *userID,
                       char *inPassWord );

   /*-----------------------------------------------------------------*/
   /* Encrypt text password to binary.                                */
   /*-----------------------------------------------------------------*/
   void *encrypt2Bin( char *userID,
                      char *inPassWord,
                      int  *length );

   /*-----------------------------------------------------------------*/
   /* Private methods and attributes.                                 */
   /*-----------------------------------------------------------------*/
   private:

   int fldLen;
};

#endif

