/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef HWSSEGS_HPP
#define HWSSEGS_HPP

#include "hws.h"

class HWSSegment;

/*--------------------------------------------------------------------*/
/* Change History:                                                    */
/*                                                                    */
/* 04/17/98  JEH  PTM2401  Added removeSegment.                       */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* The HWSSegments class represents one or more segments of an IMS    */
/* message.  These segments form the input to or output from and      */
/* IMS transaction.                                                   */
/*--------------------------------------------------------------------*/
class DllExport HWSSegments {

   /*-----------------------------------------------------------------*/
   /* Public methods and attributes.                                  */
   /*-----------------------------------------------------------------*/
   public:

   HWSSegments( char *mdName );

   ~HWSSegments();

   /*-----------------------------------------------------------------*/
   /* Use to add segments to a transaction input message.  The        */
   /* segment data will not be converted.  It will be used "as is"    */
   /* for the segment of the message passed to the IMS transaction.   */
   /* hence it must already be in EBCDIC.                             */
   /*                                                                 */
   /* Note: The first segment of the input message must contain the   */
   /* IMS transaction code in the first 8 bytes of the segment.       */
   /*                                                                 */
   /* HWSSegment aSegment An HWSSegment object representing a         */
   /*                     segment of the input message.               */
   /*-----------------------------------------------------------------*/
   void addSegment( HWSSegment *aSegment );
   HWSSegment *removeSegment();

   /*-----------------------------------------------------------------*/
   /* Use the following methods to retrieve individula segments of    */
   /* the HWSSegments object.                                         */
   /*                                                                 */
   /* Note: The data of the HWSSegment object returned will be        */
   /*       in host format (EBCDIC).                                  */
   /*-----------------------------------------------------------------*/
   HWSSegment *getFirstSegment();
   HWSSegment *getLastSegment();
   HWSSegment *getNextSegment( HWSSegment *aSegment );
   HWSSegment *getPreviousSegment( HWSSegment *aSegment );

   /*-----------------------------------------------------------------*/
   /* getMDName                                                       */
   /*-----------------------------------------------------------------*/
   char *getMDName();

   /*-----------------------------------------------------------------*/
   /* Private methods and attributes.                                 */
   /*-----------------------------------------------------------------*/
   private:

   HWSBool isMember( HWSSegment *aSegment );

   char       *MDName;         /* MID or MOD name.                    */
   HWSSegment *firstSeg;
   HWSSegment *lastSeg;
};

#endif

