/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef DFSYMSG_H
#define DFSYMSG_H

/*--------------------------------------------------------------------*/
/*                                                                    */
/* Definitions for segments of OTMA message.                          */
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 03/18/98  JEH  PTM2338 Added FLAG2 to USD segment for encryption   */
/*                exit support.                                       */
/*                                                                    */
/* 05/09/98  JEH  PTM2481 New OTMA msg format; LTERM override.        */
/*                                                                    */
/*--------------------------------------------------------------------*/
#define PFX_HWSWEB         "*HWSWEB*" // Product Identifier

#define MCI_MSGLEVEL       0x01 // to indicate first OTMA release

#define MCI_MSGTYPE_DATA   0x80 // Msg type=Data output from TRANSACTION
#define MCI_MSGTYPE_TRAN   0x40 // Msg type=Tran appl-data contains TRANNAME
#define MCI_MSGTYPE_RESP   0x20 // Msg type=Resp
#define MCI_MSGTYPE_CMD	   0x10 // Msg type=Cmd  an OTMA command
#define MCI_MSGTYPE_COMMIT 0x08 // Msg type=Cmmt Commit Confirmation
#define MCI_MSGTYPE_WEB	   MCI_MSGTYPE_TRAN


#define MCI_RESPIND_ACK    0x80 // Resp=Ack     positive response
#define MCI_RESPIND_NACK   0x40 // Resp=Nack    negative response
#define MCI_RESPIND_RESP   0x20 // Resp=Resp    response is requested
#define MCI_RESPIND_EXTR   0x10 // Resp=ExtResp extended response requested
#define MCI_RESPIND_WEB	   0x00

#define MCI_CMTSTAT_COMMIT 0x80 // Confirm=Cmmt Committed
#define MCI_CMTSTAT_ABORT  0x40 // Confirm=Abrt Aborted
#define MCI_CMTSTAT_READY  0x20 // Confirm=Ready
#define MCI_CMTSTAT_WEB    0x00

#define MCI_CMDTYPE_CBID   0x04 // Cmd=Clt-Bid             C to S
#define MCI_CMDTYPE_SAVAIL 0x08 // Cmd=Svr-Avail           S to C
#define MCI_CMDTYPE_CBSYNC 0x0C // Cmd=CBResynch           C to S
#define MCI_CMDTYPE_RESERV 0x10 // Reserved
#define MCI_CMDTYPE_SSUSPA 0x14 // Cmd=Suspend All         S to C
#define MCI_CMDTYPE_SRESUA 0x18 // Cmd=Resume All          S to C
#define MCI_CMDTYPE_SSUSPN 0x1C // Cmd=Suspend Named       S to C
#define MCI_CMDTYPE_SRESUN 0x20 // Cmd=Resume Named        S to C
#define MCI_CMDTYPE_CDISCN 0x24 // Cmd=Discard Named tpipe C to S
#define MCI_CMDTYPE_SREQID 0x28 // Cmd=Request context ID  S to C
#define MCI_CMDTYPE_SRSYNC 0x2C // Cmd=SRVResync           S to C
#define MCI_CMDTYPE_CLSYNC 0x30 // Cmd=CLResync            C to S
#define MCI_CMDTYPE_CLREDY 0x34 // Cmd=CLReady             C to S
#define MCI_CMDTYPE_WEB    0x00

#define MCI_PRCTYPE_LOAD   0x80 // Load Program
#define MCI_PRCTYPE_SYNCTP 0x40 // Synch'd Tpipe
#define MCI_PRCTYPE_ASYNC  0x20 // Async/unsolicited
#define MCI_PRCTYPE_ERRMSG 0x10 // Error msg with the NACK
#define MCI_PRCTYPE_WEB    0x00

#define MCI_CHAIN_FIRST    0x80 // First in Chain
#define MCI_CHAIN_MIDDLE   0x40 // Middle in Chain
#define MCI_CHAIN_LAST     0x20 // Last in Chain
#define MCI_CHAIN_CANCEL   0x10 // Cancel this message
#define MCI_CHAIN_ONLY     MCI_CHAIN_FIRST | MCI_CHAIN_LAST

#define MCI_PREFIX_STATE   0x80 // State Data is Present
#define MCI_PREFIX_SECUR   0x40 // Security Data is Present
#define MCI_PREFIX_USER    0x20 // User Data is Present
#define MCI_PREFIX_APPL    0x10 // Application Data is Present
#define MCI_PREFIX_WEB     0xF0 // all of above

#define MCI_ACK					          0x0000
#define MCI_NACK_NOT_IN_SESSION         0x0001
#define MCI_NACK_BLOCKED                0x0002
#define MCI_NACK_PROTOCOL_ERROR         0x0003
#define MCI_NACK_BAD_CORRELATOR         0x0004
#define MCI_NACK_DUPLICATE_SEGMENT      0x0005
#define MCI_NACK_XCF_BADRC              0x0006
#define MCI_NACK_OUT_OF_MTE             0x0007
#define MCI_NACK_CLIENTBID_SEC_FAILED   0x0008
#define MCI_NACK_UNKNOWN_OTMA_CMD       0x0009
#define MCI_NACK_INPUT_IS_DATA          0x000A
#define MCI_NACK_INVALID_MSG_TYPE       0x000B
#define MCI_NACK_UNKNOWN_RESPONSE_TYPE  0x000C
#define MCI_NACK_INVALID_IMS_CONV_CONT  0x000D
#define MCI_NACK_UNABLE_CREATE_TPIPE    0x000E
#define MCI_NACK_TPIPE_STOPPED          0x000F
#define MCI_NACK_NO_STATE_DATA          0x0010
#define MCI_NACK_INVALID_COMMIT_MSG     0x0011
#define MCI_NACK_PREFIX_TOO_BIG         0x0012
#define MCI_NACK_NO_MSG_HASHTABLE_SIZE  0x0013
#define MCI_NACK_INVALID_STATE          0x0014
#define MCI_NACK_NO_MSG_HASHTABLE       0x0015
#define MCI_NACK_MEM_NOT_ACTIVE         0x0016
#define MCI_NACK_INVALID_SYNC_LEVEL     0x0017
#define MCI_NACK_INVALID_TPIPE_NAME     0x0018
#define MCI_NACK_INVALID_MEMBER_NAME    0x0019
#define MCI_NACK_ERROR_IN_MESSAGE       0x001A
#define MCI_NACK_IMS_IN_SHUTDOWN        0x001B
#define MCI_NACK_INVALID_COMMIT_MODE    0x001C
#define MCI_NACK_INVALID_UDATA_LEN      0x001D
#define MCI_NACK_INVALID_IMS_UDATA_LEN  0x001E
#define MCI_NACK_INVALID_RECOV_SEQ_NUM  0x001F
#define MCI_NACK_NO_APPL_DATA           0x0020
#define MCI_NACK_NO_CHAIN_FLAG          0x0021
#define MCI_NACK_INVALID_CMT_WITH_SYNCL 0x0022
#define MCI_NACK_INVALID_CONTEXT_TOKEN  0x0023

#define MCI_NACK_PRESET                 0x00FF
#define MCI_NACK_RESP                   0x0FFF

#define STA_IMSSTATE_CONV 0x80 // Conversational State by S&C
#define STA_IMSSTATE_RESP 0x40 // Response Mode        by S
#define STA_IMSSTATE_WEB  0x00

#define STA_SYNCTYPE_RESV 0x80 // Reserved
#define STA_SYNCTYPE_CAS  0x40 // Commit Mode 0      commit and send
#define STA_SYNCTYPE_SAC  0x20 // Commit Mode 1      send and commit
#define STA_SYNCTYPE_NOT  0x10 // Notify of Transfer
#define STA_SYNCTYPE_WEB  STA_SYNCTYPE_SAC

#define STA_SYNCLVL_NONE  0x00 // Synclvl=0 (None)
#define STA_SYNCLVL_CONF  0x01 // Synclvl=1 (Confirm)
#define STA_SYNCLVL_SYNC  0x02 // Synclvl=2 (Syncpt)
#define STA_SYNCLVL_WEB   0x00

#define SEC_SECTYPE_NORACF  'N' // None
#define SEC_SECTYPE_CHECK   'C' // Check for Tran & Cmd
#define SEC_SECTYPE_FULL    'F' // Check for Tran, Cmd, and MPR
#define SEC_SECTYPE_WEB     SEC_SECTYPE_FULL

#define SEC_SECDLEN 	       0x14 // security data length
#define SEC_SECUIDLEN 	    0x09 // userid length
#define SEC_SECGIDLEN 	    0x09 // group id length
#define SEC_SECUIDTYPE 	    0x02 // userid type
#define SEC_SECGIDTYPE 	    0x03 // group id type

#define USD_DATALENGTH 	    256  // DATALENGTH for UserData Segment
#define USD_FLAG1_PSOCKET   0x00 // Persistent socket
#define USD_FLAG1_NPSOCKET  0x40 // Non-persistent socket
#define USD_FLAG2_PWDTEXT   0x01 // PassTckt field is text password      PTM2338
#define USD_FLAG2_PWDBIN    0x02 // PassTckt field is binary password    PTM2338

#define PFX_MSGFMT_OHDRS    0x80 // OTMA headers present                 PTM2481
#define PFX_MSGFMT_SCNVT    0x40 // Server converts to EBCDIC            PTM2481


/*--------------------------------------------------------------------*/
/*                                                                    */
/* Buffer length followed by input IWEB INTERFACE HEADER.             */
/*                                                                    */
/* Note: Input prefix was re-designed and became IWEB INTERFACE       */
/*       HEADER as a result of PTM2481 in 2.1.  Output prefix         */
/*       remains the same.                                            */
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef struct {
	unsigned long  DataLength;		// Length of whole buffer.
   unsigned short LL;            // Includes LLZZ but not DataLength.
   unsigned short ZZ;            // Binary zeros.
	char           ProdName[8];   // *HWSWEB*
   char           MFSFlag;       // MFS Flag          - binary zeros.
   char           CModeFlag;     // Commit Mode Flag  - binary zeros.
   char           SynchFlag;     // SYNCH Level Flag  - binary zeros.
   char           ConvFlag;      // Conversation Flag - blank.
   char           MsgFmt;        // Message Format    - see above.
   char           Resrv1;        // Reserved          - binary zeros.
   char           Resrv2;        // Reserved          - binary zeros.
   char           Resrv3;        // Reserved          - binary zeros.
   char           ClientID[8];   // Also known as RUName.
} PFX_Seg;


/*--------------------------------------------------------------------*/
/*                                                                    */
/* Output prefix.  Remains the same (re: PTM2481).                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef struct {
   unsigned long DataLength;     // Lenght of whole buffer.
   char          ProdName[8];    // *HWSWEB*
   } PFXO_Seg;


/*--------------------------------------------------------------------*/
/*                                                                    */
/* MESSAGE CONTROL INFORMATION                                        */
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef struct {
	char MsgLevel;			// MCI_MSGLEVEL
	char MsgType;			// MCI_MSGTYPE_WEB
	char RespInd;	      // MCI_RESPIND_WEB
	char CmtState;			// MCI_CMTSTAT_WEB
	char CmdType;			// MCI_CMDTYPE_WEB
	char ProcType;			// MCI_PRCTYPE_WEB
	char TpipeName[8];      // overrides the LTERM name in I/O PCB
	char ChainState;		// ZERO unless multiple message
	char PrefixFlag;		// MCI_PREFIX_WEB
	unsigned long  SendSeqNumber;			// ALLWAYS ZERO
	unsigned short SenseCode;				// ALLWAYS ZERO
	unsigned short ReasonCode;				// ALLWAYS ZERO
	unsigned long  RecoverableMsgSeqNumber;	// ALLWAYS ZERO
	unsigned short SegSeqNumber;			// seq number if ChainState	
   char Reserved[2];						// ALLWAYS BLANKS
} MCI_Seg;


/*--------------------------------------------------------------------*/
/*                                                                    */
/* STATE DATA for transaction messages                                */
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef struct {
	unsigned short DataLength;		// includes self
	char 	IMSState;				// STA_IMSSTATE_WEB
	char  SyncType;				// STA_SYNCTYPE_WEB
	char  SyncLevel;				// STA_SYNCLVL_WEB
	char  Reserved;				// ALWAYS BLANKS
	char 	MapName[8];				// MID name in MOD name out
	char 	ServerToken[16];		// ALWAYS BLANKS
	char 	Correlator[16];			// ALWAYS BLANKS
	char 	ContextId[16];			// ALWAYS BLANKS
	char 	LTERMName[8];			// ALWAYS BLANKS
	unsigned short UserDataLen;	// ALWAYS ZERO
	// UserData up to the UserDataLen follows
} STATE_TRN_Seg;


/*--------------------------------------------------------------------*/
/*                                                                    */
/* SECURITY                                                           */
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef struct {
   unsigned short DataLength;	// excludes self
   char  SecType;		// SEC_SECTYPE_WEB
   char  SecDataLength;		// ALWAYS 20
   char  SecUserIdLen;		// ALWAYS 8
   char  SecUserIdType;		// SEC_SECUIDTYPE
   char  SecUserId[8];		// left justified blank padded
   char  SecGroupIdLen;		// ALWAYS 8
   char  SecGroupIdType;	// SEC_SECGIDTYPE
   char  SecGroupId[8];		// left justified blank padded
   char  FILLER[82];       // filler for the UTOKEN stuff
} SEC_Seg;


/*--------------------------------------------------------------------*/
/*                                                                    */
/* USER DATA                                                          */
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef struct {
	unsigned short DataLength;  // includes  self
   char           ZZ[2];
   char           DestID[8];
   char           OrigID[8];
   char           PortID[8];
   char           LTOKEN[8];
   unsigned long  RetCode;
   char           ResCode[8];
   unsigned long  ResToken;
   char           PassTckt[8];
   char           Flag1;         /* Socket persistence               */
   char           Flag2;         /* User authentication data type    */   /* PTM2338 */
   char           FILLER[194];	// unused                                /* PTM2338 */
} USD_Seg;


/*--------------------------------------------------------------------*/
/*                                                                    */
/* APPLICATION DATA                                                   */
/*                                                                    */
/*--------------------------------------------------------------------*/
typedef struct {
	unsigned short DataLength;  // includes self
	unsigned short ZZField;		// ALWAYS ZEROS
	// up to DataLength of data followes
} APP_Seg;


typedef struct {
	char userId[8];
	char groupName[8];
} SecInfo;

#endif
