/*********************************************************************/
/*                                                                   */
/* (c) Copyright IBM Corp. 1998                                      */
/* All Rights Reserved                                               */
/* Licensed Materials - Property of IBM                              */
/*                                                                   */
/* DISCLAIMER OF WARRANTIES.                                         */
/*                                                                   */
/* The following [enclosed] code is generated by a software product  */
/* of IBM Corporation.                                               */
/* This generated code is provided to you solely for the purpose of  */
/* assisting you in the development of your applications.            */
/* The code is provided "AS IS." IBM MAKES NO WARRANTIES, EXPRESS    */
/* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES   */
/* OF NONINFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR  */
/* PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF THIS CODE.      */
/* IBM shall not be liable for any damages arising out of your use   */
/* of the generated code, even if it has been advised of the         */
/* possibility of such damages.                                      */
/*                                                                   */
/* DISTRIBUTION.                                                     */
/*                                                                   */
/* This generated code can be freely distributed, copied, altered,   */
/* and incorporated into other software, provided that:              */
/*   - It bears the above Copyright notice and DISCLAIMER intact     */
/*   - The software is not offered for resale                        */
/*                                                                   */
/*********************************************************************/

/************************************************************************/
/* Generated by IMS Web Studio 2.1.1	1998.252	10:18:13	*/
/* Userid:	pglezen						*/
/* Project:	test5					*/
/************************************************************************/

/*********************************************************/
/*                                                       */
/*  IMS Web generated HTML input parsing class.          */
/*                                                       */
/*  This class :                                         */
/*                                                       */
/*   - parses the input for associated IMS transaction   */
/*     passed in from IMS Web generated HTML Form,       */
/*   - builds a name-value pair list to be accessed by   */
/*     the other generated classes.                      */
/*                                                       */
/*********************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "hwsutil.hpp"
#include "HTMParse.hpp"

/***************/
/* Constructor */
/***************/

HtmParse::HtmParse (char * req)
{
	int i;
	char *preq, *key, *value, *posamp, *poseq;
	HWSUtil util;
	HWSVers HWSVRM = HWSCURVRM;
	CONVType convType = USENGLISH;
	vars = new HWSDList("vars");

	/*************************************/
	/* Change all plusses back to spaces */
	/*************************************/

	for(i=0; req[i]; i++) {
		if(req[i] == '+') req[i] = ' ';
	} /* end for */

	poseq = strchr(req,'=');
	if (poseq) {
		*poseq = '\0';
		key = req;
		preq = poseq+1;
	} else {
		key = NULL;
	} /* end if */

	/************************************************/
	/* Parse all key value pairs and set attributes */
	/************************************************/

	while (key) {
		posamp = strchr(preq,'&');
		value = preq;
		if (posamp) {
			*posamp = '\0';
			preq = posamp+1;
		} else {
			preq = NULL;
		} /* end if */

		/*****************************************/
		/* Process any escape character sequence */
		/*****************************************/
		if (*value) {
			util.unper(value, convType);
		} else {
			value = NULL;
		} /* end if */

		/******************************************/
		/* Setting the parsed value in attributes */
		/******************************************/
		if (value == NULL) {
			vars->addNode(new HWSLNode(key,0,value));
		} else {
			vars->addNode(new HWSLNode(key,strlen(value)+1,value));
		}

		if (preq) {
			poseq = strchr(preq,'=');
		} else {
			poseq = NULL;
		} /* end if */
		if (poseq) {
			*poseq = '\0';
			key = preq;
			preq = poseq+1;
		} else {
			key = NULL;
		} /* end if */

	} /* end while */

}

/**************/
/* Destructor */
/**************/

HtmParse::~HtmParse(){
}

/**************/
/* getValue */
/**************/

char * HtmParse::getValue(char * name){
	char * value = NULL;
	HWSLNode * valNode = NULL;

	valNode = vars->findNamed(name);
	if (valNode != NULL) value = (char *)valNode->data;

	return (value);

}

