/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.tree.Visitor;

public class AnalyzeVisitor
extends Visitor {
    private Analyzer[] analyzers;

    public AnalyzeVisitor(Analyzer.Factory[] factoryArray) {
        this.analyzers = new Analyzer[factoryArray.length];
        int n = 0;
        while (n < factoryArray.length) {
            this.analyzers[n] = factoryArray[n].make();
            ++n;
        }
    }

    public void visitRecordNode(RecordNode recordNode) {
        Record record = recordNode.getRecord();
        if (record.getStatus() == Record.Status.unknown) {
            record.startAnalysis();
            int n = 0;
            while (n < this.analyzers.length) {
                this.analyzers[n].analyze(record);
                ++n;
            }
        }
    }
}

