/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log;

import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.BrowserFile;
import com.ibm.ivb.log.LogRecIterator;
import com.ibm.ivb.log.LogUtils;
import com.ibm.ivb.log.LogXml;
import com.ibm.ivb.log.RecIterator;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.TextUtils;
import com.ibm.ivb.log.TreeBuilder;
import com.ibm.ivb.log.datamodel.LogFileMetadata;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import com.ibm.ivb.log.datamodel.XmlUtils;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.tree.RecordFilterNode;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.tree.RootNode;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.xml.parser.TXDocument;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;

public class LogFile
extends BrowserFile {
    public static final String RecIdPrefix = "Rec_";
    public static final String DTDNAME = "raslog.dtd";
    public static String DtdDirName = "../dtd";
    public LogFileMetadata fmd;
    public RecIterator iterator;
    String filename;
    Reader rdr;
    String mdclassname;
    public RootNode root;
    TXDocument doc;
    public int recordCount;
    public String LogFileName;
    public String FileLength;
    public String FileTimeStamp;
    public String XmlFileName;
    public Vector logrecv;
    public int FileType = 2;
    public static final int FT_METADATA = 0;
    public static final int FT_XML_DOC = 1;
    public static final int FT_TXT_LOG = 2;
    public static final int FT_BIN_LOG = 3;
    public static final int FT_RDR_LOG = 4;
    public static final String DefaultFilterName = "UnitOfWork";
    public static final String SimpleAnalysis = "Highlight Severity";
    public static final String SymptomAnalysis = "Symptom";
    public static final String MinorCodeAnalysis = "Minor Code";
    public static final String GPFAnalysis = "GPF";
    public static final String OrbTraceAnalysis = "Orb Trace";
    public static final String MessageIdAnalysis = "Message ID";
    public static Vector analysisActions;

    public static String getDtdDirName() {
        return DtdDirName;
    }

    public static void setDtdDirName(String string) {
        DtdDirName = new String(string);
    }

    public LogFileMetadata getLogFileMetadata() {
        return this.fmd;
    }

    public static LogFileMetadata genLogFileMetadataFromShowlog(String string) {
        File file = new File(string);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            String string2 = byteArrayOutputStream.toString();
            System.err.println(string2);
            System.err.flush();
            return null;
        }
        new BufferedReader(fileReader);
        Vector vector = new Vector();
        LogFileMetadata logFileMetadata = new LogFileMetadata();
        logFileMetadata.setLogRecv(vector);
        return logFileMetadata;
    }

    public static void genDTD() {
        String string = new LogFileMetadata().getClass().getName();
        String string2 = DtdDirName == null ? DTDNAME : new String(String.valueOf(DtdDirName) + "/" + DTDNAME);
        XmlUtils.genDTD(string, string2);
    }

    public void saveAsXML(String string) throws IOException {
        String string2 = DtdDirName == null ? DTDNAME : new String(String.valueOf(DtdDirName) + "/" + DTDNAME);
        XmlUtils.saveAsXML(string, string2, this.getLogFileMetadata());
    }

    public static void convertToXML(String string, String string2, String string3) throws IOException {
        LogRecIterator logRecIterator = new LogRecIterator(string);
        int n = 0;
        LogRecMetadata logRecMetadata = null;
        Vector<LogRecMetadata> vector = new Vector<LogRecMetadata>();
        while ((logRecMetadata = logRecIterator.getNextRecord()) != null) {
            logRecMetadata.setRecordId(RecIdPrefix + n);
            ++n;
            vector.addElement(logRecMetadata);
        }
        LogFileMetadata logFileMetadata = new LogFileMetadata();
        logFileMetadata.setLogRecv(vector);
        logFileMetadata.setTotalRecords(Integer.toString(n));
        XmlUtils.saveAsXML(string2, string3, logFileMetadata);
    }

    public void saveAsText(String string) throws IOException {
        TextUtils.saveAsText(string, (Object)this.getLogFileMetadata());
    }

    public ByteArrayOutputStream getPrintStream() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TextUtils.saveAsText(byteArrayOutputStream, (Object)this.getLogFileMetadata());
        return byteArrayOutputStream;
    }

    public void addRecdata(LogRecMetadata logRecMetadata) {
        if (this.logrecv == null) {
            this.logrecv = new Vector();
            this.fmd.setLogRecv(this.logrecv);
        }
        this.logrecv.addElement(logRecMetadata);
    }

    public Record getNextRecord() throws IOException {
        LogRecMetadata logRecMetadata = this.iterator.getNextRecord();
        if (logRecMetadata != null) {
            logRecMetadata.setRecordId(RecIdPrefix + this.recordCount);
            this.logrecv.addElement(logRecMetadata);
            ++this.recordCount;
            return new Record(logRecMetadata);
        }
        return null;
    }

    public LogFile(String string) throws IOException {
        analysisActions = new Vector();
        analysisActions.addElement(SimpleAnalysis);
        analysisActions.addElement(SymptomAnalysis);
        analysisActions.addElement(MinorCodeAnalysis);
        analysisActions.addElement(GPFAnalysis);
        analysisActions.addElement(OrbTraceAnalysis);
        analysisActions.addElement(MessageIdAnalysis);
        if (string.endsWith(".xml")) {
            this.doc = BrowserFile.loadXML(string);
            if (this.doc == null) {
                throw new IOException(String.valueOf(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadXml")) + " " + string);
            }
            this.FileType = 1;
        } else {
            LogRecIterator logRecIterator = null;
            logRecIterator = new LogRecIterator(string);
            this.FileType = 2;
            this.iterator = logRecIterator;
        }
        this.filename = new String(string);
    }

    public void populateTree(RootNode rootNode) throws IOException {
        this.root = rootNode;
        TreeBuilder treeBuilder = new TreeBuilder(rootNode, DefaultFilterName);
        switch (this.FileType) {
            case 1: {
                this.fmd = LogXml.genLogFileMetadata(this.doc, treeBuilder);
                this.doc = null;
                return;
            }
            case 2: {
                this.recordCount = 0;
                LogRecMetadata logRecMetadata = null;
                while ((logRecMetadata = this.iterator.getNextRecord()) != null) {
                    logRecMetadata.setRecordId(RecIdPrefix + this.recordCount);
                    ++this.recordCount;
                    treeBuilder.addRecord(new Record(logRecMetadata));
                }
                treeBuilder.reorderRecordFilterNodes();
                return;
            }
        }
    }

    public LogFile(Vector vector) {
        Node node;
        Class<?> clazz = new RootNode().getClass();
        Class<?> clazz2 = new RecordFilterNode("", 0L, "").getClass();
        if (vector.size() > 0 && clazz.isInstance(node = (Node)vector.elementAt(0))) {
            this.fmd = LogUtils.genLogFileMetadata(node);
            return;
        }
        node = new RootNode();
        TreeBuilder treeBuilder = new TreeBuilder((RootNode)node, DefaultFilterName);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (clazz2.isInstance(node2)) {
                treeBuilder.addRecordFilterNode((RecordFilterNode)node2);
                continue;
            }
            treeBuilder.addRecordNode((RecordNode)node2);
        }
        treeBuilder.reorderRecordFilterNodes();
        this.fmd = LogUtils.genLogFileMetadata(node);
    }

    public LogFile(Reader reader) throws IOException {
        analysisActions = new Vector();
        analysisActions.addElement(SimpleAnalysis);
        analysisActions.addElement(SymptomAnalysis);
        analysisActions.addElement(MinorCodeAnalysis);
        analysisActions.addElement(GPFAnalysis);
        analysisActions.addElement(OrbTraceAnalysis);
        analysisActions.addElement(MessageIdAnalysis);
        this.fmd = new LogFileMetadata();
        this.logrecv = new Vector();
        this.fmd.setLogRecv(this.logrecv);
        this.rdr = reader;
    }

    public LogFile(LogFileMetadata logFileMetadata) {
        analysisActions = new Vector();
        analysisActions.addElement(SimpleAnalysis);
        analysisActions.addElement(SymptomAnalysis);
        analysisActions.addElement(MinorCodeAnalysis);
        analysisActions.addElement(GPFAnalysis);
        analysisActions.addElement(OrbTraceAnalysis);
        analysisActions.addElement(MessageIdAnalysis);
        this.fmd = logFileMetadata;
    }

    public LogFile(RootNode rootNode) {
        analysisActions = new Vector();
        analysisActions.addElement(SimpleAnalysis);
        analysisActions.addElement(SymptomAnalysis);
        analysisActions.addElement(MinorCodeAnalysis);
        analysisActions.addElement(GPFAnalysis);
        analysisActions.addElement(OrbTraceAnalysis);
        analysisActions.addElement(MessageIdAnalysis);
        this.fmd = LogUtils.genLogFileMetadata(rootNode);
    }

    public LogFile(RecordFilterNode recordFilterNode) {
        analysisActions = new Vector();
        analysisActions.addElement(SimpleAnalysis);
        analysisActions.addElement(SymptomAnalysis);
        analysisActions.addElement(MinorCodeAnalysis);
        analysisActions.addElement(GPFAnalysis);
        analysisActions.addElement(OrbTraceAnalysis);
        analysisActions.addElement(MessageIdAnalysis);
        this.fmd = LogUtils.genLogFileMetadata(recordFilterNode);
    }

    public LogFile(RecordNode recordNode) {
        RootNode rootNode = new RootNode();
        TreeBuilder treeBuilder = new TreeBuilder(rootNode, DefaultFilterName);
        treeBuilder.addRecordNode(recordNode);
        this.fmd = LogUtils.genLogFileMetadata(rootNode);
    }

    public LogFile() throws IOException {
        analysisActions = new Vector();
        analysisActions.addElement(SimpleAnalysis);
        analysisActions.addElement(SymptomAnalysis);
        analysisActions.addElement(MinorCodeAnalysis);
        analysisActions.addElement(GPFAnalysis);
        analysisActions.addElement(OrbTraceAnalysis);
        analysisActions.addElement(MessageIdAnalysis);
        if (this.fmd == null) {
            this.fmd = new LogFileMetadata();
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = System.getProperty("TimeStampFormat", "M/d/yy H:mm:ss.");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        AppModel.setTimeStampFormat(simpleDateFormat);
        String string3 = System.getProperty("CURRDIR", ".");
        String string4 = null;
        String string5 = null;
        int n = Array.getLength(stringArray);
        if (n == 2) {
            string4 = new String(stringArray[0]);
            string5 = new String(stringArray[1]);
        } else if (n == 4 && stringArray[2].toLowerCase().equals("-filter")) {
            string = new String(stringArray[3]);
            string4 = new String(stringArray[0]);
            string5 = new String(stringArray[1]);
        } else {
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgInvNoParam"));
            System.err.flush();
            System.exit(0);
        }
        String string6 = null;
        String string7 = null;
        File file = new File(string4);
        string6 = file.isAbsolute() ? string4 : String.valueOf(string3) + File.separator + string4;
        file = new File(string5);
        string7 = file.isAbsolute() ? string5 : String.valueOf(string3) + File.separator + string5;
        try {
            System.out.println(String.valueOf(LogBrowser.getLBString("ComIbmIvbLogMsgGenLogXml")) + " " + string6);
            System.out.flush();
            if (string == null) {
                String string8 = String.valueOf(DtdDirName) + "/" + DTDNAME;
                LogFile.convertToXML(string6, string7, string8);
            } else {
                RootNode rootNode = new RootNode();
                LogFile logFile = new LogFile(string6);
                logFile.populateTree(rootNode);
                RecordFilterNode recordFilterNode = rootNode.getRecordFilterNode(string);
                LogFile logFile2 = new LogFile(recordFilterNode);
                logFile2.saveAsXML(string7);
            }
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(LogBrowser.getLBString("ComIbmIvbLogMsgCannotGenXml")) + " " + string7);
            System.err.flush();
            System.exit(1);
        }
        System.exit(0);
    }
}

