/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.analyzers;

import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.analyzers.MapFile;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import com.ibm.ivb.log.datamodel.XmlUtils;
import com.ibm.ivb.log.ui.LogBrowser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class GpfAnalyzer
implements Analyzer {
    protected static final int LOOKFORREGISTERS = 0;
    protected static final int LOOKFORINTELSEGMENT = 1;
    protected static final int LOOKFORINTELGP = 2;
    protected static final int LOOKFORERROR = 3;
    protected static final int LOOKFORIP = 4;
    protected static final int LOOKFORDLLNAME = 5;
    protected static final int STACKUNWIND = 6;
    protected static final int STACKENTRYBASE = 7;
    protected static final int STACKENTRYRETADDR = 8;
    protected static final int STACKENTRYDLLNAME = 9;
    protected static final int MODULELIST = 10;
    protected static final int DLLSIZE = 11;
    protected static final int DLLLOADADDR = 12;
    protected static final int PARSEDONE = 81;
    protected static final int PARSEERROR = 666;
    protected static final int NT_PLATFORM = 0;
    protected static final int AIX_PLATFORM = 1;
    protected static final int SUN_PLATFORM = 2;
    private String analyzerName;
    protected String mapDir;
    protected Hashtable mapFiles;
    protected String tempDir;
    protected int platform = 0;

    private void setTempDir(String string) {
        this.tempDir = string;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector parseExceptionInfo(Vector var1_1) {
        var2_2 = new Hashtable<String, DllEntry>();
        var3_3 = new Vector<StackEntry>();
        var4_4 = null;
        var5_5 = null;
        var6_6 = 0L;
        var8_7 = 0L;
        var10_8 = 0L;
        var12_9 = null;
        var13_10 = null;
        var14_11 = null;
        var15_12 = null;
        var16_13 = null;
        var17_14 = 0;
        var18_15 = 0;
        var19_16 = 0;
        if (var1_1.size() == 0) {
            return null;
        }
        this.platform = 0;
        var20_17 = (String)var1_1.elementAt(var17_14);
        try lbl-1000:
        // 35 sources

        {
            block17: while (var20_17 != null && var19_16 < 81) {
                if (var17_14 == 20 && var19_16 == 0) {
                    var19_16 = 666;
                }
                switch (var19_16) {
                    case 0: {
                        if (var20_17.indexOf("registers") != 0) {
                            var19_16 = 3;
                        }
                        var20_17 = (String)var1_1.elementAt(++var17_14);
                        ** break;
                    }
                    case 3: {
                        if (var20_17.startsWith("Error ")) {
                            var4_4 = new StringTokenizer(var20_17.substring(6));
                            if (var4_4.hasMoreTokens()) {
                                var5_5 = var4_4.nextToken();
                                var19_16 = 4;
                                ** break;
                            }
                            var19_16 = 666;
                            ** break;
                        }
                        var20_17 = (String)var1_1.elementAt(++var17_14);
                        ** break;
                    }
                    case 4: {
                        if (var5_5.startsWith("(Eip)")) {
                            var6_6 = Long.parseLong(var5_5.substring(6, var5_5.length() - 1), 16);
                            if (var4_4.hasMoreTokens()) {
                                var5_5 = var4_4.nextToken();
                                var19_16 = 5;
                                ** break;
                            }
                            var19_16 = 666;
                            ** break;
                        }
                        if (var5_5.startsWith("(IAR)")) {
                            if (var4_4.hasMoreTokens()) {
                                var5_5 = var4_4.nextToken();
                                var6_6 = Long.parseLong(var5_5, 16);
                                var19_16 = 5;
                                this.platform = 1;
                                ** break;
                            }
                            var19_16 = 666;
                            ** break;
                        }
                        if (var4_4.hasMoreTokens()) {
                            var5_5 = var4_4.nextToken();
                            ** break;
                        }
                        var19_16 = 666;
                        ** break;
                    }
                    case 5: {
                        if (var5_5.startsWith("file:")) {
                            if (this.platform == 0) {
                                var12_9 = new String(var5_5.substring(5));
                            } else if (this.platform == 1) {
                                if (var4_4.hasMoreTokens()) {
                                    var5_5 = var4_4.nextToken();
                                    var12_9 = new String(var5_5);
                                } else {
                                    var19_16 = 666;
                                    ** break;
                                }
                            }
                            var19_16 = 6;
                            var15_12 = new StackEntry();
                            var15_12.retAddr = var6_6;
                            var13_10 = var12_9;
                            var14_11 = "/";
                            if (this.platform == 0) {
                                var14_11 = "\\";
                            }
                            if ((var18_15 = var12_9.lastIndexOf(var14_11)) != -1) {
                                var13_10 = var12_9.substring(var18_15 + 1);
                            }
                            var15_12.mapName = var13_10;
                            if (this.platform == 1 && (var21_18 = var13_10.indexOf(".")) != (var22_19 = var13_10.lastIndexOf("."))) {
                                if (var13_10.indexOf(".a") == var21_18) {
                                    var23_20 = var13_10.substring(0, var21_18 + 2);
                                    var24_21 = var13_10.substring(var21_18 + 2);
                                    var13_10 = new String(String.valueOf(var23_20) + "[" + var24_21 + "]");
                                    var12_9 = var18_15 > 0 ? new String(String.valueOf(var12_9.substring(0, var18_15 + 1)) + var13_10) : var13_10;
                                    var15_12.mapName = var24_21;
                                } else if (var13_10.indexOf(".so") == var21_18) {
                                    var23_20 = var13_10.substring(0, var21_18 + 3);
                                    var24_21 = var13_10.substring(var21_18 + 3);
                                    var13_10 = new String(String.valueOf(var23_20) + "[" + var24_21 + "]");
                                    var12_9 = var18_15 > 0 ? new String(String.valueOf(var12_9.substring(0, var18_15 + 1)) + var13_10) : var13_10;
                                    var15_12.mapName = var24_21;
                                }
                            }
                            var15_12.dllName = var12_9;
                            var15_12.shortName = var13_10;
                            var3_3.addElement(var15_12);
                            var20_17 = (String)var1_1.elementAt(++var17_14);
                            ** break;
                        }
                        var5_5 = var4_4.nextToken();
                        if (var5_5 != null) ** break;
                        var19_16 = 666;
                        ** break;
                    }
                    case 6: {
                        if (var20_17.indexOf("stack unwind") != -1) {
                            var20_17 = (String)var1_1.elementAt(++var17_14);
                            var19_16 = 7;
                            ** break;
                        }
                        var19_16 = 666;
                        ** break;
                    }
                    case 7: {
                        var4_4 = new StringTokenizer(var20_17);
                        if (var4_4.hasMoreTokens()) {
                            var5_5 = var4_4.nextToken();
                            if (var4_4.hasMoreTokens()) {
                                var5_5 = var4_4.nextToken();
                                var19_16 = 8;
                                ** break;
                            }
                            var19_16 = 10;
                            var20_17 = (String)var1_1.elementAt(++var17_14);
                            ** break;
                        }
                        var19_16 = 10;
                        var20_17 = (String)var1_1.elementAt(++var17_14);
                        ** break;
                    }
                    case 8: {
                        try {
                            var8_7 = Long.parseLong(var5_5.substring(1), 16);
                            var5_5 = var4_4.nextToken();
                            if (var5_5 != null) {
                                if (var5_5.equals("-")) {
                                    var5_5 = var4_4.nextToken();
                                    if (var5_5 != null) {
                                        var19_16 = 9;
                                        ** break;
                                    }
                                    var19_16 = 666;
                                    ** break;
                                }
                                var19_16 = 666;
                                ** break;
                            }
                            var19_16 = 666;
                        }
                        catch (NumberFormatException v0) {
                            var20_17 = (String)var1_1.elementAt(var17_14 += 2);
                            var19_16 = 10;
                        }
                        continue block17;
                    }
                    case 9: {
                        var12_9 = var5_5.equals(")") != false ? "" : new String(var5_5.substring(0, var5_5.length() - 1));
                        var15_12 = new StackEntry();
                        var15_12.retAddr = var8_7;
                        var13_10 = var12_9;
                        var14_11 = "/";
                        if (this.platform == 0) {
                            var14_11 = "\\";
                        }
                        if ((var18_15 = var12_9.lastIndexOf(var14_11)) != -1) {
                            var13_10 = var12_9.substring(var18_15 + 1);
                        }
                        var15_12.mapName = var13_10;
                        if (this.platform == 1 && (var21_18 = var13_10.indexOf(".")) != (var22_19 = var13_10.lastIndexOf("."))) {
                            if (var13_10.indexOf(".a") == var21_18) {
                                var23_20 = var13_10.substring(0, var21_18 + 2);
                                var24_21 = var13_10.substring(var21_18 + 2);
                                var13_10 = new String(String.valueOf(var23_20) + "[" + var24_21 + "]");
                                var12_9 = var18_15 > 0 ? new String(String.valueOf(var12_9.substring(0, var18_15 + 1)) + var13_10) : var13_10;
                                var15_12.mapName = var24_21;
                            } else if (var13_10.indexOf(".so") == var21_18) {
                                var23_20 = var13_10.substring(0, var21_18 + 3);
                                var24_21 = var13_10.substring(var21_18 + 3);
                                var13_10 = new String(String.valueOf(var23_20) + "[" + var24_21 + "]");
                                var12_9 = var18_15 > 0 ? new String(String.valueOf(var12_9.substring(0, var18_15 + 1)) + var13_10) : var13_10;
                                var15_12.mapName = var24_21;
                            }
                        }
                        var15_12.dllName = var12_9;
                        var15_12.shortName = var13_10;
                        var3_3.addElement(var15_12);
                        var20_17 = (String)var1_1.elementAt(++var17_14);
                        var19_16 = 7;
                        ** break;
                    }
                    case 10: {
                        if (var20_17.startsWith("Module")) {
                            if ((var20_17 = (String)var1_1.elementAt(++var17_14)) == null) {
                                var19_16 = 666;
                                ** break;
                            }
                            var19_16 = 11;
                            ** break;
                        }
                        var20_17 = (String)var1_1.elementAt(++var17_14);
                        ** break;
                    }
                    case 11: {
                        var4_4 = new StringTokenizer(var20_17);
                        if (var4_4.hasMoreTokens()) {
                            var5_5 = var4_4.nextToken();
                            if (var4_4.hasMoreTokens()) {
                                var5_5 = var4_4.nextToken();
                                var19_16 = 12;
                                ** break;
                            }
                            var19_16 = 81;
                            ** break;
                        }
                        var19_16 = 81;
                        ** break;
                    }
                    case 12: {
                        var10_8 = Long.parseLong(var5_5.substring(1, var5_5.length() - 1), 16);
                        var21_18 = var20_17.lastIndexOf("=> ");
                        if (var21_18 == -1) ** break;
                        var12_9 = new String(var20_17.substring(var21_18 + 3));
                        var16_13 = new DllEntry();
                        var16_13.dllName = var12_9;
                        var16_13.loadAddr = var10_8;
                        var13_10 = var12_9;
                        var14_11 = "/";
                        if (this.platform == 0) {
                            var14_11 = "\\";
                        }
                        if ((var18_15 = var12_9.lastIndexOf(var14_11)) != -1) {
                            var13_10 = var12_9.substring(var18_15 + 1);
                        }
                        var16_13.shortName = var13_10;
                        var2_2.put(var13_10, var16_13);
                        var20_17 = (String)var1_1.elementAt(++var17_14);
                        var19_16 = 11;
                        ** break;
                    }
                }
            }
        }
        catch (Exception v1) {}
        if (var19_16 == 666 || var20_17 == null) {
            return null;
        }
        var21_18 = var3_3.size();
        var17_14 = 0;
        while (var17_14 < var21_18) {
            var15_12 = (StackEntry)var3_3.elementAt(var17_14);
            var16_13 = (DllEntry)var2_2.get(var15_12.shortName);
            if (var16_13 != null) {
                var15_12.offset = var15_12.retAddr - var16_13.loadAddr;
                var15_12.methodName = this.mapDir != null ? this.parseMapFile(var15_12.offset, var15_12.mapName) : "No map file directory is specified.";
            } else {
                var15_12.methodName = new String("Cannot locate module: " + var15_12.shortName);
            }
            ++var17_14;
        }
        return var3_3;
    }

    protected String toHexString(long l) {
        String string = Long.toHexString(l);
        String string2 = "";
        int n = string.length() < 8 ? 8 - string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            string2 = String.valueOf(string2) + "0";
            ++n2;
        }
        return new String(String.valueOf(string2) + string);
    }

    protected String formatResults(Vector vector) {
        String string = "";
        String string2 = null;
        if (vector.size() == 0) {
            return string;
        }
        StackEntry stackEntry = (StackEntry)vector.elementAt(0);
        string = String.valueOf(string) + "Error Address " + this.toHexString(stackEntry.retAddr) + " " + stackEntry.dllName + "(" + this.toHexString(stackEntry.offset) + ") :\n" + stackEntry.methodName + "\n\n";
        string = String.valueOf(string) + "Call Stack Unwind\n\nReturn addr Module(Offset) Method\n\n";
        int n = 1;
        while (n < vector.size()) {
            stackEntry = (StackEntry)vector.elementAt(n);
            string = String.valueOf(string) + this.toHexString(stackEntry.retAddr) + " - " + stackEntry.dllName + "(" + this.toHexString(stackEntry.offset) + ") :\n" + stackEntry.methodName + "\n";
            ++n;
        }
        string2 = this.mapFiles != null ? new String(this.demangleString(string)) : new String(string);
        return string2;
    }

    protected void stringToFile(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            printWriter = new PrintWriter(fileOutputStream);
            if (printWriter == null) {
                fileOutputStream.close();
                throw new IOException();
            }
            printWriter.print(string);
            printWriter.flush();
            printWriter.close();
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter2 = new PrintWriter(byteArrayOutputStream);
            iOException.printStackTrace(printWriter2);
            printWriter2.flush();
            String string3 = byteArrayOutputStream.toString();
            System.err.println(string3);
            System.err.flush();
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotCrtTmpFile"));
            System.err.flush();
            printWriter2.close();
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {}
            }
            printWriter.close();
            return;
        }
    }

    protected String fileToString(String string) {
        File file = new File(string);
        FileReader fileReader = null;
        String string2 = "";
        try {
            fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = String.valueOf(string2) + string3 + "\n";
            }
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            String string4 = byteArrayOutputStream.toString();
            System.err.println(string4);
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotReadDemangledOutput"));
            System.err.flush();
        }
        return string2;
    }

    protected String demangleString(String string) {
        String string2 = string;
        String string3 = "";
        String string4 = String.valueOf(this.tempDir) + "/_lb1.tmp";
        String string5 = String.valueOf(this.tempDir) + "/_lb2.tmp";
        try {
            this.stringToFile(string, string4);
        }
        catch (IOException iOException) {
            return string2;
        }
        String string6 = new String("lbcppfilt " + string4 + " " + string5);
        try {
            Process process = Runtime.getRuntime().exec(string6);
            process.waitFor();
            string3 = this.fileToString(string5);
        }
        catch (Exception exception) {
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotStartCPPFILT"));
            System.err.flush();
        }
        if (!string3.equals("")) {
            string2 = string3;
        }
        return string2;
    }

    protected String parseMapFile(long l, String string) {
        String string2;
        try {
            int n = string.lastIndexOf(".");
            string2 = n == -1 ? String.valueOf(string) + ".map" : String.valueOf(string.substring(0, n)) + ".map";
        }
        catch (Exception exception) {
            return "Could not resolve map filename from dllname :" + string;
        }
        String string3 = (String)this.mapFiles.get(string2.toLowerCase());
        if (string3 == null) {
            return new String("Map file " + string2 + " cannot be found");
        }
        try {
            MapFile mapFile = new MapFile(new String(String.valueOf(this.mapDir) + "/" + string3), this.platform);
            return mapFile.findMatchingCall((int)l);
        }
        catch (IOException iOException) {
            return "Cannot open map file: " + string3;
        }
    }

    protected Hashtable getMapFiles(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            File file = new File(string);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().endsWith(".map")) {
                    hashtable.put(stringArray[n].toLowerCase(), stringArray[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            String string2 = byteArrayOutputStream.toString();
            System.err.println(string2);
            System.err.flush();
            System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotReadMapfiles"));
            System.err.flush();
            return null;
        }
        return hashtable;
    }

    public void setParameter(String string) {
        if (this.mapDir == null || !this.mapDir.equals(string)) {
            this.mapDir = new String(string);
            this.mapFiles = null;
        }
    }

    public GpfAnalyzer(String string) {
        this.analyzerName = string;
    }

    public void setAnalyzerName(String string) {
        this.analyzerName = new String(string);
    }

    public void analyze(Record record) {
        String string = "";
        LogRecMetadata logRecMetadata = (LogRecMetadata)record.getRecordMetadata();
        if (logRecMetadata.getGpfStatus() != null) {
            if (logRecMetadata.getGpfStatus().equals("diagnosed")) {
                string = XmlUtils.StringVecToText(logRecMetadata.getGpfDatav());
                record.setStatus(Record.Status.diagnosed);
            } else if (record.getSeverity() > 2) {
                record.setStatus(Record.Status.nothing);
            } else {
                record.setStatus(Record.Status.mystery);
            }
            record.setAnalysisResults(this.analyzerName, string);
            return;
        }
        if (this.mapDir != null && this.mapFiles == null) {
            this.mapFiles = this.getMapFiles(this.mapDir);
        }
        if (record.getSeverity() != 1) {
            if (record.getSeverity() > 2) {
                record.setStatus(Record.Status.nothing);
                logRecMetadata.setGpfStatus("nothing");
            } else {
                record.setStatus(Record.Status.mystery);
                logRecMetadata.setGpfStatus("mystery");
            }
            record.setAnalysisResults(this.analyzerName, "");
            return;
        }
        if (!logRecMetadata.getFunctionName().startsWith("handleSignal")) {
            record.setAnalysisResults(this.analyzerName, "");
            record.setStatus(Record.Status.mystery);
            logRecMetadata.setGpfStatus("mystery");
            return;
        }
        String string2 = logRecMetadata.getExtendedMessage();
        if (string2 == null || string2.indexOf("OS signal") == -1) {
            record.setStatus(Record.Status.mystery);
            record.setAnalysisResults(this.analyzerName, "");
            logRecMetadata.setGpfStatus("mystery");
            return;
        }
        Vector vector = logRecMetadata.getExtendedMessagev();
        if (vector == null) {
            record.setStatus(Record.Status.mystery);
            record.setAnalysisResults(this.analyzerName, "");
            logRecMetadata.setGpfStatus("mystery");
            return;
        }
        Vector vector2 = this.parseExceptionInfo(vector);
        string = this.formatResults(vector2);
        record.setStatus(Record.Status.diagnosed);
        record.setAnalysisResults(this.analyzerName, string);
        logRecMetadata.setGpfStatus("diagnosed");
        logRecMetadata.setGpfDatav(XmlUtils.TextToStringVec(string));
    }

    public String getAnalyzerName() {
        return this.analyzerName;
    }

    public static class Factory
    implements Analyzer.Factory {
        private String analyzerName;
        private String tempDir;

        public Factory() {
            String string = AppModel.getTempDir();
            if (string == null) {
                this.tempDir = new String(".");
                return;
            }
            this.tempDir = string;
        }

        public void setAnalyzerName(String string) {
            this.analyzerName = new String(string);
        }

        public Analyzer make() {
            GpfAnalyzer gpfAnalyzer = new GpfAnalyzer(this.analyzerName);
            gpfAnalyzer.setTempDir(this.tempDir);
            return gpfAnalyzer;
        }
    }

    public class StackEntry {
        public String dllName;
        public String shortName;
        public long retAddr;
        public long offset;
        public String mapName;
        public String methodName;

        public StackEntry() {
            GpfAnalyzer.this = GpfAnalyzer.this;
        }
    }

    public class DllEntry {
        public String dllName;
        public String shortName;
        public long loadAddr;

        public DllEntry() {
            GpfAnalyzer.this = GpfAnalyzer.this;
        }
    }
}

