/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Action;
import com.ibm.ivb.jface.BrowserFrame;
import com.ibm.ivb.jface.LinkEvent;
import com.ibm.ivb.jface.Tool;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.ui.LogView;
import com.ibm.ivb.log.ui.RecordTool;
import com.ibm.ivb.log.ui.UIConstants;
import com.ibm.ivb.log.ui.events.AnalysisEvent;

public class AnalyzeAction
extends Action
implements UIConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public AnalyzeAction(Tool tool) {
        this.setTool(tool);
    }

    public synchronized void run() {
        Node[] nodeArray = this.getTargetNodes();
        if (nodeArray != null) {
            BrowserFrame browserFrame = this.getTool().getParentFrame();
            if (nodeArray.length == 1) {
                Node node = nodeArray[0];
                node.analyze();
                if (node.isLeaf() && node instanceof RecordNode) {
                    RecordNode recordNode = (RecordNode)node;
                    String string = recordNode.getAnalysisResult("Symptom Analyzer");
                    String string2 = recordNode.getAnalysisResult("OrbTrace Analyzer");
                    String string3 = recordNode.getAnalysisResult("Minor Code Analyzer");
                    String string4 = recordNode.getAnalysisResult("Msgid Analyzer");
                    browserFrame.fireLinkEvent((LinkEvent)new AnalysisEvent(browserFrame, string, string2, string3, string4));
                    return;
                }
                browserFrame.fireLinkEvent((LinkEvent)new AnalysisEvent(browserFrame));
                return;
            }
            int n = 0;
            while (n < nodeArray.length) {
                nodeArray[n].analyze();
                ++n;
            }
            browserFrame.fireLinkEvent((LinkEvent)new AnalysisEvent(browserFrame));
        }
    }

    private Node[] getTargetNodes() {
        Tool tool = this.getTool();
        if (tool instanceof LogView) {
            return ((LogView)tool).getSelectedNodes();
        }
        if (tool instanceof RecordTool) {
            return new Node[]{((RecordTool)tool).getNode()};
        }
        return null;
    }
}

