/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.HelpHandler;
import com.ibm.ivb.log.ui.HelpConstants;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.SearchableInformation;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.util.ComboBoxTextField;
import com.ibm.ivb.log.ui.util.LocationHelper;
import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Action;
import com.sun.java.swing.ComboBoxEditor;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.DocumentListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class FindAndReplaceDialog
extends JDialog
implements TranslatableConstants,
HelpConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static String findTarget = "";
    private static int findCursor;
    private static String findNewStr;
    private static boolean findForward;
    private static boolean findWrap;
    private static boolean findCase;
    private static boolean findWord;
    private static boolean findNextEnabled;
    private static FindAndReplaceDialog dialogShown;
    private SearchableInformation infoPanel;
    private boolean enableReplace;
    protected JPanel pane = new JPanel(true);
    private GridBagConstraints gbc = new GridBagConstraints();
    private JLabel lbFind;
    private ComboBoxTextField cbFindEditor;
    private JComboBox cbFind;
    private JLabel lbReplace;
    private ComboBoxTextField cbReplaceEditor;
    private JComboBox cbReplace;
    private JButton btFind;
    private JButton btFindPrev;
    private JButton btReplace;
    private JButton btReplacePrev;
    private JButton btReplaceAll;
    protected JLabel lbReplaceAllStatus = new JLabel(" ");
    private JPanel choices = new JPanel((LayoutManager)new FlowLayout(0, 10, 0));
    private JCheckBox cbCase;
    private JCheckBox cbWord;
    private JCheckBox cbWrap;
    private JPanel dialogButtons = new JPanel((LayoutManager)new FlowLayout(0, 10, 0));
    private JButton btAddReplace;
    private JButton btDone;
    private JButton btHelp;
    private static Vector findData;
    private static Vector replaceData;

    public FindAndReplaceDialog(JFrame jFrame, SearchableInformation searchableInformation, boolean bl) {
        super((Frame)jFrame, false);
        if (dialogShown != null) {
            if (!this.enableReplace && bl) {
                dialogShown.addReplaceActions();
            }
            ((Window)((Object)dialogShown)).toFront();
            return;
        }
        this.infoPanel = searchableInformation;
        this.enableReplace = bl;
        this.createControls();
        if (!this.enableReplace) {
            ((Dialog)((Object)this)).setTitle(LogBrowser.getLBString("ComIbmIvbLogUiTitleFarFind"));
        } else {
            ((Dialog)((Object)this)).setTitle(LogBrowser.getLBString("ComIbmIvbLogUiTitleFarReplace"));
        }
        ((Window)((Object)this)).addWindowListener(new WindowMonitor());
        this.getContentPane().add((Component)this.pane);
        ((Window)((Object)this)).pack();
        LocationHelper.centerDialog(this, (Component)jFrame);
        if (this.btFind.isEnabled()) {
            this.getRootPane().setDefaultButton(this.btFind);
            this.btFind.requestFocus();
        } else {
            this.getRootPane().setDefaultButton(this.btDone);
            this.cbFindEditor.requestFocus();
        }
        ((Dialog)((Object)this)).show();
        dialogShown = this;
    }

    public static boolean canFindAgain() {
        return findNextEnabled;
    }

    public void displayHelp() {
        HelpHandler helpHandler = LogBrowser.getLBApplication().getHelpHandler();
        if (this.canReplace()) {
            helpHandler.showURL(helpHandler.getURLName("ComIbmIvbLogUiHlpReplace"));
            return;
        }
        helpHandler.showURL(helpHandler.getURLName("ComIbmIvbLogUiHlpFind"));
    }

    public boolean canReplace() {
        return this.enableReplace;
    }

    public static void findAgain(SearchableInformation searchableInformation) {
        int n = searchableInformation.getSearchStart(findForward);
        int n2 = searchableInformation.search(findTarget, n, findForward, findWrap, findCase, findWord);
        searchableInformation.processRepeatSearchResult(n2, findTarget);
    }

    protected static void handleNoMatch() {
        Toolkit.getDefaultToolkit().beep();
    }

    protected static void handleNoMatch(Component component) {
        component.getToolkit().beep();
        JOptionPane.showMessageDialog((Component)component, (Object)LogBrowser.getLBString("ComIbmIvbLogUiMsgNoMatch"), (String)LogBrowser.getLBString("ComIbmIvbLogUiTitleInfoMsgBox"), (int)1);
    }

    private void createControls() {
        this.lbFind = new JLabel(LogBrowser.getLBString("ComIbmIvbLogUiFarOld"));
        this.lbReplace = new JLabel(LogBrowser.getLBString("ComIbmIvbLogUiFarNew"));
        this.cbFindEditor = new ComboBoxTextField(30);
        this.cbReplaceEditor = new ComboBoxTextField(30);
        this.cbFind = new JComboBox(findData);
        this.cbReplace = new JComboBox(replaceData);
        this.cbFind.setEditor((ComboBoxEditor)this.cbFindEditor);
        this.cbReplace.setEditor((ComboBoxEditor)this.cbReplaceEditor);
        this.cbFind.setEditable(true);
        this.cbReplace.setEditable(true);
        if (this.infoPanel.hasSelection()) {
            this.addToDataTop(this.infoPanel.getSelection(), findData, this.cbFind);
        }
        if (this.cbFind.getItemCount() > 0) {
            this.cbFind.setSelectedIndex(0);
        }
        if (this.cbReplace.getItemCount() > 0) {
            this.cbReplace.setSelectedIndex(0);
        }
        FocusMonitor focusMonitor = new FocusMonitor();
        ((Component)((Object)this.cbFindEditor)).addFocusListener(focusMonitor);
        ((Component)((Object)this.cbReplaceEditor)).addFocusListener(focusMonitor);
        this.cbFindEditor.getDocument().addDocumentListener((DocumentListener)new FindTextMonitor());
        int n = this.cbFind.getMaximumSize().height;
        this.cbFind.setMaximumSize(new Dimension(500, n));
        this.cbReplace.setMaximumSize(new Dimension(500, n));
        KeyStroke keyStroke = KeyStroke.getKeyStroke((int)9, (int)0);
        this.cbFindEditor.getKeymap().removeKeyStrokeBinding(keyStroke);
        this.cbFindEditor.getKeymap().addActionForKeyStroke(keyStroke, (Action)new TextFieldTabAction(this.cbFindEditor));
        this.cbReplaceEditor.getKeymap().removeKeyStrokeBinding(keyStroke);
        this.cbReplaceEditor.getKeymap().addActionForKeyStroke(keyStroke, (Action)new TextFieldTabAction(this.cbReplaceEditor));
        this.btFind = new JButton(LogBrowser.getLBString("ComIbmIvbLogUiFarFind"));
        this.btFindPrev = new JButton(LogBrowser.getLBString("ComIbmIvbLogUiFarFindPrev"));
        this.btReplace = new JButton(LogBrowser.getLBString("ComIbmIvbLogUiFarReplace"));
        this.btReplacePrev = new JButton(LogBrowser.getLBString("ComIbmIvbLogUiFarReplacePrev"));
        this.btReplaceAll = new JButton(LogBrowser.getLBString("ComIbmIvbLogUiFarReplaceAll"));
        FARActionMonitor fARActionMonitor = new FARActionMonitor();
        this.btFind.addActionListener((ActionListener)fARActionMonitor);
        this.btFindPrev.addActionListener((ActionListener)fARActionMonitor);
        this.btReplace.addActionListener((ActionListener)fARActionMonitor);
        this.btReplacePrev.addActionListener((ActionListener)fARActionMonitor);
        this.btReplaceAll.addActionListener((ActionListener)fARActionMonitor);
        this.setAvailability();
        this.cbWord = new JCheckBox(LogBrowser.getLBString("ComIbmIvbLogUiFarWholeWord"));
        this.cbCase = new JCheckBox(LogBrowser.getLBString("ComIbmIvbLogUiFarMatchCase"));
        this.cbWrap = new JCheckBox(LogBrowser.getLBString("ComIbmIvbLogUiFarWrap"));
        this.cbWrap.setSelected(findWrap);
        this.cbCase.setSelected(findCase);
        this.cbWord.setSelected(findWord);
        this.choices.add((Component)this.cbCase);
        this.choices.add((Component)this.cbWord);
        this.choices.add((Component)this.cbWrap);
        this.btAddReplace = new JButton(LogBrowser.getLBString("ComIbmIvbLogUiFarAdd_Replace"));
        this.btDone = new JButton(LogBrowser.getLBString("ComIbmIvbLogUiFarDone"));
        this.btHelp = new JButton(LogBrowser.getLBString("ComIbmIvbLogUiFarHelp"));
        if (!this.enableReplace) {
            this.dialogButtons.add((Component)this.btAddReplace);
        }
        this.btAddReplace.addActionListener((ActionListener)new AddReplaceMonitor());
        this.btAddReplace.setEnabled(this.infoPanel.isEditable());
        this.dialogButtons.add((Component)this.btDone);
        this.dialogButtons.add((Component)this.btHelp);
        CloseActionMonitor closeActionMonitor = new CloseActionMonitor();
        this.btDone.addActionListener((ActionListener)closeActionMonitor);
        this.btDone.registerKeyboardAction((ActionListener)closeActionMonitor, KeyStroke.getKeyStroke((int)27, (int)0), 2);
        HelpButtonMonitor helpButtonMonitor = new HelpButtonMonitor();
        this.btHelp.addActionListener((ActionListener)helpButtonMonitor);
        this.btHelp.registerKeyboardAction((ActionListener)helpButtonMonitor, KeyStroke.getKeyStroke((int)112, (int)0), 2);
        this.pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.addToGridBag(this.pane, (Component)this.lbFind, gridBagConstraints, 0, 0);
        gridBagConstraints.weightx = 10.0;
        this.addToGridBag(this.pane, (Component)this.cbFind, gridBagConstraints, 1, 0);
        gridBagConstraints.weightx = 1.0;
        this.addToGridBag(this.pane, (Component)this.btFind, gridBagConstraints, 2, 0);
        this.addToGridBag(this.pane, (Component)this.btFindPrev, gridBagConstraints, 3, 0);
        if (this.enableReplace) {
            this.addToGridBag(this.pane, (Component)this.lbReplace, gridBagConstraints, 0, 1);
            gridBagConstraints.weightx = 10.0;
            this.addToGridBag(this.pane, (Component)this.cbReplace, gridBagConstraints, 1, 1);
            gridBagConstraints.weightx = 1.0;
            this.addToGridBag(this.pane, (Component)this.btReplace, gridBagConstraints, 2, 1);
            this.addToGridBag(this.pane, (Component)this.btReplacePrev, gridBagConstraints, 3, 1);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.addToGridBag(this.pane, (Component)this.btReplaceAll, gridBagConstraints, 2, 2, 2, 1);
            gridBagConstraints.insets = new Insets(5, 10, 0, 10);
            this.addToGridBag(this.pane, (Component)this.lbReplaceAllStatus, gridBagConstraints, 2, 3, 2, 1);
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.addToGridBag(this.pane, (Component)this.choices, gridBagConstraints, 0, 4, 4, 1);
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagConstraints.anchor = 15;
        this.addToGridBag(this.pane, (Component)this.dialogButtons, gridBagConstraints, 0, 5, 4, 1);
    }

    private void addToGridBag(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    private void addToGridBag(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2) {
        this.addToGridBag(jPanel, component, gridBagConstraints, n, n2, 1, 1);
    }

    private void setAvailability() {
        boolean bl = this.cbFindEditor.getText().length() > 0;
        this.btFind.setEnabled(bl);
        this.btFindPrev.setEnabled(bl);
        boolean bl2 = bl && this.enableReplace;
        this.cbReplace.setEnabled(bl2);
        this.btReplace.setEnabled(bl2);
        this.btReplacePrev.setEnabled(bl2);
        this.btReplaceAll.setEnabled(bl2);
    }

    private void addReplaceActions() {
        boolean bl = this.cbWrap.isSelected();
        boolean bl2 = this.cbCase.isSelected();
        boolean bl3 = this.cbWord.isSelected();
        this.enableReplace = true;
        ((Component)((Object)this)).setVisible(false);
        this.dialogButtons.remove((Component)this.btAddReplace);
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(10, 10, 0, 10);
        this.gbc.anchor = 11;
        this.addToGridBag(this.pane, (Component)this.lbReplace, this.gbc, 0, 1);
        this.gbc.weightx = 10.0;
        this.addToGridBag(this.pane, (Component)this.cbReplace, this.gbc, 1, 1);
        this.gbc.weightx = 1.0;
        this.addToGridBag(this.pane, (Component)this.btReplace, this.gbc, 2, 1);
        this.addToGridBag(this.pane, (Component)this.btReplacePrev, this.gbc, 3, 1);
        this.gbc.fill = 0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(10, 10, 0, 10);
        this.addToGridBag(this.pane, (Component)this.btReplaceAll, this.gbc, 2, 2, 2, 1);
        this.gbc.insets = new Insets(5, 10, 0, 10);
        this.addToGridBag(this.pane, (Component)this.lbReplaceAllStatus, this.gbc, 2, 3, 2, 1);
        ((Dialog)((Object)this)).setTitle(LogBrowser.getLBString("ComIbmIvbLogUiTitleFarReplace"));
        this.setAvailability();
        this.cbWrap.setSelected(bl);
        this.cbCase.setSelected(bl2);
        this.cbWord.setSelected(bl3);
        ((Window)((Object)this)).pack();
        ((Dialog)((Object)this)).show();
    }

    private void addToDataTop(String string, Vector vector, JComboBox jComboBox) {
        if (vector.size() > 0 && vector.contains(string)) {
            vector.removeElement(string);
            jComboBox.removeItem((Object)string);
        }
        vector.insertElementAt(string, 0);
        jComboBox.insertItemAt((Object)string, 0);
    }

    private void closeWindow(Window window) {
        window.dispose();
        dialogShown = null;
    }

    private void findAnother() {
        int n = this.infoPanel.search(findTarget, findCursor, findForward, findWrap, findCase, findWord);
        this.infoPanel.processSearchResult(n, findTarget);
        this.lbReplaceAllStatus.setText(" ");
    }

    private void replaceAnother() {
        this.infoPanel.searchAndReplace(findTarget, findCursor, findForward, findWrap, findCase, findWord, findNewStr);
        this.lbReplaceAllStatus.setText(" ");
    }

    private void replaceAll() {
        int n = 0;
        int n2 = 0;
        int n3 = this.infoPanel.search(findTarget, n2, true, false, findCase, findWord);
        while (n3 != -1) {
            this.infoPanel.processReplace(n3, findTarget.length(), findNewStr);
            ++n;
            n2 = n3 + findNewStr.length() - 1;
            n3 = this.infoPanel.search(findTarget, n2, true, false, findCase, findWord);
        }
        String string = " ";
        if (n == 0) {
            FindAndReplaceDialog.handleNoMatch((Component)this.pane);
        } else if (n == 1) {
            string = LogBrowser.getLBString("ComIbmIvbLogUiFarReplaceAllInfo1");
        } else {
            String string2 = LogBrowser.getLBString("ComIbmIvbLogUiFarReplaceAllInfoM");
            int n4 = string2.indexOf("%1");
            if (n4 > -1) {
                string = String.valueOf(string2.substring(0, n4)) + Integer.toString(n) + string2.substring(n4 + 2);
            }
        }
        if (n > 0) {
            this.lbReplaceAllStatus.setText(string);
            this.pane.invalidate();
            this.pane.validate();
        }
    }

    static /* synthetic */ boolean access$5() {
        return findWrap;
    }

    static /* synthetic */ boolean access$8() {
        return findCase;
    }

    static /* synthetic */ boolean access$11() {
        return findWord;
    }

    static /* synthetic */ int access$20() {
        return findCursor;
    }

    static {
        findNewStr = "";
        findForward = true;
        dialogShown = null;
        findData = new Vector();
        replaceData = new Vector();
    }

    class FindTextMonitor
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument().getLength() == documentEvent.getLength()) {
                FindAndReplaceDialog.this.setAvailability();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (documentEvent.getDocument().getLength() == 0) {
                FindAndReplaceDialog.this.setAvailability();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        FindTextMonitor() {
            FindAndReplaceDialog.this = FindAndReplaceDialog.this;
        }
    }

    class FARActionMonitor
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            findTarget = FindAndReplaceDialog.this.cbFindEditor.getText();
            FindAndReplaceDialog.this.addToDataTop(findTarget, findData, FindAndReplaceDialog.this.cbFind);
            findWrap = FindAndReplaceDialog.this.cbWrap.isSelected();
            findCase = FindAndReplaceDialog.this.cbCase.isSelected();
            findWord = FindAndReplaceDialog.this.cbWord.isSelected();
            Object object = actionEvent.getSource();
            if (object == FindAndReplaceDialog.this.btFind || object == FindAndReplaceDialog.this.btReplace) {
                findForward = true;
            } else if (object == FindAndReplaceDialog.this.btFindPrev || object == FindAndReplaceDialog.this.btReplacePrev) {
                findForward = false;
            }
            if (object == FindAndReplaceDialog.this.btFind || object == FindAndReplaceDialog.this.btFindPrev) {
                findCursor = FindAndReplaceDialog.this.infoPanel.getSearchStart(findForward);
            } else if (object == FindAndReplaceDialog.this.btReplace || object == FindAndReplaceDialog.this.btReplacePrev) {
                findCursor = FindAndReplaceDialog.this.infoPanel.getReplaceStart();
            }
            if (object == FindAndReplaceDialog.this.btReplace || object == FindAndReplaceDialog.this.btReplacePrev || object == FindAndReplaceDialog.this.btReplaceAll) {
                findNewStr = FindAndReplaceDialog.this.cbReplaceEditor.getText();
                FindAndReplaceDialog.this.addToDataTop(findNewStr, replaceData, FindAndReplaceDialog.this.cbReplace);
            }
            if (object == FindAndReplaceDialog.this.btFind) {
                FindAndReplaceDialog.this.findAnother();
            } else if (object == FindAndReplaceDialog.this.btFindPrev) {
                FindAndReplaceDialog.this.findAnother();
            } else if (object == FindAndReplaceDialog.this.btReplace) {
                FindAndReplaceDialog.this.replaceAnother();
            } else if (object == FindAndReplaceDialog.this.btReplacePrev) {
                FindAndReplaceDialog.this.replaceAnother();
            } else if (object == FindAndReplaceDialog.this.btReplaceAll) {
                FindAndReplaceDialog.this.replaceAll();
            }
            if (!findNextEnabled) {
                findNextEnabled = true;
            }
        }

        FARActionMonitor() {
            FindAndReplaceDialog.this = FindAndReplaceDialog.this;
        }
    }

    class AddReplaceMonitor
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FindAndReplaceDialog.this.addReplaceActions();
        }

        AddReplaceMonitor() {
            FindAndReplaceDialog.this = FindAndReplaceDialog.this;
        }
    }

    class CloseActionMonitor
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FindAndReplaceDialog.this.closeWindow((Window)((Object)FindAndReplaceDialog.this));
        }

        CloseActionMonitor() {
            FindAndReplaceDialog.this = FindAndReplaceDialog.this;
        }
    }

    class HelpButtonMonitor
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FindAndReplaceDialog.this.displayHelp();
        }

        HelpButtonMonitor() {
            FindAndReplaceDialog.this = FindAndReplaceDialog.this;
        }
    }

    class WindowMonitor
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            FindAndReplaceDialog.this.closeWindow(windowEvent.getWindow());
        }

        WindowMonitor() {
            FindAndReplaceDialog.this = FindAndReplaceDialog.this;
        }
    }

    class FocusMonitor
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == FindAndReplaceDialog.this.cbFindEditor) {
                FindAndReplaceDialog.this.cbFindEditor.selectAll();
                return;
            }
            if (object == FindAndReplaceDialog.this.cbReplaceEditor) {
                FindAndReplaceDialog.this.cbReplaceEditor.selectAll();
            }
        }

        FocusMonitor() {
            FindAndReplaceDialog.this = FindAndReplaceDialog.this;
        }
    }

    class TextFieldTabAction
    extends AbstractAction {
        ComboBoxTextField tf;

        TextFieldTabAction(ComboBoxTextField comboBoxTextField) {
            FindAndReplaceDialog.this = FindAndReplaceDialog.this;
            this.tf = comboBoxTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("Tabbing in text field");
            this.tf.replaceSelection("\t");
        }
    }
}

