/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.CharConversionException;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.PlatformFont;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.OffScreenImageSource;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WImage;
import sun.awt.windows.WPrintGraphics;
import sun.awt.windows.WPrintJob;
import sun.io.CharToByteConverter;

public class WGraphics
extends Graphics {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    int pData;
    Color foreground;
    Font font;
    boolean fontSet;
    int originX;
    int originY;
    private sun.awt.image.Image image;
    private boolean disposed = false;

    private native void createFromComponent(WComponentPeer var1);

    private native void createFromGraphics(WGraphics var1);

    private native void createFromPrintJob(WPrintJob var1);

    private native void createFromHDC(int var1);

    private native void imageCreate(ImageRepresentation var1);

    private native void pSetFont(Font var1);

    private native void pSetForeground(int var1);

    WGraphics(WPrintJob wPrintJob) {
        this.createFromPrintJob(wPrintJob);
    }

    WGraphics(WGraphics wGraphics) {
        this.createFromGraphics(wGraphics);
    }

    WGraphics(WComponentPeer wComponentPeer) {
        this.createFromComponent(wComponentPeer);
    }

    WGraphics(int n) {
        this.createFromHDC(n);
    }

    public WGraphics(WImage wImage) {
        OffScreenImageSource offScreenImageSource = (OffScreenImageSource)wImage.getSource();
        this.imageCreate(offScreenImageSource.getImageRep());
        this.image = wImage;
    }

    public Graphics create() {
        WGraphics wGraphics = new WGraphics(this);
        wGraphics.foreground = this.foreground;
        wGraphics.font = this.font;
        wGraphics.originX = this.originX;
        wGraphics.originY = this.originY;
        wGraphics.image = this.image;
        return wGraphics;
    }

    public void translate(int n, int n2) {
        this.originX += n;
        this.originY += n2;
    }

    protected native void disposeImpl();

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            WGraphics wGraphics = this;
            synchronized (wGraphics) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    public void finalize() {
        this.dispose();
        super.finalize();
    }

    public void setFont(Font font) {
        if (font != null && this.font != font) {
            this.font = font;
            if (this instanceof WPrintGraphics) {
                this.pSetFont(font);
                this.fontSet = true;
                return;
            }
            this.fontSet = false;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    public void setColor(Color color) {
        if (color != null && color != this.foreground) {
            this.foreground = color;
            this.pSetForeground(color.getRGB());
        }
    }

    public Color getColor() {
        return this.foreground;
    }

    public native void setPaintMode();

    public native void setXORMode(Color var1);

    public native Rectangle getClipBounds();

    private native void changeClip(int var1, int var2, int var3, int var4, boolean var5);

    private native void removeClip();

    public void clipRect(int n, int n2, int n3, int n4) {
        this.changeClip(n, n2, n3, n4, false);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.changeClip(n, n2, n3, n4, true);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public void setClip(Shape shape) {
        if (shape == null) {
            this.removeClip();
            return;
        }
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.changeClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            return;
        }
        throw new IllegalArgumentException("setClip(Shape) only supports Rectangle objects");
    }

    public native void clearRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public void drawString(String string, int n, int n2) {
        if (!this.fontSet && this.font != null) {
            this.pSetFont(this.font);
            this.fontSet = true;
        }
        this.drawChars(string.toCharArray(), 0, string.length(), n, n2);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        PlatformFont platformFont;
        if (!this.fontSet && this.font != null) {
            this.pSetFont(this.font);
            this.fontSet = true;
        }
        if ((platformFont = (PlatformFont)this.font.getPeer()).mightHaveMultiFontMetrics()) {
            if (this.tryDrawMFCharsAll(cArray, n, n2, n3, n4, this.font) != 0) {
                this.drawMFChars(cArray, n, n2, n3, n4, this.font, platformFont);
                return;
            }
        } else {
            this.drawSFChars(cArray, n, n2, n3, n4);
        }
    }

    private native void drawSFChars(char[] var1, int var2, int var3, int var4, int var5);

    private native int tryDrawMFCharsAll(char[] var1, int var2, int var3, int var4, int var5, Font var6);

    private void drawMFChars(char[] cArray, int n, int n2, int n3, int n4, Font font, PlatformFont platformFont) {
        if (n2 == 0) {
            return;
        }
        CharsetString[] charsetStringArray = platformFont.makeMultiCharsetString(cArray, n, n2);
        byte[] byArray = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < charsetStringArray.length) {
            CharsetString charsetString = charsetStringArray[n7];
            if (WFontMetrics.needsConversion(font, charsetString.fontDescriptor)) {
                try {
                    int n8 = charsetString.fontDescriptor.fontCharset.getMaxBytesPerChar() * charsetString.length;
                    if (n8 > n5) {
                        n5 = n8;
                        byArray = new byte[n5];
                    }
                    CharToByteConverter charToByteConverter = (CharToByteConverter)charsetString.fontDescriptor.fontCharset.getClass().newInstance();
                    int n9 = charToByteConverter.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                    n6 += this.drawMFCharsConvertedSegment(font, charsetString.fontDescriptor, byArray, n9, n3 + n6, n4);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (CharConversionException charConversionException) {}
            } else {
                n6 += this.drawMFCharsSegment(font, charsetString.fontDescriptor, charsetString.charsetChars, charsetString.offset, charsetString.length, n3 + n6, n4);
            }
            ++n7;
        }
    }

    private native int drawMFCharsSegment(Font var1, FontDescriptor var2, char[] var3, int var4, int var5, int var6, int var7);

    private native int drawMFCharsConvertedSegment(Font var1, FontDescriptor var2, byte[] var3, int var4, int var5, int var6);

    public native void drawBytes2(byte[] var1, int var2, int var3, int var4, int var5);

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        if (!this.fontSet && this.font != null) {
            this.pSetFont(this.font);
            this.fontSet = true;
        }
        this.drawBytes2(byArray, n, n2, n3, n4);
    }

    public native void drawLine(int var1, int var2, int var3, int var4);

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawImage(this, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawScaledImage(this, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawImage(this, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawScaledImage(this, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        if (n == n3 || n2 == n4) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawStretchImage(this, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (n == n3 || n2 == n4) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawStretchImage(this, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawPolygon(int[] var1, int[] var2, int var3);

    public native void drawPolyline(int[] var1, int[] var2, int var3);

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.originX + "," + this.originY + "]";
    }

    native void print(WComponentPeer var1);
}

