/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Certificate;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Signer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS8Key;
import sun.security.pkcs.SignerInfo;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.util.BigInt;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertException;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509Cert;
import sun.security.x509.X509Key;
import sun.tools.jar.Manifest;
import sun.tools.jar.SignatureFile;

public class Main {
    private boolean debug = false;
    private boolean quitOnError = false;
    String program;
    String usage;
    PrintStream out;
    PrintStream err;
    InputStream in;
    protected IdentityScope scope;

    public Main(PrintStream printStream, PrintStream printStream2, InputStream inputStream, String string, boolean bl) {
        this.out = printStream;
        this.err = printStream2;
        this.program = string;
        this.quitOnError = bl;
    }

    protected void setScope(IdentityScope identityScope) {
        this.scope = identityScope;
    }

    void listCmd(String[] stringArray) {
        String string = stringArray[0];
        boolean bl = false;
        if (string.equals("li")) {
            if (stringArray.length != 2) {
                this.listUsage();
                return;
            }
            Identity identity = this.scope.getIdentity(stringArray[1]);
            if (identity == null) {
                this.error("No such identity: " + stringArray[1] + " in scope " + this.scope);
                return;
            }
            this.list(identity);
            return;
        }
        if (string.equals("l") || (bl = string.equals("ld"))) {
            if (stringArray.length != 1) {
                this.listUsage();
            }
            this.list(bl);
            return;
        }
        this.listUsage();
    }

    void listUsage() {
        String string = "";
        string = String.valueOf(string) + "legal options for list:\n";
        string = String.valueOf(string) + "\tno argument \tlist all identities in succint form.\n";
        string = String.valueOf(string) + "\ti <identity>\tlist an identity in detail.\n";
        string = String.valueOf(string) + "\td\t\tdetail: list all identities in detail.";
        this.out.println(string);
        this.error("illegal arguments to list");
    }

    public boolean list(boolean bl) {
        this.out.println();
        this.out.println("Scope: " + this.scope);
        Enumeration enumeration = this.scope.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            this.out.println();
            this.out.println(identity.toString(bl));
        }
        return true;
    }

    public void list(Identity identity) {
        this.out.println("Identity: " + identity.getName());
        this.out.println(identity.toString(true));
    }

    void createCmd(String[] stringArray) {
        String string;
        boolean bl;
        boolean bl2 = false;
        String string2 = stringArray[0];
        boolean bl3 = false;
        int n = stringArray.length;
        boolean bl4 = string2.equalsIgnoreCase("c");
        boolean bl5 = string2.equalsIgnoreCase("cs");
        boolean bl6 = bl = n == 2 || n == 3;
        if (n == 3) {
            bl3 = new Boolean(stringArray[2]);
        }
        if (bl && bl4) {
            bl2 = this.createIdentity(stringArray[1], bl3);
        } else if (bl && bl5) {
            bl2 = this.createSigner(stringArray[1], bl3);
        } else {
            string = "";
            string = String.valueOf(string) + "legal options for create:\n";
            string = String.valueOf(string) + "\tno arguments\t<name> {trusted}\tcreate a new identity.\n";
            string = String.valueOf(string) + "\ts\t\t<name> {trusted}\tcreate a new signer.\n";
            this.out.println(string);
            this.error("illegal arguments to create");
        }
        if (bl2) {
            string = "Created identity " + this.scope.getIdentity(stringArray[1]);
            this.save(this.scope, string);
        }
    }

    public boolean createIdentity(String string, boolean bl) {
        try {
            SystemIdentity systemIdentity = new SystemIdentity(string, this.scope);
            this.scope.addIdentity(systemIdentity);
            systemIdentity.setTrusted(bl);
        }
        catch (KeyManagementException keyManagementException) {
            return this.error("An error occured trying to add " + string + " to " + this.scope, keyManagementException);
        }
        catch (InvalidParameterException invalidParameterException) {
            return this.error("Invalid parameter trying to add " + string + " to " + this.scope, invalidParameterException);
        }
        return true;
    }

    public boolean createSigner(String string, boolean bl) {
        try {
            if (this.scope.getIdentity(string) != null) {
                return this.error("Name conflict. Please remove the identity named " + string + " before adding a new identity with that name.");
            }
            SystemSigner systemSigner = new SystemSigner(string, this.scope);
            this.scope.addIdentity(systemSigner);
            systemSigner.setTrusted(bl);
        }
        catch (KeyManagementException keyManagementException) {
            return this.error("An error occured trying to add " + string + " to " + this.scope, keyManagementException);
        }
        return true;
    }

    protected void removeCmd(String[] stringArray) {
        String string = "";
        boolean bl = false;
        if (stringArray.length == 2) {
            string = stringArray[1];
            bl = this.scope.getIdentity(string) == null ? this.error("No one named " + string + " in the system.") : this.remove(string);
        } else {
            String string2 = "";
            string2 = String.valueOf(string2) + "legal options for remove:\n";
            string2 = String.valueOf(string2) + "\tno arguments\t<name>\tthe name of the identity to remove\n";
            this.out.println(string2);
            bl = this.error("illegal arguments to remove");
        }
        if (bl) {
            this.save(this.scope, "Removed " + string + ".");
        }
    }

    public boolean remove(String string) {
        try {
            Identity identity = this.scope.getIdentity(string);
            if (identity == null) {
                return this.error(String.valueOf(string) + " not found in database.");
            }
            this.scope.removeIdentity(identity);
        }
        catch (KeyManagementException keyManagementException) {
            return this.internalError("remove " + string);
        }
        return true;
    }

    protected void exportCmd(String[] stringArray) {
        boolean bl = false;
        String string = "";
        String string2 = stringArray[0];
        int n = stringArray.length;
        if (n < 3 || n > 4) {
            this.exportUsageError();
            return;
        }
        String string3 = stringArray[1];
        if (string2.equals("ek")) {
            File file = new File(stringArray[2]);
            File file2 = null;
            if (stringArray.length == 4) {
                file2 = new File(stringArray[3]);
            }
            bl = this.exportKeys(string3, file, file2);
            string = "Public key exported to " + file + ".";
            if (file2 != null) {
                string = String.valueOf(string) + "\nPrivate key exported to " + file2 + ".";
            }
        } else if (string2.equals("ec")) {
            if (n != 4) {
                this.exportUsageError();
            }
            int n2 = Integer.parseInt(stringArray[2]);
            File file = new File(stringArray[3]);
            bl = this.exportCert(string3, n2, file);
            string = "Certificate " + n2 + " exported to " + file + ".";
        } else {
            this.exportUsageError();
        }
        if (bl) {
            this.save(this.scope, string);
        }
    }

    boolean exportKeys(String string, File file, File file2) {
        try {
            BufferedOutputStream bufferedOutputStream;
            FileOutputStream fileOutputStream;
            Serializable serializable;
            Identity identity = this.scope.getIdentity(string);
            if (identity == null) {
                return this.error("There are no identities named " + string + " in the system.");
            }
            if (identity instanceof Identity) {
                serializable = identity.getPublicKey();
                if (serializable == null) {
                    return this.error("identity " + string + " does not have a public key.");
                }
                fileOutputStream = new FileOutputStream(file);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                bufferedOutputStream.write(serializable.getEncoded());
                bufferedOutputStream.flush();
                fileOutputStream.close();
            }
            if (identity instanceof Signer && file2 != null) {
                serializable = (Signer)identity;
                fileOutputStream = new FileOutputStream(file2);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                PrivateKey privateKey = ((Signer)serializable).getPrivateKey();
                if (privateKey == null) {
                    return this.error("signer " + string + " does not have a private key.");
                }
                bufferedOutputStream.write(privateKey.getEncoded());
                bufferedOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            this.error("Error: io error", iOException);
        }
        return true;
    }

    boolean exportCert(String string, int n, File file) {
        try {
            Identity identity = this.scope.getIdentity(string);
            if (identity == null) {
                return this.error("There are no identities named " + string + " in the system.");
            }
            Certificate[] certificateArray = identity.certificates();
            if (certificateArray.length < n) {
                return this.error("identity " + string + " does not have a cert " + n + ".");
            }
            Certificate certificate = certificateArray[n - 1];
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            certificate.encode(bufferedOutputStream);
            bufferedOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            return this.error("Error: io error", iOException);
        }
        catch (KeyException keyException) {
            return this.error("Key exception: invalid key", keyException);
        }
        return true;
    }

    private boolean exportUsageError() {
        String string = "";
        string = String.valueOf(string) + "legal options for export (<id> is the identity for which the import is done.)\n";
        string = String.valueOf(string) + "\tk\t<id> <pub> {priv}\t\texport a public key,\n\t\t (and optionally a private key) to a file.\n";
        string = String.valueOf(string) + "\tc\t<id> <certnum> <certFile>\texport a cert to a  files.\n";
        this.out.println(string);
        return this.error("illegal arguments to export.");
    }

    protected void importCmd(String[] stringArray) {
        boolean bl = false;
        String string = "";
        String string2 = stringArray[0];
        int n = stringArray.length;
        if (n < 2 || n > 4) {
            this.importUsageError();
            return;
        }
        String string3 = stringArray[1];
        String string4 = "";
        if (n > 2) {
            string4 = stringArray[2];
        }
        if (string2.equals("ic")) {
            bl = this.importCertificate(string3, string4);
            if (bl) {
                string = "Imported certificate from " + string4 + " for " + string3 + ".";
            }
        } else if (string2.equals("ik")) {
            bl = this.importPublicKey(string3, string4);
            if (bl) {
                string = "Set public key from " + string4 + " for " + string3 + ".";
            }
        } else if (string2.equals("ikp") && n == 4) {
            bl = this.setKeyPair(string3, string4, stringArray[3]);
            if (bl) {
                string = "Set public key from " + string4 + " for " + string3 + ".";
                string = String.valueOf(string) + "\nSet private key from " + stringArray[3] + " for " + string3 + ".";
            }
        } else if (string2.equals("ii") && n == 2) {
            bl = this.setInfo(string3);
            if (bl) {
                string = "Set information for " + string3;
            }
        } else {
            bl = this.importUsageError();
        }
        if (bl) {
            this.save(this.scope, string);
        }
    }

    private boolean importUsageError() {
        String string = "";
        string = String.valueOf(string) + "legal options for import (<id> is the identity for which the import is done.)\n";
        string = String.valueOf(string) + "\tk\t<id> <pub>\t\timport a public key from a file.\n";
        string = String.valueOf(string) + "\tkp\t<id> <pub> <priv>\timport a key pair from two files.\n";
        string = String.valueOf(string) + "\tc\t<id> <cert>\t\timport a certificate from a file.\n";
        this.out.println(string);
        return this.error("illegal arguments to import.");
    }

    private boolean setInfo(String string) {
        Identity identity = this.scope.getIdentity(string);
        if (identity == null) {
            return this.error("There are no identities named " + identity + " in the system.");
        }
        this.out.println("Please enter the info for this identity.");
        this.out.println("[End with ctrl-D on Unix and ctrl-Z on Win32]");
        DataInputStream dataInputStream = new DataInputStream(System.in);
        String string2 = "";
        String string3 = "";
        try {
            while ((string3 = dataInputStream.readLine()) != null) {
                string2 = String.valueOf(string2) + "\n" + string3;
            }
        }
        catch (IOException iOException) {
            this.debug(iOException);
            return this.error("IOException importing information.");
        }
        identity.setInfo(string2);
        return true;
    }

    public boolean importCertificate(String string, String string2) {
        Identity identity = null;
        try {
            if (string2 == null || string2.length() == 0) {
                return this.error("Certificate file missing");
            }
            File file = new File(string2);
            if (!file.exists()) {
                return this.error("File " + string2 + "  not found.");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            X509Cert x509Cert = new X509Cert(byArray);
            identity = this.scope.getIdentity(string);
            if (identity == null) {
                return this.error(String.valueOf(string) + " not found in the system.");
            }
            this.importCertificate(identity, x509Cert);
        }
        catch (IOException iOException) {
            return this.error("Error: io error", iOException);
        }
        catch (KeyManagementException keyManagementException) {
            return this.error("key management exception: " + keyManagementException, keyManagementException);
        }
        catch (CertException certException) {
            return this.error("invalid cert: " + string2, certException);
        }
        return true;
    }

    boolean importCertificate(Identity identity, Certificate certificate) throws KeyManagementException {
        PublicKey publicKey = certificate.getPublicKey();
        PublicKey publicKey2 = identity.getPublicKey();
        if (publicKey2 == null) {
            identity.setPublicKey(publicKey);
        } else if (!publicKey2.equals(publicKey)) {
            return this.error("Certificate key does not match identity key.");
        }
        identity.addCertificate(certificate);
        return true;
    }

    boolean importPublicKey(String string, String string2) {
        try {
            Identity identity = this.scope.getIdentity(string);
            if (identity == null) {
                return this.error(String.valueOf(string) + " not found in database.");
            }
            if (identity instanceof Signer) {
                return this.error("Cannot import public key for signer " + string + " (can only import keypair)");
            }
            if (string2 == null || string2.length() == 0) {
                return this.error("Public-key file missing");
            }
            File file = new File(string2);
            if (!file.exists()) {
                return this.error("File " + string2 + " not found.");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            DerValue derValue = new DerValue(byArray);
            X509Key x509Key = X509Key.parse(derValue);
            PublicKey publicKey = identity.getPublicKey();
            if (publicKey != null && !x509Key.equals(publicKey)) {
                this.message(String.valueOf(identity) + " already has a public key." + "\nClearing any exisiting certificates...\n");
                Certificate[] certificateArray = identity.certificates();
                int n = 0;
                while (n < certificateArray.length) {
                    identity.removeCertificate(certificateArray[n]);
                    ++n;
                }
            }
            identity.setPublicKey(x509Key);
        }
        catch (IOException iOException) {
            return this.error("Error: io error", iOException);
        }
        catch (KeyException keyException) {
            return this.error("Key exception: invalid key", keyException);
        }
        return true;
    }

    boolean setKeyPair(String string, String string2, String string3) {
        try {
            if (string2 == null || string2.length() == 0) {
                return this.error("Public-key file missing");
            }
            File file = new File(string2);
            if (string3 == null || string3.length() == 0) {
                return this.error("Private-key file missing");
            }
            File file2 = new File(string3);
            if (!file.exists()) {
                return this.error("File " + file + " not found.");
            }
            if (!file2.exists()) {
                return this.error("File " + file2 + " not found.");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            fileInputStream.close();
            DerValue derValue = new DerValue(byArray);
            X509Key x509Key = X509Key.parse(derValue);
            fileInputStream = new FileInputStream(file2);
            dataInputStream = new DataInputStream(fileInputStream);
            byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            fileInputStream.close();
            derValue = new DerValue(byArray);
            PKCS8Key pKCS8Key = PKCS8Key.parse(derValue);
            KeyPair keyPair = new KeyPair(x509Key, pKCS8Key);
            return this.setKeyPair(string, keyPair);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    boolean setKeyPair(String string, KeyPair keyPair) {
        try {
            Identity identity = this.scope.getIdentity(string);
            if (identity == null) {
                return this.error("Identity " + string + " not found in system.");
            }
            if (!(identity instanceof Signer)) {
                return this.error("Identity " + identity + " not a signer");
            }
            Signer signer = (Signer)identity;
            signer.setKeyPair(keyPair);
        }
        catch (KeyException keyException) {
            return this.error("Key exception: invalid key", keyException);
        }
        catch (InvalidParameterException invalidParameterException) {
            return this.error("Internal error!", invalidParameterException);
        }
        return true;
    }

    private void save(IdentityScope identityScope, String string) {
        if (identityScope instanceof IdentityDatabase) {
            try {
                IdentityDatabase identityDatabase = (IdentityDatabase)identityScope;
                identityDatabase.save();
            }
            catch (IOException iOException) {
                this.error("IOException trying to save the database.", iOException);
            }
        } else {
            this.out.println("Cannot save the database: not a SUN database.");
        }
        this.exit(string);
    }

    private void save(IdentityScope identityScope) {
        this.save(identityScope, "Operation succesful.");
    }

    private void generateCmd(String[] stringArray) {
        String string;
        boolean bl;
        block24: {
            Object object;
            bl = false;
            string = "";
            String string2 = stringArray[0];
            int n = stringArray.length;
            Properties properties = new Properties();
            File file = null;
            if (n == 2 || n == 3) {
                file = new File(stringArray[1]);
                try {
                    object = new FileInputStream(file);
                    properties.load((InputStream)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.error("directive file " + file + " not found.");
                }
                catch (IOException iOException) {
                    this.error("IOException loading directive file " + file);
                }
            }
            if (string2.equals("gk") || string2.equals("g")) {
                if (n == 2) {
                    bl = this.generateKeyPair(properties);
                } else if (n < 7 && n > 3) {
                    properties.put("signer.name", stringArray[1]);
                    properties.put("algorithm", stringArray[2]);
                    properties.put("strength", stringArray[3]);
                    if (n > 4) {
                        properties.put("pub", stringArray[4]);
                    }
                    if (n > 5) {
                        properties.put("priv", stringArray[5]);
                    }
                    bl = this.generateKeyPair(properties);
                }
                string = "Generated " + properties.get("algorithm") + " keys for " + properties.get("signer.name") + " (strength: " + properties.get("strength") + ").";
                object = properties.getProperty("pub");
                String string3 = properties.getProperty("priv");
                if (object != null) {
                    string = String.valueOf(string) + "\nSaved public key to " + (String)object + ".";
                }
                if (string3 != null) {
                    string = String.valueOf(string) + "\nSaved private key to " + string3 + ".";
                }
            } else if (string2.equals("gc")) {
                if (n != 2) {
                    this.usageError("generate certificate only takes one argument, the directive file.");
                } else {
                    bl = this.generateCertificate(properties);
                    string = "Generated certificate from directive file " + file + ".";
                }
            } else if (string2.equals("gs")) {
                try {
                    if (stringArray.length != 3) {
                        this.usageError("wrong number of arguments. gs takes 2 arguments: the directive and jar file.");
                        break block24;
                    }
                    object = new File(stringArray[2]);
                    if (!((File)object).exists()) {
                        this.error("JAR file " + object + " not found.");
                    }
                    bl = this.signJar(properties, (File)object);
                    string = "Signed JAR file " + object + " using directive file " + file + ".";
                }
                catch (Exception exception) {
                    this.error("error generating signature: " + exception, exception);
                }
            } else {
                this.generateUsageError();
            }
        }
        if (bl) {
            this.save(this.scope, string);
        }
    }

    private boolean generateUsageError() {
        String string = "";
        string = String.valueOf(string) + "legal options for generate:\n";
        string = String.valueOf(string) + "\tk\t<id> <alg> <mod>\t\tgenerate a key pair.\n";
        string = String.valueOf(string) + "\tc\t<certdir> \tgenerate a certificate.\n";
        string = String.valueOf(string) + "\ts\t<sigdir> <file>\t\tgenerate a signature.\n";
        this.out.println(string);
        return this.error("illegal arguments to generate.");
    }

    boolean generateCertificate(Properties properties) {
        int n = -1;
        BigInt bigInt = null;
        Date date = null;
        Date date2 = null;
        Object object = null;
        PrivateKey privateKey = null;
        X509Key x509Key = null;
        String string = "DSA";
        try {
            Object object2;
            Object object3;
            Serializable serializable;
            String string2 = this.assertProp("issuer.name", properties);
            String string3 = this.assertProp("subject.name", properties);
            String string4 = null;
            boolean bl = string2.equals(string3);
            if (!bl) {
                string4 = this.assertProp("issuer.cert", properties);
            }
            String string5 = this.assertProp("subject.real.name", properties);
            String string6 = this.assertProp("subject.org.unit", properties);
            String string7 = this.assertProp("subject.org", properties);
            String string8 = this.assertProp("subject.country", properties);
            String string9 = this.assertProp("start.date", properties);
            String string10 = this.assertProp("end.date", properties);
            String string11 = this.assertProp("serial.number", properties);
            string = properties.getProperty("signature.algorithm");
            X500Name x500Name = new X500Name(string5, string6, string7, string8);
            try {
                date = new Date(string9);
                date2 = new Date(string10);
                serializable = new Date();
                if (((Date)serializable).after(date2)) {
                    this.out.println("warning: certificate's expiration date is earlier than the current date.");
                }
                if (date2.before(date)) {
                    this.out.println("warning: certificate's expiration date is earlier than the start date.");
                }
                if (!bl) {
                    n = Integer.parseInt(string4) - 1;
                }
                object3 = new BigInteger(string11);
                bigInt = new BigInt(((BigInteger)object3).toByteArray());
            }
            catch (NumberFormatException numberFormatException) {
                return this.error("Error parsing issuer.cert number.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return this.error("Date formatted incorrectly.");
            }
            catch (Exception exception) {
                this.debug(exception);
                return this.error("error signing: " + exception.getMessage());
            }
            serializable = (Signer)this.scope.getIdentity(string2);
            if (serializable == null) {
                return this.error("no signer " + string2 + " found in the database.");
            }
            privateKey = ((Signer)serializable).getPrivateKey();
            if (privateKey == null) {
                return this.error(String.valueOf(serializable) + " does not have a private key.");
            }
            if (string == null) {
                string = "DSA";
            }
            if (!bl) {
                object3 = ((Identity)serializable).certificates();
                if (n < ((Certificate[])object3).length) {
                    object2 = object3[n];
                    if (object2 == null || !(object2 instanceof X509Cert)) {
                        return this.error("invalid cert for signer");
                    }
                    object = (X509Cert)object2;
                } else {
                    return this.error("No such cert: " + (n + 1) + " for issuer " + serializable + ".");
                }
            }
            try {
                Object object4;
                if (privateKey == null) {
                    return this.error("Signer " + serializable + " has no signing key.");
                }
                object3 = this.scope.getIdentity(string3);
                if (serializable == null) {
                    return this.error("No such guarantor: " + string2);
                }
                if (object3 == null) {
                    return this.error("No such identity: " + string3);
                }
                object2 = ((Identity)object3).getPublicKey();
                if (object2 == null) {
                    return this.error(String.valueOf(object3) + " does not have a public key.");
                }
                if (!object2.getFormat().equals("X.509")) {
                    return this.error("Public key format is not X.509");
                }
                try {
                    if (object2 instanceof X509Key) {
                        x509Key = (X509Key)object2;
                    } else {
                        object4 = new DerValue(object2.getEncoded());
                        x509Key = X509Key.parse((DerValue)object4);
                    }
                }
                catch (IOException iOException) {
                    return this.error("Bad X509 key: " + iOException, iOException);
                }
                object4 = new X509Cert(x500Name, x509Key, date, date2);
                if (bl) {
                    object = object4;
                }
                AlgorithmId algorithmId = AlgorithmId.get(string);
                X500Signer x500Signer = ((X509Cert)object).getSigner(algorithmId, privateKey);
                byte[] byArray = ((X509Cert)object4).encodeAndSign(bigInt, x500Signer);
                X509Cert x509Cert = new X509Cert(byArray);
                ((Identity)object3).addCertificate(x509Cert);
                String string12 = properties.getProperty("out.file");
                if (string12 != null) {
                    File file = new File(string12);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    x509Cert.encode(fileOutputStream);
                }
            }
            catch (IOException iOException) {
                return this.error("IO exception during cert signing", iOException);
            }
            catch (SignatureException signatureException) {
                return this.error("A signature exception occured", signatureException);
            }
            catch (KeyException keyException) {
                return this.error("A key exception occured", keyException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return this.error("algorithm " + string + " not available", noSuchAlgorithmException);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    boolean generateKeyPair(Properties properties) {
        Identity identity;
        String string = this.assertProp("signer.name", properties);
        String string2 = this.assertProp("strength", properties);
        String string3 = this.assertProp("algorithm", properties);
        String string4 = properties.getProperty("provider");
        String string5 = properties.getProperty("pub");
        String string6 = properties.getProperty("priv");
        if (string4 != null) {
            string4 = string4.trim();
        }
        if (string5 != null) {
            string5 = string5.trim();
        }
        if (string6 != null) {
            string6 = string6.trim();
        }
        if ((identity = this.scope.getIdentity(string)) == null) {
            this.error(String.valueOf(string) + " not found in system.");
        } else if (!(identity instanceof Signer)) {
            this.error("Identity " + identity + " not a signer.");
        } else {
            File file;
            Signer signer = (Signer)identity;
            int n = Integer.parseInt(string2);
            this.machineSeed(64);
            KeyPairGenerator keyPairGenerator = null;
            KeyPair keyPair = null;
            try {
                keyPairGenerator = KeyPairGenerator.getInstance(string3, string4);
                keyPairGenerator.initialize(n, new SecureRandom());
                keyPair = keyPairGenerator.generateKeyPair();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return this.error("Algorithm " + string3 + " not available.");
            }
            catch (Exception exception) {
                return this.error("Invalid algorithm params for key generation.", exception);
            }
            try {
                signer.setKeyPair(keyPair);
            }
            catch (InvalidParameterException invalidParameterException) {
                this.err.println("Internal error!");
                invalidParameterException.printStackTrace(this.err);
            }
            catch (KeyException keyException) {
                this.err.println("Internal error!");
                keyException.printStackTrace(this.err);
            }
            if (string5 != null && string5.length() != 0) {
                file = new File(string5);
                if (!this.saveKey(keyPair.getPublic(), file)) {
                    this.error("error saving public key to file " + file);
                }
            }
            if (string6 != null && string6.length() != 0) {
                file = new File(string6);
                if (!this.saveKey(keyPair.getPrivate(), file)) {
                    this.error("error saving private key to file " + file);
                }
            }
            return true;
        }
        return false;
    }

    private boolean saveKey(Key key, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(key.getEncoded());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            return this.error("IOException saving keys.", iOException);
        }
        catch (ClassCastException classCastException) {
            return this.error("Not a SUN key- cannot save", classCastException);
        }
        return true;
    }

    boolean signJar(Properties properties, File file) throws Exception {
        String string = this.assertProp("signature.file", properties);
        if (string == null) {
            return false;
        }
        string = string.toUpperCase();
        String string2 = file.getName();
        String string3 = properties.getProperty("out.file");
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (string3 == null || string3.equals(string2)) {
            string3 = String.valueOf(string2) + ".sig";
        }
        File file2 = new File(string3);
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PrintStream printStream = new PrintStream(fileOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(printStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        String string4 = ("META-INF/" + string + ".SF").toUpperCase();
        String string5 = ("META-INF/" + string + ".DSA").toUpperCase();
        while (zipEntry != null) {
            if (Manifest.isManifestName(zipEntry.getName())) {
                byte[] byArray = this.getBytesToEOF(zipInputStream);
                Manifest manifest = new Manifest(byArray);
                this.writeEntry(new ByteArrayInputStream(byArray), zipOutputStream, zipEntry);
                SignatureFile signatureFile = this.computeSignatures(manifest, properties);
                if (signatureFile == null) {
                    return false;
                }
                PKCS7 pKCS7 = signatureFile.getBlock();
                string4 = signatureFile.getName();
                string5 = signatureFile.getBlockName();
                ZipEntry zipEntry2 = new ZipEntry(signatureFile.getName());
                ZipEntry zipEntry3 = new ZipEntry(signatureFile.getBlockName());
                Date date = new Date();
                zipEntry2.setTime(date.getTime());
                zipEntry3.setTime(date.getTime());
                zipOutputStream.putNextEntry(zipEntry2);
                signatureFile.stream(zipOutputStream);
                this.out.println("Creating entry: " + zipEntry2.getName());
                zipOutputStream.putNextEntry(zipEntry3);
                pKCS7.encodeSignedData(zipOutputStream);
                this.out.println("Creating entry: " + zipEntry3.getName());
            } else if (zipEntry.getName().equalsIgnoreCase(string4) || zipEntry.getName().equalsIgnoreCase(string5)) {
                this.out.println("(Replaced existing entry: " + zipEntry.getName() + ")");
            } else {
                this.writeEntry(zipInputStream, zipOutputStream, zipEntry);
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        zipOutputStream.close();
        return true;
    }

    private byte[] getBytesToEOF(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void writeEntry(InputStream inputStream, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        this.out.println("Adding entry: " + zipEntry.getName());
        byte[] byArray = this.getBytesToEOF(inputStream);
        zipOutputStream.putNextEntry(zipEntry);
        if (byArray.length > 0) {
            zipOutputStream.write(byArray);
        }
    }

    SignatureFile computeSignatures(Manifest manifest, Properties properties) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        Certificate[] certificateArray;
        String string = this.assertProp("signature.file", properties);
        String string2 = this.assertProp("signer", properties);
        String string3 = this.assertProp("cert", properties);
        String string4 = this.assertProp("chain", properties);
        Identity identity = this.scope.getIdentity(string2);
        Signer signer = null;
        if (identity == null) {
            this.error(String.valueOf(string2) + " not found in database.");
            return null;
        }
        if (!(identity instanceof Signer)) {
            this.error(String.valueOf(identity) + " is not a Signer.");
            return null;
        }
        signer = (Signer)identity;
        PrivateKey privateKey = signer.getPrivateKey();
        if (privateKey == null) {
            this.error(String.valueOf(signer) + " does not have a public key.");
            return null;
        }
        int n = 0;
        if (string4 != null) {
            n = Integer.parseInt(string4);
        }
        if (string3 == null) {
            this.error("illegal directive file");
            return null;
        }
        if (string.length() > 8) {
            this.error("signature file specified longer than 8 characters.");
            return null;
        }
        int n2 = Integer.parseInt(string3);
        if (n2 > (certificateArray = signer.certificates()).length || n2 < 1) {
            this.error("Invalid cert number (" + n2 + "). Valid numbers are 1 through " + certificateArray.length + ".");
            return null;
        }
        Certificate certificate = certificateArray[n2 - 1];
        if (!(certificate instanceof X509Cert)) {
            this.error("only X509 certificate format supported for signing JAR");
            return null;
        }
        SignatureFile signatureFile = new SignatureFile(manifest, string);
        PKCS7 pKCS7 = this.computePKCS7(signatureFile, privateKey, (X509Cert)certificate);
        signatureFile.setBlock(pKCS7);
        return signatureFile;
    }

    private PKCS7 computePKCS7(SignatureFile signatureFile, PrivateKey privateKey, X509Cert x509Cert) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        X500Name x500Name = x509Cert.getSubjectName();
        BigInt bigInt = x509Cert.getSerialNumber();
        String string = privateKey.getAlgorithm();
        String string2 = "SHA";
        String string3 = "SHA/DSA";
        if (!string.equals("DSA")) {
            if (string.equals("RSA")) {
                string3 = "MD5/RSA";
                string2 = "MD5";
            } else {
                this.error("private key is not a DSA or RSA key.");
            }
        }
        AlgorithmId algorithmId = AlgorithmId.get(string2);
        AlgorithmId algorithmId2 = AlgorithmId.get(string3);
        Signature signature = Signature.getInstance(string3);
        signature.initSign(privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        signatureFile.stream(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ContentInfo contentInfo = new ContentInfo(byArray);
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        SignerInfo signerInfo = new SignerInfo(x500Name, bigInt, algorithmId, algorithmId2, byArray2);
        AlgorithmId[] algorithmIdArray = new AlgorithmId[]{algorithmId};
        SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
        X509Cert[] x509CertArray = new X509Cert[]{x509Cert};
        return new PKCS7(algorithmIdArray, contentInfo, x509CertArray, signerInfoArray);
    }

    void displayCmd(String[] stringArray) {
        if (!stringArray[0].equals("dc") || stringArray.length != 2) {
            String string = "";
            string = String.valueOf(string) + "legal options to display certificate:\n";
            string = String.valueOf(string) + "\tc\t<cert>\tdisplay a certificate.\n";
            this.out.println(string);
            this.error("illegal arguments to display.");
            return;
        }
        this.displayCertificate(stringArray[1]);
    }

    private void displayCertificate(String string) {
        File file = new File(string);
        try {
            if (!file.exists()) {
                this.error("File " + file + " not found.");
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            X509Cert x509Cert = new X509Cert(byArray);
            this.out.println(x509Cert);
            return;
        }
        catch (IOException iOException) {
            this.error("IO error", iOException);
            return;
        }
    }

    private void trustCmd(String[] stringArray) {
        if (stringArray.length != 3) {
            this.usageError("Invalid number of arguments for set trust.");
            return;
        }
        String string = stringArray[1];
        Boolean bl = new Boolean(stringArray[2]);
        Identity identity = this.scope.getIdentity(string);
        if (identity == null) {
            this.error(String.valueOf(string) + " not found in the database.");
            return;
        }
        if (this.setTrusted(identity, bl)) {
            this.save(this.scope, String.valueOf(string) + " is trusted: " + bl);
        }
    }

    private boolean setTrusted(Identity identity, boolean bl) {
        if (identity instanceof SystemIdentity) {
            SystemIdentity systemIdentity = (SystemIdentity)identity;
            systemIdentity.setTrusted(bl);
        } else if (identity instanceof SystemSigner) {
            SystemSigner systemSigner = (SystemSigner)identity;
            systemSigner.setTrusted(bl);
        } else {
            return this.error(String.valueOf(identity) + " is not a SUN identity.");
        }
        return true;
    }

    void run(String[] stringArray) throws KeyManagementException {
        if (stringArray.length < 1) {
            this.usageError("for more information, see documentation.");
            return;
        }
        String string = stringArray[0];
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        stringArray[0] = string;
        switch (string.charAt(0)) {
            case 'l': {
                this.listCmd(stringArray);
                return;
            }
            case 'c': {
                this.createCmd(stringArray);
                return;
            }
            case 'r': {
                this.removeCmd(stringArray);
                return;
            }
            case 'i': {
                this.importCmd(stringArray);
                return;
            }
            case 'g': {
                this.generateCmd(stringArray);
                return;
            }
            case 'd': {
                this.displayCmd(stringArray);
                return;
            }
            case 't': {
                this.trustCmd(stringArray);
                return;
            }
            case 'e': {
                this.exportCmd(stringArray);
                return;
            }
            default: {
                this.usage();
            }
            case 'v': 
        }
    }

    public static void main(String[] stringArray) throws KeyManagementException {
        Main main = new Main(System.out, System.err, System.in, "javakey", true);
        main.setScope(IdentityScope.getSystemScope());
        if (main.scope == null) {
            main.error("could not initialize scope");
        }
        main.run(stringArray);
    }

    byte[] machineSeed(int n) {
        return SecureRandom.getSeed(n);
    }

    byte[] userSeed(int n) {
        this.out.println("Please enter some random data (" + n + " key strokes) and hit return.");
        InputStream inputStream = System.in;
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            while (n2 < n) {
                byArray[n2++] = (byte)inputStream.read();
            }
        }
        catch (IOException iOException) {
            this.err.println("IOException");
            this.debug(iOException);
        }
        return byArray;
    }

    void usage() {
        if (this.usage == null) {
            this.usage = "";
            this.usage = String.valueOf(this.usage) + "javakey\n";
            this.usage = String.valueOf(this.usage) + "\tl\tlist of the identities in the database.\n";
            this.usage = String.valueOf(this.usage) + "\tc\tcreate an new identity.\n";
            this.usage = String.valueOf(this.usage) + "\tr\tremove an identity from the database.\n";
            this.usage = String.valueOf(this.usage) + "\ti\timport a public key, a key pair, etc.\n";
            this.usage = String.valueOf(this.usage) + "\tg\tgenerate a key pair, a certificate, etc.\n";
            this.usage = String.valueOf(this.usage) + "\td\tdisplay a certficate.\n";
        }
        this.out.println(this.usage);
    }

    boolean usageError(String string) {
        this.usage();
        return this.error(string);
    }

    boolean error(String string) {
        this.err.println(string);
        if (this.quitOnError) {
            System.exit(1);
        }
        return false;
    }

    boolean internalError(String string) {
        this.err.println("Internal error! " + string);
        this.err.println("please submit a bug report via " + System.getProperty("java.vendor.url.bug"));
        if (this.quitOnError) {
            System.exit(1);
        }
        return false;
    }

    boolean error(String string, Throwable throwable) {
        this.debug(throwable);
        return this.error(String.valueOf(string) + "[" + throwable.getMessage() + "]");
    }

    void debug(Throwable throwable) {
        if (this.debug) {
            throwable.printStackTrace(this.err);
        }
    }

    void debug(String string, Throwable throwable) {
        if (this.debug) {
            throwable.printStackTrace(this.err);
            System.err.println(string);
        }
    }

    void debug(String string) {
        if (this.debug) {
            System.err.println(string);
        }
    }

    void message(String string) {
        this.out.print(string);
    }

    void exit(String string) {
        this.out.println(string);
        if (this.quitOnError) {
            System.exit(0);
        }
    }

    String assertProp(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 == null || string2.length() == 0) {
            this.error(String.valueOf(string) + " must be specified in the directive file.");
        }
        return string2;
    }
}

