/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;

public class LocalizedPrintStream
extends PrintStream {
    private static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private boolean myAutoFlush = false;
    private boolean myTrouble = false;
    private CharToByteConverter ctb;
    private static final int defaultByteBufferSize = 8192;
    private byte[] bb;
    private int nextByte;
    private int nBytes;
    private String lineSeparator;
    private boolean myClosing = false;

    public LocalizedPrintStream(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
        this.myAutoFlush = bl;
        this.ctb = CharToByteConverter.getDefault();
        this.bb = new byte[8192];
        this.nBytes = 8192;
        this.lineSeparator = System.getProperty("line.separator");
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public void flush() {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            try {
                this.ensureOpen();
                this.out.flush();
            }
            catch (IOException iOException) {
                this.myTrouble = true;
            }
            return;
        }
    }

    public void close() {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            if (!this.myClosing) {
                this.myClosing = true;
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.myTrouble = true;
                }
                this.out = null;
                this.bb = null;
                this.ctb = null;
            }
            return;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.myTrouble;
    }

    protected void setError() {
        this.myTrouble = true;
    }

    public void write(int n) {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)byArray[n3 + n];
            ++n3;
        }
        this.write(cArray, 0, n2);
    }

    public void write(char[] cArray, int n, int n2) {
        boolean bl = false;
        if (this.myAutoFlush) {
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                if (cArray[n4] == '\n') {
                    bl = true;
                }
                ++n4;
            }
        }
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            try {
                this.ensureOpen();
                int n5 = n;
                int n6 = n + n2;
                while (n5 < n6) {
                    boolean bl2 = false;
                    try {
                        this.nextByte += this.ctb.convert(cArray, n5, n6, this.bb, this.nextByte, this.nBytes);
                        n5 = n6;
                    }
                    catch (ConversionBufferFullException conversionBufferFullException) {
                        int n7 = this.ctb.nextCharIndex();
                        if (n7 == n5) {
                            throw new CharConversionException("Output buffer too small");
                        }
                        n5 = n7;
                        bl2 = true;
                        this.nextByte = this.ctb.nextByteIndex();
                    }
                    if (this.nextByte < this.nBytes && !bl2) continue;
                    this.out.write(this.bb, 0, this.nextByte);
                    this.nextByte = 0;
                }
                this.flushBuffer();
                if (bl) {
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                this.myTrouble = true;
            }
            return;
        }
    }

    private void flushBuffer() {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            try {
                this.ensureOpen();
                while (true) {
                    try {
                        this.nextByte += this.ctb.flush(this.bb, this.nextByte, this.nBytes);
                    }
                    catch (ConversionBufferFullException conversionBufferFullException) {
                        this.nextByte = this.ctb.nextByteIndex();
                    }
                    if (this.nextByte != 0) {
                        if (this.nextByte <= 0) continue;
                        this.out.write(this.bb, 0, this.nextByte);
                        this.nextByte = 0;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                this.myTrouble = true;
            }
            return;
        }
    }

    private void write(String string) {
        this.write(string, 0, string.length());
    }

    private void write(String string, int n, int n2) {
        char[] cArray = new char[n2];
        string.getChars(n, n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    private void newLine() {
        this.write(this.lineSeparator);
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.newLine();
    }

    public void println(boolean bl) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(bl);
            this.newLine();
            return;
        }
    }

    public void println(char c) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(c);
            this.newLine();
            return;
        }
    }

    public void println(int n) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(n);
            this.newLine();
            return;
        }
    }

    public void println(long l) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(l);
            this.newLine();
            return;
        }
    }

    public void println(float f) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(f);
            this.newLine();
            return;
        }
    }

    public void println(double d) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(d);
            this.newLine();
            return;
        }
    }

    public void println(char[] cArray) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(cArray);
            this.newLine();
            return;
        }
    }

    public void println(String string) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(string);
            this.newLine();
            return;
        }
    }

    public void println(Object object) {
        LocalizedPrintStream localizedPrintStream = this;
        synchronized (localizedPrintStream) {
            this.print(object);
            this.newLine();
            return;
        }
    }

    public OutputStream getFilterOutput() {
        return this.out;
    }

    public static native boolean usesInstanceOf(OutputStream var0, Class var1);
}

