#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2006 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:standard);
use strict;

my ($arg, $action, $portname, $portstate, $label, $time, @result, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
$action=" ";
$portname=" ";
$portstate=" ";

print "<b> Communication Server Web Admin Manage Ports Results: $time</b>";
print "<font face=\"Courier, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of port management!";
} else {
     $arg=param('portslist');
     ($action,$portname) = (split(/_/,$arg) )[0,1];
     if ($action=~m/^start/) {
        print "<b> Start of Port: ",$portname," </b> <br>"; 
        @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin start_port,port_name=$portname `
     } elsif ($action=~m/^stop/) {
         print "<b> Stopping Port: ",$portname," </b> <br>";
         @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin stop_port,port_name=$portname `
     } else {
         print " Invalid action on port management!";
         exit 1;
     }
}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print $_;
}
print "</b><br>";
print "<br><b> Port Status: </b><br>";

@contents=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_port`; # Command to get Port status

foreach $line (@contents) {
#  Print the port name and state of each port
   if ($line=~m/port_name/) {
      print $line.":  ";
      print "status: ";
   } elsif ($line=~m/port_state/) {
#  Get state that is active or inactive
      ($label, $portstate) = (split(/=/,$line) );
      $portstate=~s/\s+//g;        # Remove blanks
      print $portstate,"<br>\n";
   }
}

print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0;

