#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################

#  Purpose of the script is to call snaadmin query_ls and display
#  in a terse format the information. By 'grep"ing on the output for "=",
#  only the active links stations will be displayed.


use strict;

 my ( $line, $lsname, $dlcname, $portname, $detadjcpname, $detadjcptype,
      $dethprsupport, $tgnumber, $state, @data, @status );

#  Initialize for scalar declaration
$lsname = " ";

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -d query_ls`;             # Get detailed Link Station information
} else {
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $ARGV[0] -d query_ls` or die "Node $ARGV[0] not recognized $!\n";
}

#   Print header line

print "  Link Name   Port     Partner CP Name   Type HPR  TG#  State \n";
print "  --------- -------- -----------------  ---- ---- --- ------ \n";


$line =0;
foreach(@status) {
   chomp;
   if (/^query_ls/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break NAU, LU, Type, Status

   next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

   if ($data[0]=~m/^ls_name/) {       # get link station name  
     $lsname = $data[1];
     $lsname=~s/ //g;
     next;             
   } elsif ($data[0]=~m/^dlc_name/) {  # dlc_name 
     $dlcname = $data[1];
     next;             
   } elsif ($data[0]=~m/^port_name/) { # port name 
     $portname = $data[1];
     $portname=~s/ //g;
     next;             
   } elsif ($data[0]=~m/^det_adj_cp_name/) { # Determined Adj. CP Name
     $detadjcpname = $data[1];
     $detadjcpname=~s/ //g;
     next;             
   } elsif ($data[0]=~m/^adj_cp_name/) { # Adj. CP Name
     #   If det. adjacent CP Name is blank (has `"` in it), use adj_cp_name
     if ($detadjcpname=~m/"/) {
        $detadjcpname = $data[1];
        $detadjcpname=~s/ //g;
     }
     next;             
   } elsif ($data[0]=~m/^det_adj_cp_type/) { # Determined Adj. CP Type
     $detadjcptype = $data[1];
     $detadjcptype=~s/ //g;
     next;             
   } elsif ($data[0]=~m/^determined_hpr_support/) { # Determined HPR type 
     $dethprsupport = $data[1];
     $dethprsupport=~s/ //g;
     next;             
   } elsif ($data[0]=~m/^tg_number/) { # Determined HPR type 
     $tgnumber = $data[1];
     next;             
   } elsif ($data[0]=~m/^state/) { # Determined HPR type 
     $state = $data[1];
     $state=~s/ //g;
     next;             
   }  else {                          # output line if end of record 
     if ($data[0]=~m/^max_ifrm_rcvd/)  {   # max ifrm rcvd variable is common end of record
             # Print information #
        if ($state=~m/_ACTIVE/) {  
           printf("   ");
           $state = "INACTIVE";
        } else {
         printf("*  ");
        }
        if ($dethprsupport=~m/CONTROL/) {
          $dethprsupport = "CF";
        } elsif ($dethprsupport=~m/TRANSPORT/) {
          $dethprsupport = "RTP";
        }

        if ($detadjcptype=~m/END/) {
           $detadjcptype="EN";
        } elsif ($detadjcptype=~m/LEARN/) {
           $detadjcptype="LEARN";
        }  else {
           $detadjcptype="NN";
        }
        printf("%8s %8s %17s %5s %4s %3d  %s \n",
               $lsname, $portname, $detadjcpname,
               $detadjcptype, $dethprsupport, $tgnumber, $state);
     }
     $line++;       
   }
}
print "\n------------------------------------------------\n";

