#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin query_ls and display
#  in a terse format the information. By 'greping' on the output for "=",
#  only the active links stations will be displayed.
#  Then issue query_dlur_pu and query_lu_0_to_3 to get DLUS 'links status'
#

use strict;

 my ( $line, $lsname, $inusestr, $detadjcpname, $detadjcptype, $srv_index, $srvcnt,
      $actsesscnt, $dlctype, $state, $num_pus, $appl_status, $plu_status,
      $dlus_defined_name, $dlus_active_name, @puname, @dlusname, @pustate, 
      @servername, @dlusstatus, @data, @status );

#  Initialize for scalar declaration
$lsname = " ";
$srvcnt = 0;

@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";
   
#
#  Process the DLUR PU information
#

#  Initialize for scalar declaration
$srv_index = 0;

while ($srv_index < $srvcnt) 
{
   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_ls` or die "Node $servername[$srv_index] not recognized $!\n";

#   Print header line
   printf("\n      Server: %s\n", $servername[$srv_index]);
   print "    Link           Adjacent      Node    Device             # of local  In\n";
   print "   station         CP name       type     name      State    sessions   use\n";
   print "-------------- ----------------- ----- --------- ---------- ---------- -----\n";

   $line =0;
   foreach(@status) {
      chomp;
      if (/^query_ls/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }
 
  #  Skip headers
      next if (/^------/);
      next if (/^list_option/);

      next if (/^\n/);

      @data = split(/=/,$_);   #Break parameter = value

      next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

      if ($data[0]=~m/^ls_name/) {       # get link station name  
        $lsname = $data[1];
        $lsname=~s/ //g;
        next;                         
      } elsif ($data[0]=~m/^det_adj_cp_name/) { # Determined Adj. CP Name
        $detadjcpname = $data[1];
        $detadjcpname=~s/ //g;
        next;             
      } elsif ($data[0]=~m/^adj_cp_name/) { # Adj. CP Name
#   If det. adjacent CP Name is blank (has `"` in it), use adj_cp_name
        if ($detadjcpname=~m/"/) {
           $detadjcpname = $data[1];
           $detadjcpname=~s/ //g;
        }
        next;             
      } elsif ($data[0]=~m/^det_adj_cp_type/) { # Determined Adj. CP Type
        $detadjcptype = $data[1];
        $detadjcptype=~s/ //g;
        next;             
      } elsif ($data[0]=~m/^act_sess_count/) { # Determined HPR type 
        $actsesscnt = $data[1];
        if ($actsesscnt > 0) {
           $inusestr="Yes";
        } else {
           $inusestr="No";
        }
        next;             
      } elsif ($data[0]=~m/^dlc_type/) { # Determined HPR type 
        $dlctype = $data[1];
        next;             
      } elsif ($data[0]=~m/^state/) { # Determined HPR type 
        $state = $data[1];
        $state=~s/ //g;
        next;             
      }  else {                          # output line if end of record 
        if ($data[0]=~m/^max_retry/)  {   # ... the max retry variable is end of record
                # Print information #
           if ($state=~m/_ACTIVE/) {  
#           printf("   ");
              $state = "Inactive";
           } elsif ($state=~m/ACTIVE/) {
             $state = "Active"
#         printf("*  ");
           }
           if ($detadjcptype=~m/END/) {
           $detadjcptype="EN";
           } elsif ($detadjcptype=~m/LEARN/) {
              $detadjcptype="LEARN";
           } elsif ($detadjcptype=~m/VRN/) {
              $detadjcptype="VN";
           }  else {
              $detadjcptype="NN";
           }
           if ($dlctype=~m/HPRIP/) {
              $dlctype="HPRIP";
           } elsif ($dlctype=~m/ETHERNET/) {
              $dlctype="LAN";
           }
           printf("   %8s %17s   %5s    %6s    %8s  %7d  %4s \n",
                  $lsname, $detadjcpname,
                  $detadjcptype, $dlctype, $state, $actsesscnt, $inusestr);
        }
        $line++;       
      }
   
   }
# print "\n------------------------------------------------\n";

   
#
#  Process the DLUR PU information
#

#  Initialize for scalar declaration
   $num_pus = 0;

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_dlur_pu` or die "Node $servername[$srv_index] not recognized $!\n";

   $line =0;
   foreach(@status) {
      chomp;
      if (/^query_node_limit/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }

  #  Skip headers
      next if (/^------/);
      next if (/^list_option/);
      next if (/^filter/);
      next if (/^\n/);

      @data = split(/=/,$_);   #Break parameter = value

      next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

      if ($data[0]=~m/^pu_name/) {       # get DLUR PU name  
        $puname[$num_pus] = $data[1];    #  save PU name
        $puname[$num_pus]=~s/ //g;       # remove any spaces as end
#  printf ("  PU Name: %8s \n", $puname[$num_pus]);
        next;   
      } elsif ($data[0]=~m/^defined_dlus_name/) { # Defined DLUS
        $dlus_defined_name = $data[1];    #  save defined DLUS name
        $dlus_defined_name=~s/ //g;       # remove any spaces as end
        next;                              
      } elsif ($data[0]=~m/^active_dlus_name/) { # Determined Active DLUS
        $dlus_active_name = $data[1];    #  save Active DLUS name
        $dlus_active_name=~s/ //g;       # remove any spaces as end
        next;             
      } elsif ($data[0]=~m/^pu_status/) { # PU state ... needs to be ACTIVE
        $pustate[$num_pus] = $data[1];    #  save PU State
        $pustate[$num_pus]=~s/ //g;       # remove any spaces as end 
        if ($data[1]=~m/^ACTIVE/) {      # If active, set active, else use defined
           $dlusname[$num_pus] = $dlus_active_name;
        } else {  
           $dlusname[$num_pus] = $dlus_defined_name;
        }
        next;  
      } elsif ($data[0]=~m/^dlus_session_status/) { # Needs to be ACTIVE
         if ($data[1]=~m/_ACTIVE/) {  
            $dlusstatus[$num_pus] = "Inactive";
         } elsif ($data[1]=~m/ACTIVE/) {
            if ($pustate[$num_pus]=~m/ACTIVE/) {
              $dlusstatus[$num_pus] = "Active"
            } else {
              $dlusstatus[$num_pus] = "Inactive";
            }
         }     
#  printf ("  DLUS Status: %8s \n", $dlusstatus[$num_pus]);
        $num_pus++;                        # Increment count of PUs            
      } else {
        next;
      }
     
   }

   $line = 0;

   while ($line < $num_pus) 
   {
     $actsesscnt = 0;
  
     if ($pustate[$line]=~m/^ACTIVE/ ) {
        if ($dlusstatus[$line]=~m/^Active/) {
      
          @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -a query_lu_0_to_3,pu_name=$puname[$line]`or die "Node $servername[$srv_index] not recognized $!\n";
          foreach(@status) {
             chomp;
          

  #  Skip headers
             next if (/^------/);
             next if (/^list_option/);
             next if (/^\n/);

             @data = split(/=/,$_);   #Break parameter = value

             next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

             if ($data[0]=~m/^appl_conn_active/) {    # get DLUR PU name  
               $appl_status = $data[1];    #  save application status
               $appl_status=~s/ //g;       # remove any spaces as end
               next;                         
             } elsif ($data[0]=~m/^plu_sess_active/) { # Determined Active DLUS
               $plu_status = $data[1];    #  save PLU application status
               $plu_status=~s/ //g;       # remove any spaces as end
               if ($appl_status =~m/^YES/) {
                  if ($plu_status =~m/^YES/) {  
                        $actsesscnt++;
                  }
               }
               next;             
             } else  { 
               next;                
             }
          } 
          if ($actsesscnt > 0) {
              $inusestr="Yes";
          } else {
              $inusestr="No";
          }
          printf("   %8s %17s    DLUS      n/a     %8s  %7d  %4s\n",
               $puname[$line], $dlusname[$line], $dlusstatus[$line],
               $actsesscnt, $inusestr);  
        }
      } else {
          printf("   %8s %17s    DLUS      n/a     %8s        0    No\n",
              $puname[$line], $dlusname[$line],$dlusstatus[$line]);  
      }
      $line++;                        
   }           
   print "\n------------------------------------------------\n";
   $srv_index++;
  
}

