#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin query_node_all to get 
#  list of domain servers, then search servers and display LU status
#  for LU62 specified in argument
#

use strict;

 my ( $srv_index, $srvcnt, $lusrvcnt, $aliasname, $sysname, $descript,
      $luname, $found_index, $input_luname, $total_cnt_lus,  
      @servername, @luservername, @luserverindex, @lucount, @data, @status);

#  Initialize for scalar declaration
$srvcnt = 0;
$lusrvcnt = 0;
$srv_index = 0;
$total_cnt_lus = 0;

if ($#ARGV < 0)    # Check for input argument on line
{
   print ("\n   No Independent LU to search for provided as input parameter. \n");
   $input_luname = "[]";      # set input_luname to something a LU cannot be
}else {
   $input_luname = $ARGV[0];
   printf("\n Searching for Independent LU %s in the following domain servers:\n\n",$input_luname);
}


@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information


foreach(@status) {
   chomp;
   if (/^query_ls/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get name of each domain server   
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
print "\n------------------------------------------------\n";
   
#
#  Process the Local LU information
#

while ($srv_index < $srvcnt) 
{
   $lucount[$srv_index]=0;  # Initialize count of LUs on this server

   @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_local_lu` or die "Node $servername[$srv_index] not recognized $!\n";

   foreach(@status) {
      chomp;
      if (/^query_local_lu/) {
        print " Cannot process node $servername[$srv_index]\n";
        exit -1;
      }

     #  Skip headers
     next if (/^------/);
     next if (/^list_option/);
     next if (/^\n/);

     @data = split(/=/,$_);   #Break parameter = value

     next if (@data == 0);        # on blank line, skip

     if ($data[0]=~m/^lu_name/) {       # get LU name  
        $luname = $data[1];    #  save LU name
        $luname=~s/ //g;       # remove any spaces as end
        if ($input_luname=~m/$luname/) {
           $luserverindex[$lusrvcnt] = $srv_index;   # Save the index into server list
           $lusrvcnt++;
        } 
        $lucount[$srv_index]++;    # Array of counts for LUs on each server
        $total_cnt_lus++;
        next;   
     } elsif (!($input_luname=~m/$luname/)) {  # only look for the LU name provided
        next;
     } elsif ($data[0]=~m/^description/) { # description
        $descript = "<nobr>$data[1]</nobr>";
        $descript=~s/ //g;
        next;                              
     } elsif ($data[0]=~m/^lu_alias/) {  # alias name
       $aliasname = $data[1];
       $aliasname=~s/ //g;
       next;
     } elsif ($data[0]=~m/^sys_name/) { # sys_name
       $sysname = $data[1];
       $sysname=~s/ //g;
       if (m/\"/) {
          $sysname="-------------------------------";
       } 
       printf("\n      Server: %s\n\n", $servername[$srv_index]);
       print "LU Name   LU ALias               Sys Name            Description \n";
       print "========  ========  ==============================  ============= \n";
       print "\n";    
       printf("%8s %8s %32.32s   %s \n",
           $luname, $aliasname, $sysname, $descript);       
    } else {
        next;
    }

  }
  $srv_index++;
#  print "\n-------------------------------------------\n";

}

if ($lusrvcnt == 0) {
  printf("\n  Independent LU %s not found in domain servers.\n", $input_luname);
}
else
{
  printf("\n   Independent LU %s found on %d server(s)\n", $input_luname, $lusrvcnt);
}
print "\n------------------------------------------------\n";

