#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################


#  Purpose of the script is to call snaadmin query_tn_redirect_def and display
#  in a netstat output for the client_port information. 


use strict;

 my ( $line, @client_port, @host_port, @client_addr, @host_addr,
       $label, $i, $def_number,
       $statusline, @data, @tnredirect, @status );

#  Initialize for scalar declaration
$line = 0;

# Get TN Redirect Port numbers from definitions

@tnredirect=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_tn_redirect_def`; # Get TN Redirect definitions

# Now parse the output to query_tn_redirect_def to get ports and addresses
foreach(@tnredirect) {
#   next if (!/_port/); 
   chomp;
   if (/^client_port/) {
      ($label, $client_port[$line]) = split("=",$_);
      $client_port[$line]=~s/ //g;    # remove space
   } elsif (/^host_port/) {
      ($label, $host_port[$line]) = split("=",$_);
      $host_port[$line]=~s/ //g;      # remove space 
      $line++;
   } elsif (/^client_address/) {
      ($label, $client_addr[$line]) = split("=",$_);
      $client_addr[$line]=~s/ //g;    # remove space
      $client_addr[$line]=~s/<DEFAULT>/(ALL)/; # change DEFAULT to ALL
   } elsif (/^host_address/) {
      ($label, $host_addr[$line]) = split("=",$_);
      $host_addr[$line]=~s/ //g;    # remove space
   }   
  
}

#  Get 'netstat' output and show results
for($i=0;$i<$line;$i++) {
  $def_number=$i+1;
  @status=`/bin/netstat -an --tcp | /bin/grep ":$client_port[$i] " `;
  printf("Client port #$def_number:  %s:%d <==> Maps to Host port: %s:%d \n",
          $client_addr[$i],$client_port[$i], $host_addr[$i], $host_port[$i]);
  print "\n";
  foreach $statusline (@status) {
    @data = split(/ +/,$statusline);
#  Some grepping will give false hits, so check for specific port
    if ($data[3]=~m/:$client_port[$i]/) {   # Print only output with client port
       printf(" %20s <== %20s status: %s \n", $data[3], $data[4], $data[5]);
    }
  }
  print "\n";
  @status=`/bin/netstat -an --tcp | /bin/grep ":$host_port[$i] " `;
  foreach $statusline (@status) {
    @data = split(/ +/,$statusline);
#  Some grepping will give false hits, so check for specific port
    if ($data[4]=~m/:$host_port[$i]/) {   # Print only output with host port
       printf(" %20s ==> %20s status: %s \n", $data[3], $data[4], $data[5]);
    }
  }
  print "\n";
}
print "\n------------------------------------------------\n";

