#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_fqcn_name, $arg_description, $arg_port_name,  $description, $port_name,
    $time, $line, @data, @contents, @portlist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_fqcn_name=param('fqcn_name_unique');

if ($arg_fqcn_name eq "") {
   
    $arg_description="";
    $arg_port_name="";
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_port -d`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/port_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            $port_name= $data[1];
            next;
        }elsif ($line=~m/dlc_type/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            if ($data[1]=~m/HPRIP/) {
                push @portlist, $port_name;
            }elsif($data[1]=~m/ETHERNET/){
                push @portlist, $port_name;
            }
            next;
        }
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #   Fully-qualified Connection Network name
   print "<tr> <td>* Fully-qualified Connection Network name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"fqcn_name_unique\"  maxlength=\"17\" value=\"$arg_fqcn_name\" required=\"required\" /></td></tr>";
    
    #   Description
   print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #   Port name
    print "<tr><td>Port Name :</td> <td><select name=\"port_name\"  class=\"rightAligned\" value=\"$arg_port_name\" >  ";
    print "<option value=\"\"></option> ";
    foreach $line (@portlist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
   
} else {
  
   $arg_description=param('description');
   $arg_port_name=param('port_name');
  
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description"
    }
    
    if ($arg_port_name eq "") {
        $port_name="";
    }else
    {
        $port_name=",port_name=$arg_port_name"
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_cn,fqcn_name=$arg_fqcn_name $description $port_name`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_cn,fqcn_name=$arg_fqcn_name $description $port_name";
   
# Display output of snaadmin define_cn
   print "<br> Display Output from Add APPN Connection Network :";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

