#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_lu_alias, $arg_list_name, $arg_lu_name, $arg_description, $arg_pu_name, $arg_nau_address, $arg_default_pool, $arg_syncpt_support, $arg_sscp_id, $arg_timeout, $arg_lu_attributes,  $arg_sys_name, $description, $timeout, $sscp_id, $sys_name, $list_name, $type, $len, $time, $line, @data, @contents, @pulist, @list);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_lu_alias=param('dep_lu_alias_unique');

if ($arg_lu_alias eq "") {
    $arg_description="";
    $arg_list_name="";
    $arg_lu_name="";
    $arg_pu_name="";
    $arg_default_pool="NO";
    $arg_syncpt_support="NO";
    $arg_nau_address="1";
    $arg_timeout="60";
    $arg_sscp_id="0";
    $arg_lu_attributes="NONE";
    $arg_sys_name="";
    
   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_ls -d`;
   foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
       
       if ($line=~m/dlc_type/) {
           @data = split(/=/,$line);
           $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
           $type=$data[1];
           next;
       }elsif ($line=~m/pu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            if ($type=~m/ETHERNET/ ) {
                if($data[1]=~m/""/)
                {
                    next;
                }else{
                    push @pulist, $data[1];
                    next;
                }
            }
        }
   }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_dlur_pu`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/pu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @pulist, $data[1];
            next;
        }
    }
    
    $len=@pulist;
    if($len eq 0){
        print "<br> Host LS/DLUR PU should be defined before define Dependent LU Type 6.2. ";
        exit 1;
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_security_access_list`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/list_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @list, $data[1];
            next;
        }
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  * LU alias
    print "<tr><td>* LU alias :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"dep_lu_alias_unique\" maxlength=\"8\" value=\"$arg_lu_alias\" required=\"required\" /></td></tr>";
    
    #  Security Access List name
    print "<tr><td>Security Access List name :</td> <td><select name=\"list_name\" class=\"rightAligned\" value=\"$arg_list_name\" >  ";
    print "<option value=\"\"></option> ";
    foreach $line (@list) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #  Description
   print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    # * LU name
    print "<tr><td>* LU name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"lu_name\" maxlength=\"8\" value=\"$arg_lu_name\" required=\"required\"/></td></tr>";
    
    #  Host LS/DLUR PU
    print "<tr><td>* Host LS/DLUR PU :</td> <td><select name=\"pu_name\" class=\"rightAligned\" value=\"$arg_pu_name\" >  ";
    foreach $line (@pulist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
   
    #  * LU number
    print "<tr><td>* LU number(1-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"nau_address\" maxlength=\"3\" value=\"$arg_nau_address\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\"/></td></tr>";
    
    #   Member of default LU pool?
    print "<tr><td>Member of default LU pool ? </td> <td> <select name=\"default_pool\" class=\"rightAligned\" value=\"$arg_default_pool\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option></select></td></tr>";
    
    #   Support Syncpoint?
    print "<tr><td> Support Syncpoint ? </td> <td> <select name=\"syncpt_support\" class=\"rightAligned\" value=\"$arg_syncpt_support\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option></select></td></tr>";
    
    #   Additional LU properties
    print "<tr><td>Additional LU properties : </td> <td> <select name=\"lu_attributes\" class=\"rightAligned\" value=\"$arg_lu_attributes\" >  ";
    print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
    print "<option value=\"DISABLE_PASSWORD_SUBSTITUTION\">DISABLE_PASSWORD_SUBSTITUTION</option></select></td></tr>";
    
    #   Restrict SSCP to SSCP id
    print "<tr><td>Restrict SSCP to SSCP id(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"sscp_id\" maxlength=\"5\" value=\"$arg_sscp_id\" oninput=\"value=value.replace(/[^\\d]/g,'')\" /></td></tr>";
    
    #   Computer
    print "<tr><td> Computer : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"sys_name\" maxlength=\"128\" value=\"$arg_sys_name\" /></td></tr>";
    
    #   Timeout
    print "<tr><td>Timeout : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"timeout\" maxlength=\"5\" value=\"$arg_timeout\" oninput=\"value=value.replace(/[^0-9\-]/g,'')\" /></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_lu_alias=param('dep_lu_alias_unique');
   $arg_description=param('description');
   $arg_pu_name=param('pu_name');
   $arg_default_pool=param('default_pool');
   $arg_syncpt_support=param('syncpt_support');
   $arg_sscp_id=param('sscp_id');
   $arg_timeout=param('timeout');
   $arg_nau_address=param('nau_address');
   $arg_list_name=param('list_name');
   $arg_lu_name=param('lu_name');
   $arg_lu_attributes=param('lu_attributes');
   $arg_sys_name=param('sys_name');

    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_timeout eq "") {
        $timeout="";
    }else
    {
        $timeout=",timeout=$arg_timeout";
    }

    if ($arg_sscp_id eq "") {
        $sscp_id="";
    }else
    {
        $sscp_id=",sscp_id=$arg_sscp_id";
    }
    
    if ($arg_list_name eq "") {
        $list_name="";
    }else
    {
        $list_name=",list_name=$arg_list_name";
    }
    
    if ($arg_sys_name eq "") {
        $sys_name="";
    }else
    {
        $sys_name=",sys_name=$arg_sys_name";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_local_lu,lu_alias=$arg_lu_alias, nau_address=$arg_nau_address, pu_name=$arg_pu_name, lu_name=$arg_lu_name, default_pool=$arg_default_pool,  syncpt_support=$arg_syncpt_support, lu_attributes=$arg_lu_attributes, lu_session_limit=1 $list_name  $sscp_id  $description $timeout $sys_name`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_local_lu,lu_alias=$arg_lu_alias, nau_address=$arg_nau_address, pu_name=$arg_pu_name, lu_name=$arg_lu_name, default_pool=$arg_default_pool,  syncpt_support=$arg_syncpt_support, lu_attributes=$arg_lu_attributes, lu_session_limit=1 $list_name  $sscp_id  $description $timeout $sys_name";
   
   print "<br>Display Output from Add Dependent LU Type 6.2:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

