#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_dslu_name, $arg_description, $arg_dspu_name, $arg_nau_address, $arg_host_lu_name, $arg_delayed_logon, $arg_allow_timeout, $description, $len, $time, $line, @data, @contents, @dspulist, @hostlulist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_dslu_name=param('dslu_name_unique');

if ($arg_dslu_name eq "") {
    $arg_description="";
    $arg_dspu_name="";
    $arg_host_lu_name="";
    $arg_delayed_logon="NO";
    $arg_nau_address="1";
    $arg_allow_timeout="NO";
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_downstream_pu`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/dspu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @dspulist, $data[1];
            next;
        }
    }
    
    $len=@dspulist;
    if($len eq 0){
        print "<br> Downstream PU should be defined before define Downstream LU. ";
        exit 1;
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_0_to_3`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/lu_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @hostlulist, $data[1];
            next;
        }
    }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_lu_pool`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/pool_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @hostlulist, $data[1];
            next;
        }
    }
    $len=@hostlulist;
    if($len eq 0){
        print "<br> HOST LU or Pool name should be defined before define Downstream LU. ";
        exit 1;
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  LU name
    print "<tr><td>* LU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"dslu_name_unique\" maxlength=\"8\" value=\"$arg_dslu_name\" required=\"required\" /></td></tr>";
    
    #  Description
   print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    # * Downstream PU name
    print "<tr><td>* Downstream PU name :</td> <td><select name=\"dspu_name\" class=\"rightAligned\" value=\"$arg_dspu_name\" >  ";
    foreach $line (@dspulist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #  * LU number
    print "<tr><td>* LU number(1-255) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"nau_address\" maxlength=\"3\" value=\"$arg_nau_address\" oninput=\"value=value.replace(/[^\\d]/g,'')\" required=\"required\"/></td></tr>";
    
    #   * Host LU or Pool name
    print "<tr><td>* Host LU or Pool name :</td> <td><select name=\"host_lu_name\" class=\"rightAligned\" value=\"$arg_host_lu_name\" >  ";
    foreach $line (@hostlulist) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #   Inactivity timeout allowed?
    print "<tr><td> Inactivity timeout allowed ? </td> <td> <select name=\"allow_timeout\" class=\"rightAligned\" value=\"$arg_allow_timeout\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option></select></td></tr>";
    
    #   Use delayed logon?
    print "<tr><td> Use delayed logon ? </td> <td> <select name=\"delayed_logon\" class=\"rightAligned\" value=\"$arg_delayed_logon\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option></select></td></tr>";

    print "<tr> <td><input type=\"submit\"  value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_dslu_name=param('dslu_name_unique');
   $arg_description=param('description');
   $arg_dspu_name=param('dspu_name');
   $arg_host_lu_name=param('host_lu_name');
   $arg_delayed_logon=param('delayed_logon');
   $arg_allow_timeout=param('allow_timeout');
   $arg_nau_address=param('nau_address');
   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_downstream_lu,dslu_name=$arg_dslu_name, nau_address=$arg_nau_address, dspu_name=$arg_dspu_name, delayed_logon=$arg_delayed_logon, host_lu_name= $arg_host_lu_name, allow_timeout=$arg_allow_timeout $description `;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_downstream_lu,dslu_name=$arg_dslu_name, nau_address=$arg_nau_address, dspu_name=$arg_dspu_name, delayed_logon=$arg_delayed_logon, host_lu_name= $arg_host_lu_name, allow_timeout=$arg_allow_timeout $description ";
   
    print "Display Output from Add Downstream LU:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

