#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_ee_ls_name, $arg_description, $arg_initially_active,$arg_port_name, $arg_adj_cp_name, $arg_adj_cp_type, $arg_remote_ip_host,$arg_max_retry,$arg_liveness_timeout, $arg_cp_cp_sess_support,$arg_ip_version, $arg_tg_number, $arg_max_send_btu_size, $arg_default_nn_server,$arg_branch_link_type, $arg_ack_timeout,$arg_restart_on_normal_deact, $description, $port_name, $len,$tg_number, $liveness_timeout,$max_send_btu_size, $adj_cp_name,$max_retry, $ack_timeout, $time, $line, @data, @contents, @portlist);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "Failed to access the node. \n";
        exit -1;
    }
}

$arg_ee_ls_name=param('eelsname_unique');

if ($arg_ee_ls_name eq "") {
    $arg_port_name="";
    $arg_description="";
    $arg_initially_active="YES";
    $arg_remote_ip_host="";
    $arg_adj_cp_name="";
    $arg_adj_cp_type="LEARN_NODE";
    $arg_max_send_btu_size="1461";
    $arg_cp_cp_sess_support="YES";
    $arg_default_nn_server="NO";
    $arg_ip_version="IPV4";
    $arg_tg_number="0";
    $arg_branch_link_type="NONE";
    $arg_restart_on_normal_deact="NO";
    $arg_ack_timeout="10000";
    $arg_max_retry="10";
    $arg_liveness_timeout="10000";
    
   @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_port -d`;
   foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        
        if ($line=~m/port_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            $port_name= $data[1];
            next;
        }elsif ($line=~m/dlc_type/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            if ($data[1]=~m/HPRIP/) {
                 push @portlist, $port_name;
            }
            next;
        }
   }
    
    $len=@portlist;
    if($len eq 0){
        print "<br> Enterprise Extender Port should be defined before define Enterprise Extender Link Station. ";
        exit 1;
    }
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #  Link station name
    print "<tr><td>* Link station name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"eelsname_unique\"  maxlength=\"8\" value=\"$arg_ee_ls_name\" required=\"required\" /></td></tr>";
    
    #  Description
    print "<tr><td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #   Port name
    print "<tr><td>* Port Name :</td> <td><select name=\"port_name\"  class=\"rightAligned\" value=\"$arg_port_name\" >  ";
    foreach $line (@portlist) {
       print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";

    #  Initially active?
    print "<tr><td>Initially active ?</td> <td> <select name=\"initially_active\"  class=\"rightAligned\" value=\"$arg_initially_active\" >";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    print "<tr><td>Contact Information :  </td></tr>";
    
    # Remote IP host
    print "<tr><td>* Remote IP host :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"remote_ip_host\"  maxlength=\"255\" value=\"$arg_remote_ip_host\" required=\"required\" /></td></tr>";
   
    print "<tr><td>Independent LU Traffic :</td></tr> ";
    
    # Remote node Control Point name
    print "<tr><td>Remote node Control Point name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"adj_cp_name\"  maxlength=\"17\" value=\"$arg_adj_cp_name\" /></td></tr>";
    
    #  Remote node type
    print "<tr><td>Remote node type : </td> <td><select name=\"adj_cp_type\"  class=\"rightAligned\" value=\"$arg_adj_cp_type\">  ";
    print "<option value=\"LEARN_NODE\" selected=\"selected\">LEARN_NODE</option> ";
    print "<option value=\"END_NODE\">END_NODE</option>";
    print "<option value=\"NETWORK_NODE\">NETWORK_NODE</option></select></td></tr>";
    
    print "<tr><td>Advanced : </td></tr> ";
    #   Maximum BTU size to be sent
    print "<tr><td>Maximum BTU size to be sent(265-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"max_send_btu_size\"  maxlength=\"5\" value=\"$arg_max_send_btu_size\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #  Request CP-CP sessions?
    print "<tr><td>Request CP-CP sessions ? </td> <td><select name=\"cp_cp_sess_support\"  class=\"rightAligned\" value=\"$arg_cp_cp_sess_support\" >  ";
    print "<option value=\"YES\" selected=\"selected\">YES</option> ";
    print "<option value=\"NO\">NO</option> </select></td></tr>";
    
    #   Remote node is a network node server?
    print "<tr><td>Remote node is a network node server ?</td> <td><select name=\"default_nn_server\"  class=\"rightAligned\" value=\"$arg_default_nn_server\" >  ";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Protocol
    print "<tr><td>Protocol : </td> <td><select name=\"ip_version\"  class=\"rightAligned\" value=\"$arg_ip_version\" >  ";
    print "<option value=\"IPV4\" selected=\"selected\">IPV4</option> ";
    print "<option value=\"IPV6\">IPV6</option> </select></td></tr>";
    
    #  TG number
    print "<tr><td>TG number(0-20) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"tg_number\"  maxlength=\"2\" value=\"$arg_tg_number\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Branch link type
    print "<tr><td>Branch link type : </td> <td><select name=\"branch_link_type\"  class=\"rightAligned\" value=\"$arg_branch_link_type\" >  ";
    print "<option value=\"NONE\" selected=\"selected\">NONE</option> ";
    print "<option value=\"DOWNLINK\">DOWNLINK</option> ";
    print "<option value=\"UPLINK\">UPLINK</option> </select></td></tr>";
    
    #   Restart on normal deactivation
    print "<tr><td>Restart on normal deactivation : </td> <td> <select name=\"restart_on_normal_deact\"  class=\"rightAligned\" value=\"$arg_restart_on_normal_deact\" >  ";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";

    #  Acknowledgement timeout
    print "<tr><td>Acknowledgement timeout(0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"ack_timeout\"  maxlength=\"5\" value=\"$arg_ack_timeout\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #  Maximum retry count
    print "<tr><td>Maximum retry count(0-255) :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"max_retry\"  maxlength=\"3\" value=\"$arg_max_retry\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    #   Liveness timeout
    print "<tr><td>Liveness timeout (1-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"liveness_timeout\"  maxlength=\"5\" value=\"$arg_liveness_timeout\" oninput=\"value=value.replace(/[^\\d]/g,'')\"/></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
    $arg_ee_ls_name=param('eelsname_unique');
    $arg_description=param('description');
    $arg_port_name=param('port_name');
    $arg_initially_active=param('initially_active');
    $arg_adj_cp_name=param('adj_cp_name');
    $arg_adj_cp_type=param('adj_cp_type');
    $arg_remote_ip_host=param('remote_ip_host');
    $arg_max_send_btu_size=param('max_send_btu_size');
    $arg_cp_cp_sess_support=param('cp_cp_sess_support');
    $arg_default_nn_server=param('default_nn_server');
    $arg_ip_version=param('ip_version');
    $arg_tg_number=param('tg_number');
    $arg_branch_link_type=param('branch_link_type');
    $arg_restart_on_normal_deact=param('restart_on_normal_deact');
    $arg_ack_timeout=param('ack_timeout');
    $arg_liveness_timeout=param('liveness_timeout');
    $arg_max_retry=param('max_retry');
    
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_adj_cp_name eq "") {
        $adj_cp_name="";
    }else
    {
        $adj_cp_name=",adj_cp_name=$arg_adj_cp_name";
    }
    
    if ($arg_max_retry eq "") {
        $max_retry="";
    }else
    {
        $max_retry=",max_retry=$arg_max_retry";
    }
    
    if ($arg_tg_number eq "") {
        $tg_number="";
    }else
    {
        $tg_number=",tg_number=$arg_tg_number";
    }
    
    if ($arg_liveness_timeout eq "") {
        $liveness_timeout="";
    }else
    {
        $liveness_timeout=",liveness_timeout=$arg_liveness_timeout";
    }
    
    if ($arg_max_send_btu_size eq "") {
        $max_send_btu_size="";
    }else
    {
        $max_send_btu_size=",max_send_btu_size=$arg_max_send_btu_size";
    }
    
    if ($arg_ack_timeout eq "") {
        $ack_timeout="";
    }else
    {
        $ack_timeout=",ack_timeout=$arg_ack_timeout"
    }

    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_ls,ls_name=$arg_ee_ls_name,port_name=$arg_port_name , initially_active=$arg_initially_active , remote_ip_host=$arg_remote_ip_host, adj_cp_type=$arg_adj_cp_type , cp_cp_sess_support=$arg_cp_cp_sess_support , ip_version=$arg_ip_version , default_nn_server=$arg_default_nn_server , branch_link_type=$arg_branch_link_type , restart_on_normal_deact=$arg_restart_on_normal_deact $tg_number $liveness_timeout  $max_send_btu_size  $ack_timeout  $description $adj_cp_name  $max_retry`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_ip_ls,ls_name=$arg_ee_ls_name,port_name=$arg_port_name , initially_active=$arg_initially_active , remote_ip_host=$arg_remote_ip_host, adj_cp_type=$arg_adj_cp_type , cp_cp_sess_support=$arg_cp_cp_sess_support , ip_version=$arg_ip_version , default_nn_server=$arg_default_nn_server , branch_link_type=$arg_branch_link_type , restart_on_normal_deact=$arg_restart_on_normal_deact $tg_number $liveness_timeout  $max_send_btu_size  $ack_timeout  $description $adj_cp_name  $max_retry";
   
# Display output of snaadmin query_node
   print " Display Output from Add Enterprise Extender Link Station :";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

