#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_pu_name, $arg_description, $arg_bkup_dlus_name,$arg_dlus_name, $arg_initially_active, $arg_conventional_lu_compression, $arg_dlus_retry_limit, $arg_pu_id, $description, $dlus_name, $bkup_dlus_name, $pu_id,$dlus_retry_limit,$time, $line, @data, @contents);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_pu_name=param('pu_name_unique');

if ($arg_pu_name eq "") {
    $arg_description="";
    $arg_bkup_dlus_name="";
    $arg_dlus_name="";
    $arg_initially_active="NO";
    $arg_dlus_retry_limit="0";
    $arg_conventional_lu_compression="NO";
    $arg_pu_id="00000000";
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  Port name
    print "<tr><td>* PU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"pu_name_unique\" maxlength=\"8\" value=\"$arg_pu_name\" required=\"required\" /></td></tr>";
    
    #  Description
   print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";

    #   DLUS server name
   print "<tr><td>DLUS server name :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"dlus_name\" maxlength=\"17\" value=\"$arg_dlus_name\" /></td></tr>";
    
    #  Backup DLUS server name
    print "<tr><td>Backup DLUS server name : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"bkup_dlus_name\" maxlength=\"17\" value=\"$arg_bkup_dlus_name\"/></td></tr>";
    
    #  PU id
    print "<tr><td>* PU id : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"pu_id\" maxlength=\"8\" value=\"$arg_pu_id\" required=\"required\" oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";

    #  Initially active?
   print "<tr><td>Initially active ? </td> <td> <select name=\"initially_active\" class=\"rightAligned\" value=\"$arg_initially_active\" >  ";
   print "<option value=\"YES\" >YES</option> ";
   print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";
    
    #   Retry contacting DLUS indefinitely?
    print "<tr><td>Retry contacting DLUS indefinitely? (0-65535) : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"dlus_retry_limit\" maxlength=\"5\" value=\"$arg_dlus_retry_limit\" /></td></tr>";
    
    #   Compression Supported
    print "<tr><td>Compression Supported ? </td> <td><select name=\"conventional_lu_compression\" class=\"rightAligned\" value=\"$arg_conventional_lu_compression\" >  ";
    print "<option value=\"YES\">YES</option> ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> </select></td></tr>";

    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_pu_name=param('pu_name_unique');
   $arg_description=param('description');
   $arg_bkup_dlus_name=param('bkup_dlus_name');
   $arg_dlus_name=param('dlus_name');
   $arg_initially_active=param('initially_active');
   $arg_pu_id=param('pu_id');
   $arg_conventional_lu_compression=param('conventional_lu_compression');
   $arg_dlus_retry_limit=param('dlus_retry_limit');

   
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    if ($arg_dlus_name eq "") {
        $dlus_name="";
    }else
    {
        $dlus_name=",dlus_name=$arg_dlus_name";
    }
    
    if ($arg_bkup_dlus_name eq "") {
        $bkup_dlus_name="";
    }else
    {
        $bkup_dlus_name=",bkup_dlus_name=$arg_bkup_dlus_name";
    }
    
    if ($arg_dlus_retry_limit eq "") {
        $dlus_retry_limit="";
    }else
    {
        $dlus_retry_limit=",dlus_retry_limit=$arg_dlus_retry_limit";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_internal_pu, pu_name= $arg_pu_name, initially_active=$arg_initially_active, conventional_lu_compression=$arg_conventional_lu_compression, pu_id=0x$arg_pu_id $bkup_dlus_name $dlus_name $description $dlus_retry_limit`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_internal_pu, pu_name= $arg_pu_name, initially_active=$arg_initially_active, conventional_lu_compression=$arg_conventional_lu_compression, pu_id=0x$arg_pu_id $bkup_dlus_name $dlus_name $description $dlus_retry_limit";
   
   print "Display Output from Add DLUR PU:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "<br>$line";
   }
}
#

exit 0; 

