#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_fqplu_name, $arg_description, $arg_lu_alias, $arg_password, $description, $lu_alias,
    $time, $line, @data, @contents, @list);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_fqplu_name=param('fqplu_name_ss_unique');
if ($arg_fqplu_name eq "") {
    $arg_description="";
    $arg_lu_alias="";
    $arg_fqplu_name="";
    $arg_password="0000000000000000";
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_local_lu`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/lu_alias/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @list, $data[1];
            next;
        }
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #    Description
    print "<tr> <td>Description : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  Local LU alias
    print "<tr><td>Local LU alias :</td> <td><select name=\"lu_alias\" class=\"rightAligned\" value=\"$arg_lu_alias\" >  ";
    print "<option value=\"\"></option> ";
    foreach $line (@list) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #   * Fully-qualified partner LU name
   print "<tr> <td>* Fully-qualified partner LU name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"fqplu_name_ss_unique\"  maxlength=\"17\" value=\"$arg_fqplu_name\" required=\"required\" /></td></tr>";
    
    #   * Password
   print "<tr> <td>* Password : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"password\"  maxlength=\"16\" value=\"$arg_password\" required=\"required\" oninput=\"value=value.replace(/[^0-9a-fA-F]/g,'')\" /></td></tr>";
    
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
} else {
  
   $arg_description=param('description');
   $arg_lu_alias=param('lu_alias');
   $arg_fqplu_name=param('fqplu_name_ss_unique');
   $arg_password=param('password');
  
    
#  Make call to set items
#   Code to be added here
#
    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    if ($arg_lu_alias eq "") {
        $lu_alias="";
    }else
    {
        $lu_alias=",lu_alias=$arg_lu_alias";
    }
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu_lu_password, fqplu_name=$arg_fqplu_name, password=0x$arg_password $description $lu_alias`;
    
    print "Debug: sudo -u snauser /opt/ibm/sna/bin/snaadmin define_lu_lu_password, fqplu_name=$arg_fqplu_name, password=0x$arg_password $description $lu_alias";
   
# Display output of snaadmin query_node
   print "<br> Display Output from Add LU 6.2 Session Security Definition :";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

