#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_tp_name, $arg_list_name, $arg_description, $arg_conv_type, $arg_security_rqd, $arg_sync_level, $arg_pip_allowed, $description, $list_name, $time, $line, @data, @contents, @list);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_tp_name=param('tp_name_unique');

if ($arg_tp_name eq "") {
    $arg_description="";
    $arg_list_name="";
    $arg_security_rqd="NO";
    $arg_conv_type="EITHER";
    $arg_sync_level="SYNCPT_NEGOTIABLE";
    $arg_pip_allowed="YES";
    
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_security_access_list`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/list_name/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @list, $data[1];
            next;
        }
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    #  * Name
    print "<tr><td>* Name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"tp_name_unique\" maxlength=\"64\" value=\"$arg_tp_name\" required=\"required\" /></td></tr>";
    
    #  Description
    print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    #  Security Access List name
    print "<tr><td>Security Access List name :</td> <td><select name=\"list_name\" class=\"rightAligned\" value=\"$arg_list_name\" >  ";
    print "<option value=\"\"></option> ";
    foreach $line (@list) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #  Conversation type(s) supported
    print "<tr><td>Conversation type(s) supported : </td> <td><select name=\"conv_type\" class=\"rightAligned\" value=\"$arg_conv_type\" >  ";
    print "<option value=\"EITHER\" selected=\"selected\">EITHER</option> ";
    print "<option value=\"BASIC\">BASIC</option>";
    print "<option value=\"MAPPED\">MAPPED</option></select></td></tr>";
    
    #   Conversation security is required?
    print "<tr><td> Conversation security is required ? </td> <td> <select name=\"security_rqd\" class=\"rightAligned\" value=\"$arg_security_rqd\" >  ";
    print "<option value=\"NO\" selected=\"selected\">NO</option> ";
    print "<option value=\"YES\">YES</option></select></td></tr>";
    
    #   Synchronization level supported?
    print "<tr><td>Synchronization level supported ? </td> <td><select name=\"sync_level\" class=\"rightAligned\" value=\"$arg_sync_level\" >  ";
    print "<option value=\"SYNCPT_NEGOTIABLE\" selected=\"selected\">SYNCPT_NEGOTIABLE</option> ";
    print "<option value=\"NONE\">NONE</option> ";
    print "<option value=\"CONFIRM_SYNC_LEVEL\">CONFIRM_SYNC_LEVEL</option> ";
    print "<option value=\"EITHER\">EITHER</option> ";
    print "<option value=\"SYNCPT_REQUIRED\">SYNCPT_REQUIRED</option></select></td></tr>";
    
    #   Program Initialization Parameters (PIP) allowed?
    print "<tr><td>Program Initialization Parameters (PIP) allowed ?</td> <td> <select name=\"pip_allowed\" class=\"rightAligned\" value=\"$arg_pip_allowed\" >  ";
    print "<option value=\"YES\" selected=\"selected\">YES</option> ";
    print "<option value=\"NO\">NO</option></select></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_tp_name=param('tp_name_unique');
   $arg_description=param('description');
   $arg_security_rqd=param('security_rqd');
   $arg_sync_level=param('sync_level');
   $arg_conv_type=param('conv_type');
   $arg_list_name=param('list_name');
   $arg_pip_allowed=param('pip_allowed');

    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_list_name eq "") {
        $list_name="";
    }else
    {
        $list_name=",list_name=$arg_list_name";
    }
    
   
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tp, tp_name=$arg_tp_name, security_rqd=$arg_security_rqd, pip_allowed=$arg_pip_allowed, conv_type=$arg_conv_type, sync_level=$arg_sync_level $list_name $description`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tp, tp_name=$arg_tp_name, security_rqd=$arg_security_rqd, pip_allowed=$arg_pip_allowed, conv_type=$arg_conv_type, sync_level=$arg_sync_level $list_name $description";
   
    print "Display Output from Add LU 6.2 Transaction Program Definition:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

