#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2018 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $arg_tp_name, $arg_lualias, $arg_userid, $arg_description, $arg_group, $arg_type, $arg_env, $arg_path, $arg_arguments, $arg_stdin,  $arg_stdout, $arg_stderr, $description, $lualias, $group, $userid, $path,  $arguments, $stdin, $stdout, $stderr, $env, $time, $line, @data, @contents, @list);

@contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node`;
foreach $line (@contents) {
    next if ($line=~m/-----/);   # Do not display seperaters
    if ($line=~m/failed :/) {
        print "<b>Failed to access the node. \n</b>";
        exit -1;
    }
}

$arg_tp_name=param('tp_name_loadinfo_unique');

if ($arg_tp_name eq "") {
    $arg_description="";
    $arg_lualias="";
    $arg_userid="";
    $arg_group="";
    $arg_type="QUEUED";
    $arg_arguments="";
    $arg_path="";
    $arg_stdin="";
    $arg_stdout="";
    $arg_stderr="";
    $arg_env="";

    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin query_local_lu`;
    foreach $line (@contents) {
        next if ($line=~m/-----/);   # Do not display seperaters
        if ($line=~m/lu_alias/) {
            @data = split(/=/,$line);
            $data[1]=~s/^\s+|\s+$//g;   # This removes all blank characters
            push @list, $data[1];
            next;
        }
    }
    
    print "<form>";
    print "<table border=\"0\" cellpadding=\"0\" cellspacing=\"10\" width=\"100%\" style=\"border-collapse:separate; border-spacing:0px 10px;\"> ";
    print "<tbody> ";
    
    #  * TP name
    print "<tr><td>* TP name :</td> <td> <input type=\"text\" class=\"rightAligned\" name=\"tp_name_loadinfo_unique\" maxlength=\"64\" value=\"$arg_tp_name\" required=\"required\" /></td></tr>";
    
    #  LU alias
    print "<tr><td>LU alias :</td> <td><select name=\"lualias\" class=\"rightAligned\" value=\"$arg_lualias\" >  ";
    print "<option value=\"\"></option> ";
    foreach $line (@list) {
        print "<option value=\"$line\">$line</option> ";
    }
    print "</select></td></tr>";
    
    #  Description
   print "<tr><td>Description :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"description\"  maxlength=\"31\" value=\"$arg_description\" /></td></tr>";
    
    # * User ID
    print "<tr><td>* User ID : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"userid\" maxlength=\"64\" value=\"$arg_userid\" required=\"required\"/></td></tr>";
    
    #  Group ID
    print "<tr><td>Group ID :</td> <td><input type=\"text\" class=\"rightAligned\" name=\"group\" maxlength=\"64\" value=\"$arg_group\"/></td></tr>";
    
    #   Load Type
    print "<tr><td>Load Type </td> <td> <select name=\"type\" class=\"rightAligned\" value=\"$arg_type\" >  ";
    print "<option value=\"QUEUED\" selected=\"selected\">QUEUED</option> ";
    print "<option value=\"QUEUED-BROADCAST\">QUEUED-BROADCAST</option> ";
    print "<option value=\"NON-QUEUED\">NON-QUEUED</option></select></td></tr>";
    
    #   Path
    print "<tr><td>Path : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"path\" maxlength=\"255\" value=\"$arg_path\" /></td></tr>";
    
    #   Arguments
    print "<tr><td>Arguments : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"arguments\" maxlength=\"255\" value=\"$arg_arguments\" /></td></tr>";
    
    #   stdin Path
    print "<tr><td>stdin Path : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"stdin\" maxlength=\"255\" value=\"$arg_stdin\" /></td></tr>";
    
    #   stdout Path
    print "<tr><td>stdout Path  : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"stdout\" maxlength=\"255\" value=\"$arg_stdout\" /></td></tr>";
    
    #   stderr Path
    print "<tr><td>stderr Path : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"stderr\" maxlength=\"255\" value=\"$arg_stderr\" /></td></tr>";
    
    #   Environment
    print "<tr><td>Environment : </td> <td><input type=\"text\" class=\"rightAligned\" name=\"env\" maxlength=\"255\" value=\"$arg_env\" /></td></tr>";
    
    print "<tr> <td><input type=\"submit\" value=\"Submit\"></td> <td><input type=\"reset\"/></td></tr>";
    print "</tbody> ";
    print "</table> ";
    print "</form>";
    print "<p>";
    
} else {
   $arg_tp_name=param('tp_name_loadinfo_unique');
   $arg_description=param('description');
   $arg_lualias=param('lualias');
   $arg_userid=param('userid');
   $arg_group=param('group');
   $arg_type=param('type');
   $arg_path=param('path');
   $arg_arguments=param('arguments');
   $arg_stdin=param('stdin');
   $arg_stdout=param('stdout');
   $arg_stderr=param('stderr');
   $arg_env=param('env');

    if ($arg_description eq "") {
        $description="";
    }else
    {
        $description=",description=$arg_description";
    }
    
    if ($arg_lualias eq "") {
        $lualias="";
    }else
    {
        $lualias=",lualias=$arg_lualias";
    }
    
    if ($arg_userid eq "") {
        $userid="";
    }else
    {
        $userid=",userid=$arg_userid";
    }
    
    if ($arg_group eq "") {
        $group="";
    }else
    {
        $group=",group=$arg_group";
    }
    
    if ($arg_arguments eq "") {
        $arguments="";
    }else
    {
        $arguments=",arguments=$arg_arguments";
    }

    if ($arg_path eq "") {
        $path="";
    }else
    {
        $path=",path=$arg_path";
    }
    
    if ($arg_stdout eq "") {
        $stdout="";
    }else
    {
        $stdout=",stdout=$arg_stdout";
    }
    
    if ($arg_stdin eq "") {
        $stdin="";
    }else
    {
        $stdin=",stdin=$arg_stdin";
    }
    
    if ($arg_stderr eq "") {
        $stderr="";
    }else
    {
        $stderr=",stderr=$arg_stderr";
    }
    
    if ($arg_env eq "") {
        $env="";
    }else
    {
        $env=",env=$arg_env";
    }
    @contents = `sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tp_load_info,tp_name=$arg_tp_name, type=$arg_type $description $lualias $group $userid $path $arguments $stdin $stdout $stderr $env`;
    
    print "sudo -u snauser /opt/ibm/sna/bin/snaadmin define_tp_load_info,tp_name=$arg_tp_name, type=$arg_type $description $lualias $group $userid $path $arguments $stdin $stdout $stderr $env";
   
   print "Display Output from Add LU 6.2 Transaction Program Load Information:";
    
   foreach $line (@contents) {
      next if ($line=~m/-----/);   # Do not display seperaters
      $line=~s/ /&nbsp;/g;
      print "$line";
   }
}
#

exit 0; 

