#!/usr/bin/perl -w
#############################################################
#                                                           #
# Copyright IBM Corporation 2004, 2018 All rights reserved. #
#                                                           #
#############################################################
use CGI qw(:all);
use strict;

my ($time, $arg, $line, @contents,@title);
$arg=" ";

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;
# print "<font face=\"Courier, Helvetica\" height=\"10\" width=\"10\"";   # Force to mono-space

#! if parameter grep is set, call dlustat and grep on the '='
$arg=param('config');
if  ($arg=~/^cfg_defnode/) {
    @title = "<b>Config Define Node: $time</b><br>";
    @contents=`../cscbin/cfg_defnode.pl`;     # Configure panel for define node
} elsif ($arg=~/^cfg_add_ethernet_dlc/) {
    @title = "<b>Add Ethernet DLC: $time</b><br>";
    @contents=`../cscbin/cfg_add_ethernet_dlc.pl`;     # Configure panel for Ethernet dlc
} elsif ($arg=~/^cfg_add_ethernet_port/) {
    @title = "<b>Add Ethernet Port: $time</b><br>";
    @contents=`../cscbin/cfg_add_ethernet_port.pl`;     # Configure panel for Ethernet Port
}elsif ($arg=~/^cfg_add_ethernet_ls/) {
    @title = "<b>Add Ethernet Link Station: $time</b><br>";
    @contents=`../cscbin/cfg_add_ethernet_ls.pl`;     # Configure panel for Ethernet Link Station
}elsif ($arg=~/^cfg_add_ee_dlc/) {
    @title = "<b>Add Enterprise Extender DLC: $time</b><br>";
    @contents=`../cscbin/cfg_add_ee_dlc.pl`;     # Configure panel for Enterprise Extender dlc
} elsif ($arg=~/^cfg_add_ee_port/) {
    @title = "<b>Add Enterprise Extender Port: $time</b><br>";
    @contents=`../cscbin/cfg_add_ee_port.pl`;     # Configure panel for Enterprise Extender Port
}elsif ($arg=~/^cfg_add_ee_ls/) {
    @title = "<b>Add Enterprise Extender Link Station: $time</b><br>";
    @contents=`../cscbin/cfg_add_ee_ls.pl`;     # Configure panel for Enterprise Extender Link Station
}elsif ($arg=~/^cfg_add_cn/) {
    @title = "<b>Add APPN Connection Network: $time</b><br>";
    @contents=`../cscbin/cfg_add_cn.pl`;     # Configure panel for APPN Connection Network
}elsif ($arg=~/^cfg_add_pu/) {
    @title = "<b>Add DLUR PU: $time</b><br>";
    @contents=`../cscbin/cfg_add_pu.pl`;     # Configure panel for DLUR PU
}elsif ($arg=~/^cfg_add_dspu_temp/) {
    @title = "<b>Add DSPU Template: $time</b><br>";
    @contents=`../cscbin/cfg_add_dspu_temp.pl`;     # Configure panel for DSPU Template
}elsif ($arg=~/^cfg_add_lu0-3_range/) {
    @title = "<b>Add Range Of LUs Type 0-3: $time</b><br>";
    @contents=`../cscbin/cfg_add_lu0-3_range.pl`;     # Configure panel for Range Of LUs Type 0-3 
}elsif ($arg=~/^cfg_add_lu0-3/) {
    @title = "<b>Add LU Type 0-3: $time</b><br>";
    @contents=`../cscbin/cfg_add_lu0-3.pl`;     # Configure panel for LU Type 0-3 
}elsif ($arg=~/^cfg_add_lu_pool/) {
    @title = "<b>Add LU Pool: $time</b><br>";
    @contents=`../cscbin/cfg_add_lu_pool.pl`;     # Configure panel for LU Pool
}elsif ($arg=~/^cfg_add_dep_lu6.2/) {
    @title = "<b>Add Dependent LU Type 6.2: $time</b><br>";
    @contents=`../cscbin/cfg_add_dep_lu6.2.pl`;     # Configure panel for Dependent LU Type 6.2
}elsif ($arg=~/^cfg_add_indep_lu6.2/) {
    @title = "<b>Add Independent LU Type 6.2: $time</b><br>";
    @contents=`../cscbin/cfg_add_indep_lu6.2.pl`;     # Configure panel for Independent LU Type 6.2
}elsif ($arg=~/^cfg_add_dslu/) {
    @title = "<b>Add Downstream LU: $time</b><br>";
    @contents=`../cscbin/cfg_add_dslu.pl`;     # Configure panel for Downstream LU
}elsif ($arg=~/^cfg_add_side_info/) {
    @title = "<b>Add Side Information: $time</b><br>";
    @contents=`../cscbin/cfg_add_side_info.pl`;     # Configure panel for Side Information
}elsif ($arg=~/^cfg_add_partner_lu/) {
    @title = "<b>Add LU 6.2 Partner LU: $time</b><br>";
    @contents=`../cscbin/cfg_add_plu.pl`;     # Configure panel for LU 6.2 Partner LU
}elsif ($arg=~/^cfg_add_mode/) {
    @title = "<b>Add LU 6.2 Mode: $time</b><br>";
    @contents=`../cscbin/cfg_add_mode.pl`;     # Configure panel for LU 6.2 Mode
}elsif ($arg=~/^cfg_add_tp_load_info/) {
    @title = "<b>Add LU 6.2 Transaction Program Load Information: $time</b><br>";
    @contents=`../cscbin/cfg_add_tp_load_info.pl`;     # Configure panel for LU 6.2 Transaction Program Load Information 
}elsif ($arg=~/^cfg_add_tp/) {
    @title = "<b>Add LU 6.2 Transaction Program Definitions: $time</b><br>";
    @contents=`../cscbin/cfg_add_tp.pl`;     # Configure panel for Transaction Program Definition
}elsif ($arg=~/^cfg_add_access_list/) {
    @title = "<b>Add LU 6.2 Access List: $time</b><br>";
    @contents=`../cscbin/cfg_add_access_list.pl`;     # Configure panel for LU 6.2 Access List
}elsif ($arg=~/^cfg_add_userid_pass/) {
    @title = "<b>Add LU 6.2 User: $time</b><br>";
    @contents=`../cscbin/cfg_add_userid_pass.pl`;     # Configure panel for LU 6.2 User
}elsif ($arg=~/^cfg_add_st/) {
    @title = "<b> Define LU 6.2 Session Timeout: $time</b><br>";
    @contents=`../cscbin/cfg_add_st.pl`;     # Configure panel for LU 6.2 Session Timeout
}elsif ($arg=~/^cfg_add_focal_point/) {
    @title = "<b> Add Focal Point: $time</b><br>";
    @contents=`../cscbin/cfg_add_focal_point.pl`;     # Configure panel for Focal Point
}elsif ($arg=~/^cfg_add_dir_entry/) {
    @title = "<b> Add Partner LU: $time</b><br>";
    @contents=`../cscbin/cfg_add_dir_entry.pl`;     # Configure panel for Partner LU
}elsif ($arg=~/^cfg_add_ls_routing/) {
    @title = "<b> Add Partner LU: $time</b><br>";
    @contents=`../cscbin/cfg_add_ls_routing.pl`;     # Configure panel for Partner LU
}elsif ($arg=~/^cfg_add_tn_defaults/) {
    @title = "<b> Add TN3270 Server Defaults: $time</b><br>";
    @contents=`../cscbin/cfg_add_tn_defaults.pl`;     # Configure panel for TN3270 Server Defaults 
}elsif ($arg=~/^cfg_add_ssl_ldap/) {
    @title = "<b> Add TN Server SSL Client Authentication: $time</b><br>";
    @contents=`../cscbin/cfg_add_ssl_ldap.pl`;     # Configure panel forTN Server SSL Client Authentication 
}elsif ($arg=~/^cfg_add_ss/) {
    @title = "<b>Add LU 6.2 Session Security Definition: $time</b><br>";
    @contents=`../cscbin/cfg_add_ss.pl`;     # Configure panel for LU 6.2 Session Security Definition
}elsif ($arg=~/^cfg_add_tn3270_el/) {
    @title = "<b>Add TN3270 Express Logon: $time</b><br>";
    @contents=`../cscbin/cfg_add_tn3270_el.pl`;     # Configure panel for TN3270 Express Logon
}elsif ($arg=~/^cfg_add_tn3270_ass/) {
    @title = "<b>Add TN Association: $time</b><br>";
    @contents=`../cscbin/cfg_add_tn3270_ass.pl`;     # Configure panel for TN Association
}elsif ($arg=~/^cfg_add_tn3270_access/) {
    @title = "<b>Add TN3270 Server Access: $time</b><br>";
    @contents=`../cscbin/cfg_add_tn3270_access.pl`;     # Configure panel for TN3270 Server Access
}elsif ($arg=~/^cfg_add_tn_redirect/) {
    @title = "<b>Add TN Redirector Access: $time</b><br>";
    @contents=`../cscbin/cfg_add_tn_redirect.pl`;     # Configure panel for TN Redirector Access
}


$arg=param('nodecpalias');
if ($arg ne "") {
      @title = "<b>Config Define Node: $time</b><br>";
      @contents=`../cscbin/cfg_defnode.pl`;     # Configure panel input top process
}

$arg=param('ethdlcname_unique');
if ($arg ne "") {
      @title = "<b>Add Ethernet DLC: $time</b><br>";
      @contents=`../cscbin/cfg_add_ethernet_dlc.pl `;    # Configure panel for Ethernet dlc
}

$arg=param('ethportname_unique');
if ($arg ne "") {
      @title = "<b>Add Ethernet Port: $time</b><br>";
      @contents=`../cscbin/cfg_add_ethernet_port.pl`;     # Configure panel for Ethernet Port
}

$arg=param('ethlsname_unique');
if ($arg ne "") {
      @title = "<b>Add Ethernet Link Station: $time</b><br>";
      @contents=`../cscbin/cfg_add_ethernet_ls.pl`;     # Configure panel for Ethernet Link Station
}

$arg=param('eedlcname_unique');
if ($arg ne "") {
      @title = "<b>Add Enterprise Extender DLC: $time</b><br>";
      @contents=`../cscbin/cfg_add_ee_dlc.pl `;    # Configure panel for Enterprise Extender dlc
}

$arg=param('eeportname_unique');
if ($arg ne "") {
      @title = "<b>Add Enterprise Extender Port: $time</b><br>";
      @contents=`../cscbin/cfg_add_ee_port.pl`;     # Configure panel for Enterprise Extender Port
}

$arg=param('eelsname_unique');
if ($arg ne "") {
      @title = "<b>Add Enterprise Extender Link Station: $time</b><br>";
      @contents=`../cscbin/cfg_add_ee_ls.pl`;     # Configure panel for Enterprise Extender Link Station
}

$arg=param('fqcn_name_unique');
if ($arg ne "") {
      @title = "<b>Add APPN Connection Network: $time</b><br>";
      @contents=`../cscbin/cfg_add_cn.pl`;     # Configure panel for APPN Connection Network
}

$arg=param('pu_name_unique');
if ($arg ne "") {
      @title = "<b>Add DLUR PU: $time</b><br>";
      @contents=`../cscbin/cfg_add_pu.pl`;     # Configure panel for DLUR PU
}

$arg=param('dspu_template_unique');
if ($arg ne "") {
      @title = "<b>Add DSPU Template: $time</b><br>";
      @contents=`../cscbin/cfg_add_dspu_temp.pl`;     # Configure panel for DSPU Template
}

$arg=param('lu0-3_name_unique');
if ($arg ne "") {
      @title = "<b>Add LU Type 0-3: $time</b><br>";
      @contents=`../cscbin/cfg_add_lu0-3.pl`;     # Configure panel for LU Type 0-3
}

$arg=param('lu0-3_base_name_unique');
if ($arg ne "") {
      @title = "<b>Add Range Of LUs Type 0-3: $time</b><br>";
      @contents=`../cscbin/cfg_add_lu0-3_range.pl`;     # Configure panel for Range Of LUs Type 0-3 
}

$arg=param('pool_name_unique');
if ($arg ne "") {
      @title = "<b>Add LU Pool: $time</b><br>";
      @contents=`../cscbin/cfg_add_lu_pool.pl`;     # Configure panel for LU Pool
}

$arg=param('dep_lu_alias_unique');
if ($arg ne "") {
      @title = "<b> Add Dependent LU Type 6.2: $time</b><br>";
      @contents=`../cscbin/cfg_add_dep_lu6.2.pl`;     # Configure panel for Dependent LU Type 6.2 
}

$arg=param('indep_lu_alias_unique');
if ($arg ne "") {
      @title = "<b>Add Independent LU Type 6.2: $time</b><br>";
      @contents=`../cscbin/cfg_add_indep_lu6.2.pl`;     # Configure panel for Independent LU Type 6.2 
}

$arg=param('dslu_name_unique');
if ($arg ne "") {
      @title = "<b>Add Downstream LU: $time</b><br>";
      @contents=`../cscbin/cfg_add_dslu.pl`;     # Configure panel for Downstream LU
}

$arg=param('sym_dest_name_unique');
if ($arg ne "") {
      @title = "<b>Add Side Information: $time</b><br>";
      @contents=`../cscbin/cfg_add_side_info.pl`;     # Configure panel for Side Information
}

$arg=param('fqplu_name_unique');
if ($arg ne "") {
      @title = "<b>Add LU 6.2 Partner LU: $time</b><br>";
      @contents=`../cscbin/cfg_add_plu.pl`;     # Configure panel for LU 6.2 Partner LU
}

$arg=param('mode_name_unique');
if ($arg ne "") {
      @title = "<b>Add LU 6.2 Mode: $time</b><br>";
      @contents=`../cscbin/cfg_add_mode.pl`;     # Configure panel for LU 6.2 Mode
}

$arg=param('tp_name_unique');
if ($arg ne "") {
      @title = "<b>Add LU 6.2 Transaction Program Definitions: $time</b><br>";
      @contents=`../cscbin/cfg_add_tp.pl`;     # Configure panel for LU 6.2 Transaction Program Definitions
}

$arg=param('tp_name_loadinfo_unique');
if ($arg ne "") {
      @title = "<b>Add LU 6.2 Transaction Program Load Information: $time</b><br>";
      @contents=`../cscbin/cfg_add_tp_load_info.pl`;     # Configure panel for LU 6.2 Transaction Program Load Information
}

$arg=param('fqplu_name_ss_unique');
if ($arg ne "") {
      @title = "<b>Add LU 6.2 Session Security Definition: $time</b><br>";
      @contents=`../cscbin/cfg_add_ss.pl`;     # Configure panel for LU 6.2 Session Security Definition   
}

$arg=param('list_name_unique');
if ($arg ne "") {
      @title = "<b>Add LU 6.2 Access List: $time</b><br>";
      @contents=`../cscbin/cfg_add_access_list.pl`;     # Configure panel for LU 6.2 Access List
}

$arg=param('user_id_unique');
if ($arg ne "") {
      @title = "<b>Add LU 6.2 User: $time</b><br>";
      @contents=`../cscbin/cfg_add_userid_pass.pl`;     # Configure panel for LU 6.2 User
}

$arg=param('timeout_unique');
if ($arg ne "") {
      @title = "<b> Define LU 6.2 Session Timeout: $time</b><br>";
      @contents=`../cscbin/cfg_add_st.pl`;     # Configure panel for LU 6.2 Session Timeout
}

$arg=param('ms_category_unique');
if ($arg ne "") {
      @title = "<b> Add Focal Point: $time</b><br>";
      @contents=`../cscbin/cfg_add_focal_point.pl`;     # Configure panel for Focal Point
}

$arg=param('resource_name_unique');
if ($arg ne "") {
      @title = "<b> Add Partner LU: $time</b><br>";
      @contents=`../cscbin/cfg_add_dir_entry.pl`;     # Configure panel for Partner LU
}

$arg=param('lu_name_unique');
if ($arg ne "") {
      @title = "<b> Add Partner LU: $time</b><br>";
      @contents=`../cscbin/cfg_add_ls_routing.pl`;     # Configure panel for Partner LU
}

$arg=param('force_responses_unique');
if ($arg ne "") {
      @title = "<b> Add TN3270 Server Defaults: $time</b><br>";
      @contents=`../cscbin/cfg_add_tn_defaults.pl`;     # Configure panel for TN3270 Server Defaults 
}

$arg=param('auth_type_unique');
if ($arg ne "") {
      @title = "<b> Add TN Server SSL Client Authentication: $time</b><br>";
      @contents=`../cscbin/cfg_add_ssl_ldap.pl`;     # Configure panel for TN Server SSL Client Authentication
}

$arg=param('dcas_server_unique');
if ($arg ne "") {
      @title = "<b> Add TN3270 Express Logon: $time</b><br>";
      @contents=`../cscbin/cfg_add_tn3270_el.pl`;     # Configure panel for TN3270 Express Logon
}

$arg=param('display_lu_name_unique');
if ($arg ne "") {
      @title = "<b> Add TN Association: $time</b><br>";
      @contents=`../cscbin/cfg_add_tn3270_ass.pl`;     # Configure panel for TN Association
}

$arg=param('port_number_unique');
if ($arg ne "") {
      @title = "<b> Add TN3270 Server Access: $time</b><br>";
      @contents=`../cscbin/cfg_add_tn3270_access.pl`;     # Configure panel for TN3270 Server Access
}

$arg=param('client_port_unique');
if ($arg ne "") {
      @title = "<b> Add TN Redirector Access: $time</b><br>";
      @contents=`../cscbin/cfg_add_tn_redirect.pl`;     # Configure panel for TN Redirector Access
}

#  Print title
foreach $line (@title) {
   chomp $line;
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}
#Print output
foreach $line (@contents) {
   chomp $line;
#  On none active lines, print end of list in html format
#   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}
#print "</p></form></font>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

