#!/usr/bin/perl -w

#  Purpose of the script is to call snaadmin query_sna_net and display
#  the DLUR PU state of all PUs on all servers in a domain
#

use strict;

 my ( $srv_index, $srvcnt, $luname, $aliasname, $sysname, $descript,  
      @servername, @data, @status );

#  Initialize for scalar declaration
$srvcnt = 0;
$luname = " ";

@status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_node_all`;             # Get detailed Link Station information

foreach(@status) {
   chomp;
   if (/^query_node_all/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }
 
  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break parameter = value

   next if (@data == 0);        # on blank line, skip

   if ($data[0]=~m/^node_name/) {       # get link station name  
     $servername[$srvcnt]=$data[1];
     $servername[$srvcnt]=~s/ //g;
#     printf("   Server %1d  %8s \n", $srvcnt+1, $servername[$srvcnt]);
     $srvcnt++;
     next;                                
   }
   
}
# print "\n------------------------------------------------\n";
   
#
#  Process the DLUR PU information
#

#  Initialize for scalar declaration
$srv_index = 0;

while ($srv_index < $srvcnt) 
{

    @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $servername[$srv_index] -d query_local_lu` or die "Node $servername[$srv_index] not recognized $!\n";

#   Print header line
  printf("\n      Server: %s\n", $servername[$srv_index]);
  print "LU Name   LU ALias               Sys Name            Description \n";
  print "========  ========  ==============================  ============= \n";


   foreach(@status) {
      chomp;
     if (/^query_local_lu/) {
       print " Cannot process node $servername[$srv_index]\n";
       exit -1;
     }

  #  Skip headers
     next if (/^------/);
     next if (/^list_option/);

     next if (/^\n/);

     @data = split(/=/,$_);   #Break NAU, LU, Type, Status

     next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

     if ($data[0]=~m/^lu_name/) {       # get LU name
       $luname = $data[1];
       $luname=~s/ //g;
     } elsif ($data[0]=~m/^description/) { # description
       $descript = "<nobr>$data[1]</nobr>";
       $descript=~s/ //g;
       next;
     } elsif ($data[0]=~m/^lu_alias/) {  # alias name
       $aliasname = $data[1];
       $aliasname=~s/ //g;
       next;
     } elsif ($data[0]=~m/^sys_name/) { # sys_name
       $sysname = $data[1];
       $sysname=~s/ //g;
       if (m/\"/) {
          $sysname="-------------------------------";
       } 
       printf("%8s %8s %32.32s   %s \n",
           $luname, $aliasname, $sysname, $descript);
       next;
     }
  }
  print "\n------------------------------------------------\n";
  $srv_index++;
  
}


