#!/usr/bin/perl -w
##################################################################
# Perl Script: rename_user.pl
# This script will read the files in the /opt/ibm/sna/web/cscbin
# directory and change the string "snauser" to the ID specified
# on the prompt. The /etc/sudoers file must be updated to include
# the same ID per the instructions found in the readme file - 
# /opt/ibm/sna/web/README.html 
#
# Note that the ID must be part of the "sna" group.
##################################################################

  use strict;

  print "Renaming user id for Web Admin in directory /opt/ibm/sna/web/cscbin.\n";

   # Prompt for new user id
  my $dir="/opt/ibm/sna/web/cscbin";
  print "New user id to set for Web Admin: ";
  my $newid=<STDIN>; chomp $newid;
  print "\n";

  my($file, $tmp_file, $line_no, $touch_flag);

  $line_no = 0;   # set line_no to integer
  opendir(WEBBINDIR, $dir) || die "Cannot open $dir: $!";
  $tmp_file="$dir/temp";

  # In loop, open each file and $dir/temp
  # Loop through input file and sub new userid for 'snauser'
  #     write out each line of tempfile
  # Close file and temp file
  # Rename file to file~ and temp to file
  while ($file=readdir WEBBINDIR) {
      next if (-d "$dir/$file");
      if (! open(F, "$dir/$file") ) {
          warn "Cannot search $file: $!";
          next;
      }

      if (! open(TMPF, ">$tmp_file") ) {
          warn "Cannot open temp file: $tmp_file";
          next;
      }
      $line_no = 1;
      $touch_flag = 0;   # used to know if file is updated
      while(<F>) {
          if (s/snauser/$newid/) {
              print "$file: line: $line_no $_";
              $touch_flag++;
          }
          print TMPF $_;
          $line_no++;
      }
      close(F);
      close(TMPF);

      if ($touch_flag != 0) # Only if modified should file be updated
      {
        if (! rename "$dir/$file", "$dir/$file~") {
           warn "Could not rename $dir/$file: $!";
        }
        if (! rename "$tmp_file", "$dir/$file") {
           warn "Could not rename $tmp_file to $dir/$file: $!";
        }
        print "Processed $dir/$file \n\n";
      }
  }
  closedir(WEBBINDIR);

  if ( system ("chmod 755 $dir/*.cgi $dir/*.pl") ) {
      print " Could not set permissions of updated file \n";
  }
  if ( system ("chown bin.sna $dir/*.cgi $dir/*.pl") ) {
      print " Could not change owner to sna group for files touched \n";
  }

  print " End of rename for user id processing\n";

