/**INC+***********************************************************************/
/* Include: cmc.h                                                            */
/*                                                                           */
/* Purpose: CPI-C types, constants and function prototypes file              */
/*                                                                           */
/* (C) COPYRIGHT DATA CONNECTION LIMITED 1991, 1992, 1993, 1994, 1995        */
/*                                                                           */
/**INC-***********************************************************************/

#ifndef CMC_INCLUDED
#define CMC_INCLUDED

/*****************************************************************************/
/* Some constants are shared with the NOF API                                */
/*****************************************************************************/
#include <values_c.h>

/*****************************************************************************/
/* Type Definitions                                                          */
/*****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#define CM_INT32 AP_INT32
#define CM_PTR   *

typedef CM_INT32 CM_AE_QUAL_OR_AP_TITLE_FORMAT;
typedef CM_INT32 CM_ALLOCATE_CONFIRM_TYPE;
typedef CM_INT32 CM_BEGIN_TRANSACTION;
typedef CM_INT32 CM_CONVERSATION_SECURITY_TYPE;
typedef CM_INT32 CM_CONFIRMATION_URGENCY;
typedef CM_INT32 CM_CONTROL_INFORMATION_RECEIVED;
typedef CM_INT32 CM_CONVERSATION_QUEUE;
typedef CM_INT32 CM_CONVERSATION_STATE;
typedef CM_INT32 CM_CONVERSATION_TYPE;
typedef CM_INT32 CM_DATA_RECEIVED_TYPE;
typedef CM_INT32 CM_DEALLOCATE_TYPE;
typedef CM_INT32 CM_DIRECTORY_ENCODING;
typedef CM_INT32 CM_DIRECTORY_SYNTAX;
typedef CM_INT32 CM_END_TYPE;
typedef CM_INT32 CM_ERROR_DIRECTION;
typedef CM_INT32 CM_FILL;
typedef CM_INT32 CM_JOIN_TRANSACTION_TYPE;
typedef CM_INT32 CM_OOID;
typedef CM_INT32 CM_PARTNER_ID_SCOPE;
typedef CM_INT32 CM_PARTNER_ID_TYPE;
typedef CM_INT32 CM_PREPARE_DATA_PERMITTED_TYPE;
typedef CM_INT32 CM_PREPARE_TO_RECEIVE_TYPE;
typedef CM_INT32 CM_PROCESSING_MODE;
typedef CM_INT32 CM_RECEIVE_TYPE;
typedef CM_INT32 CM_REQUEST_TO_SEND_RECEIVED;
typedef CM_INT32 CM_RETURN_CODE;
typedef CM_INT32 CM_RETURN_CONTROL;
typedef CM_INT32 CM_SEND_RECEIVE_MODE;
typedef CM_INT32 CM_SEND_TYPE;
typedef CM_INT32 CM_STATUS_RECEIVED;
typedef CM_INT32 CM_SYNC_LEVEL;
typedef CM_INT32 CM_TIMEOUT;
typedef CM_INT32 CM_TRANSACTION_CONTROL;
typedef CM_INT32 XC_CONVERSATION_SECURITY_TYPE;
typedef CM_INT32 XC_SIGNAL_BEHAVIOR_TYPE;
typedef CM_INT32 XC_TP_NAME_TYPE;

/**STRUCT+********************************************************************/
/* Side information struct used by xcmssi to define side information         */
/*****************************************************************************/
typedef struct side_info_entry
{
  unsigned char   sym_dest_name[8];            /* symbolic destination name  */
  unsigned char   partner_LU_name[17];         /* fully Q'd PLU name         */
  unsigned char   reserved[3];                 /* future expansion ??        */
  XC_TP_NAME_TYPE TP_name_type;                /* set to XC_APPLICATION_TP   */
                                               /*  or to XC_SNA_SERVICE_TP   */
  unsigned char   TP_name[64];                 /* TP name                    */
  unsigned char   mode_name[8];                /* mode name                  */
  XC_CONVERSATION_SECURITY_TYPE
                  conversation_security_type;  /* set to CM_SECURITY_NONE    */
                                               /*  or to CM_SECURITY_PROGRAM */
                                               /*  or to CM_SECURITY_SAME or */
                                               /* CM_SECURITY_PROGRAM_STRONG */
  unsigned char   security_user_ID[8];         /* user_ID                    */
  unsigned char   security_password[8];        /* password                   */
} SIDE_INFO;
/**STRUCT-********************************************************************/


/*****************************************************************************/
/* Constant Definitions                                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Values for the conversation_state                                         */
/*****************************************************************************/
#define CM_INITIALIZE_STATE              (CM_CONVERSATION_STATE) 2
#define CM_SEND_STATE                    (CM_CONVERSATION_STATE) 3
#define CM_RECEIVE_STATE                 (CM_CONVERSATION_STATE) 4
#define CM_SEND_PENDING_STATE            (CM_CONVERSATION_STATE) 5
#define CM_CONFIRM_STATE                 (CM_CONVERSATION_STATE) 6
#define CM_CONFIRM_SEND_STATE            (CM_CONVERSATION_STATE) 7
#define CM_CONFIRM_DEALLOCATE_STATE      (CM_CONVERSATION_STATE) 8
#define CM_DEFER_RECEIVE_STATE           (CM_CONVERSATION_STATE) 9
#define CM_DEFER_DEALLOCATE_STATE        (CM_CONVERSATION_STATE) 10
#define CM_SYNC_POINT_STATE              (CM_CONVERSATION_STATE) 11
#define CM_SYNC_POINT_SEND_STATE         (CM_CONVERSATION_STATE) 12
#define CM_SYNC_POINT_DEALLOCATE_STATE   (CM_CONVERSATION_STATE) 13
#define CM_INITIALIZE_INCOMING_STATE     (CM_CONVERSATION_STATE) 14
#define CM_SEND_ONLY_STATE               (CM_CONVERSATION_STATE) 15
#define CM_RECEIVE_ONLY_STATE            (CM_CONVERSATION_STATE) 16
#define CM_SEND_RECEIVE_STATE            (CM_CONVERSATION_STATE) 17
#define CM_PREPARED_STATE                (CM_CONVERSATION_STATE) 18


/*****************************************************************************/
/* Values for the conversation_type                                          */
/*****************************************************************************/
#define CM_BASIC_CONVERSATION   (CM_CONVERSATION_TYPE) 0
#define CM_MAPPED_CONVERSATION  (CM_CONVERSATION_TYPE) 1


/*****************************************************************************/
/* Values for data_received                                                  */
/*****************************************************************************/
#define CM_NO_DATA_RECEIVED          (CM_DATA_RECEIVED_TYPE) 0
#define CM_DATA_RECEIVED             (CM_DATA_RECEIVED_TYPE) 1
#define CM_COMPLETE_DATA_RECEIVED    (CM_DATA_RECEIVED_TYPE) 2
#define CM_INCOMPLETE_DATA_RECEIVED  (CM_DATA_RECEIVED_TYPE) 3


/*****************************************************************************/
/* Values for the deallocate_type                                            */
/*****************************************************************************/
#define CM_DEALLOCATE_SYNC_LEVEL  (CM_DEALLOCATE_TYPE) 0
#define CM_DEALLOCATE_FLUSH       (CM_DEALLOCATE_TYPE) 1
#define CM_DEALLOCATE_CONFIRM     (CM_DEALLOCATE_TYPE) 2
#define CM_DEALLOCATE_ABEND       (CM_DEALLOCATE_TYPE) 3


/*****************************************************************************/
/* Values for the error_direction                                            */
/*****************************************************************************/
#define CM_RECEIVE_ERROR  (CM_ERROR_DIRECTION) 0
#define CM_SEND_ERROR     (CM_ERROR_DIRECTION) 1


/*****************************************************************************/
/* Values for fill type                                                      */
/*****************************************************************************/
#define CM_FILL_LL      (CM_FILL) 0
#define CM_FILL_BUFFER  (CM_FILL) 1


/*****************************************************************************/
/* Values for prepare_to_receive_type                                        */
/*****************************************************************************/
#define CM_PREP_TO_RECEIVE_SYNC_LEVEL  (CM_PREPARE_TO_RECEIVE_TYPE) 0
#define CM_PREP_TO_RECEIVE_FLUSH       (CM_PREPARE_TO_RECEIVE_TYPE) 1
#define CM_PREP_TO_RECEIVE_CONFIRM     (CM_PREPARE_TO_RECEIVE_TYPE) 2


/*****************************************************************************/
/* Values for the processing_mode                                            */
/*****************************************************************************/
#define CM_BLOCKING     0
#define CM_NON_BLOCKING 1


/*****************************************************************************/
/* Values for the receive_type                                               */
/*****************************************************************************/
#define CM_RECEIVE_AND_WAIT   (CM_RECEIVE_TYPE) 0
#define CM_RECEIVE_IMMEDIATE  (CM_RECEIVE_TYPE) 1


/*****************************************************************************/
/* Values for request_to_send_received                                       */
/*****************************************************************************/
#define CM_REQ_TO_SEND_NOT_RECEIVED  (CM_REQUEST_TO_SEND_RECEIVED) 0
#define CM_REQ_TO_SEND_RECEIVED      (CM_REQUEST_TO_SEND_RECEIVED) 1

/*****************************************************************************/
/* Values for signal_behavior_type                                           */
/*****************************************************************************/
#define XC_SIGNAL_BEHAVIOR_NO_RETRY       (XC_SIGNAL_BEHAVIOR_TYPE) 0
#define XC_SIGNAL_BEHAVIOR_INFINITE_RETRY (XC_SIGNAL_BEHAVIOR_TYPE) 1

/*****************************************************************************/
/* Values for return_code                                                    */
/*****************************************************************************/
#define CM_OK                            (CM_RETURN_CODE) 0
#define CM_ALLOCATE_FAILURE_NO_RETRY     (CM_RETURN_CODE) 1
#define CM_ALLOCATE_FAILURE_RETRY        (CM_RETURN_CODE) 2
#define CM_CONVERSATION_TYPE_MISMATCH    (CM_RETURN_CODE) 3
#define CM_PIP_NOT_SPECIFIED_CORRECTLY   (CM_RETURN_CODE) 5
#define CM_SECURITY_NOT_VALID            (CM_RETURN_CODE) 6
#define CM_SYNC_LVL_NOT_SUPPORTED_LU     (CM_RETURN_CODE) 7
#define CM_SYNC_LEVEL_NOT_SUPPORTED_LU   (CM_RETURN_CODE) 7
#define CM_SYNC_LVL_NOT_SUPPORTED_PGM    (CM_RETURN_CODE) 8
#define CM_SYNC_LEVEL_NOT_SUPPORTED_PGM  (CM_RETURN_CODE) 8
#define CM_TPN_NOT_RECOGNIZED            (CM_RETURN_CODE) 9
#define CM_TPN_NOT_RECOGNISED            (CM_RETURN_CODE) 9
#define CM_TP_NOT_AVAILABLE_NO_RETRY     (CM_RETURN_CODE) 10
#define CM_TP_NOT_AVAILABLE_RETRY        (CM_RETURN_CODE) 11
#define CM_DEALLOCATED_ABEND             (CM_RETURN_CODE) 17
#define CM_DEALLOCATED_NORMAL            (CM_RETURN_CODE) 18
#define CM_PARAMETER_ERROR               (CM_RETURN_CODE) 19
#define CM_PRODUCT_SPECIFIC_ERROR        (CM_RETURN_CODE) 20
#define CM_PROGRAM_ERROR_NO_TRUNC        (CM_RETURN_CODE) 21
#define CM_PROGRAM_ERROR_PURGING         (CM_RETURN_CODE) 22
#define CM_PROGRAM_ERROR_TRUNC           (CM_RETURN_CODE) 23
#define CM_PROGRAM_PARAMETER_CHECK       (CM_RETURN_CODE) 24
#define CM_PROGRAM_STATE_CHECK           (CM_RETURN_CODE) 25
#define CM_RESOURCE_FAILURE_NO_RETRY     (CM_RETURN_CODE) 26
#define CM_RESOURCE_FAILURE_RETRY        (CM_RETURN_CODE) 27
#define CM_UNSUCCESSFUL                  (CM_RETURN_CODE) 28
#define CM_DEALLOCATED_ABEND_SVC         (CM_RETURN_CODE) 30
#define CM_DEALLOCATED_ABEND_TIMER       (CM_RETURN_CODE) 31
#define CM_SVC_ERROR_NO_TRUNC            (CM_RETURN_CODE) 32
#define CM_SVC_ERROR_PURGING             (CM_RETURN_CODE) 33
#define CM_SVC_ERROR_TRUNC               (CM_RETURN_CODE) 34
#define CM_OPERATION_INCOMPLETE          (CM_RETURN_CODE) 35
#define CM_SYSTEM_EVENT                  (CM_RETURN_CODE) 36
#define CM_OPERATION_NOT_ACCEPTED        (CM_RETURN_CODE) 37
#define CM_CONVERSATION_ENDING           (CM_RETURN_CODE) 38
#define CM_SEND_RCV_MODE_NOT_SUPPORTED   (CM_RETURN_CODE) 39
#define CM_BUFFER_TOO_SMALL              (CM_RETURN_CODE) 40
#define CM_EXP_DATA_NOT_SUPPORTED        (CM_RETURN_CODE) 41
#define CM_DEALLOC_CONFIRM_REJECT        (CM_RETURN_CODE) 42
#define CM_ALLOCATION_ERROR              (CM_RETURN_CODE) 43
#define CM_RETRY_LIMIT_EXCEEDED          (CM_RETURN_CODE) 44
#define CM_NO_SECONDARY_INFORMATION      (CM_RETURN_CODE) 45
#define CM_SECURITY_NOT_SUPPORTED        (CM_RETURN_CODE) 46
#define CM_SECURITY_MUTUAL_FAILED        (CM_RETURN_CODE) 47
#define CM_CALL_NOT_SUPPORTED            (CM_RETURN_CODE) 48
#define CM_PARM_VALUE_NOT_SUPPORTED      (CM_RETURN_CODE) 49
#define CM_TAKE_BACKOUT                  (CM_RETURN_CODE) 100
#define CM_DEALLOCATED_ABEND_BO          (CM_RETURN_CODE) 130
#define CM_DEALLOCATED_ABEND_SVC_BO      (CM_RETURN_CODE) 131
#define CM_DEALLOCATED_ABEND_TIMER_BO    (CM_RETURN_CODE) 132
#define CM_RESOURCE_FAIL_NO_RETRY_BO     (CM_RETURN_CODE) 133
#define CM_RESOURCE_FAILURE_RETRY_BO     (CM_RETURN_CODE) 134
#define CM_DEALLOCATED_NORMAL_BO         (CM_RETURN_CODE) 135
#define CM_CONV_DEALLOC_AFTER_SYNCPT     (CM_RETURN_CODE) 136
#define CM_INCLUDE_PARTNER_REJECT_BO     (CM_RETURN_CODE) 137


/*****************************************************************************/
/* Values for return_control                                                 */
/*****************************************************************************/
#define CM_WHEN_SESSION_ALLOCATED  (CM_RETURN_CONTROL) 0
#define CM_IMMEDIATE               (CM_RETURN_CONTROL) 1


/*****************************************************************************/
/* Values for the send_type                                                  */
/*****************************************************************************/
#define CM_BUFFER_DATA               (CM_SEND_TYPE) 0
#define CM_SEND_AND_FLUSH            (CM_SEND_TYPE) 1
#define CM_SEND_AND_CONFIRM          (CM_SEND_TYPE) 2
#define CM_SEND_AND_PREP_TO_RECEIVE  (CM_SEND_TYPE) 3
#define CM_SEND_AND_DEALLOCATE       (CM_SEND_TYPE) 4


/*****************************************************************************/
/* Values for status_received                                                */
/*****************************************************************************/
#define CM_NO_STATUS_RECEIVED            (CM_STATUS_RECEIVED) 0
#define CM_SEND_RECEIVED                 (CM_STATUS_RECEIVED) 1
#define CM_CONFIRM_RECEIVED              (CM_STATUS_RECEIVED) 2
#define CM_CONFIRM_SEND_RECEIVED         (CM_STATUS_RECEIVED) 3
#define CM_CONFIRM_DEALLOC_RECEIVED      (CM_STATUS_RECEIVED) 4
#define CM_TAKE_COMMIT                   (CM_STATUS_RECEIVED) 5
#define CM_TAKE_COMMIT_SEND              (CM_STATUS_RECEIVED) 6
#define CM_TAKE_COMMIT_DEALLOCATE        (CM_STATUS_RECEIVED) 7
#define CM_TAKE_COMMIT_DATA_OK           (CM_STATUS_RECEIVED) 8
#define CM_TAKE_COMMIT_SEND_DATA_OK      (CM_STATUS_RECEIVED) 9
#define CM_TAKE_COMMIT_DEALLOC_DATA_OK   (CM_STATUS_RECEIVED) 10
#define CM_PREPARE_OK                    (CM_STATUS_RECEIVED) 11
#define CM_JOINT_TRANSACTION             (CM_STATUS_RECEIVED) 12


/*****************************************************************************/
/* Values for the sync_level                                                 */
/*****************************************************************************/
#define CM_NONE                     (CM_SYNC_LEVEL) 0
#define CM_CONFIRM                  (CM_SYNC_LEVEL) 1
#define CM_SYNC_POINT               (CM_SYNC_LEVEL) 2
#define CM_SYNC_POINT_NO_CONFIRM    (CM_SYNC_LEVEL) 3


/*****************************************************************************/
/* Values for end type (DCL addition)                                        */
/*****************************************************************************/
#define CM_HARD    (CM_INT32) 0
#define CM_SOFT    (CM_INT32) 1


#if defined (__STDC__) || defined (__cplusplus)
/*****************************************************************************/
/* Function prototypes for CPIC call routines                                */
/*****************************************************************************/
#define CM_ENTRY   extern void

CM_ENTRY cmaccp(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmacci(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmallc(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmcanc(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmcfm(unsigned char               CM_PTR,
               CM_REQUEST_TO_SEND_RECEIVED CM_PTR,
               CM_RETURN_CODE              CM_PTR);

CM_ENTRY cmcfmd(unsigned char   CM_PTR,
                CM_RETURN_CODE  CM_PTR);

CM_ENTRY cmdeal(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmwait(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmchck(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmectx(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmsctx(unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmecs(unsigned char         CM_PTR,
               CM_CONVERSATION_STATE CM_PTR,
               CM_RETURN_CODE        CM_PTR);

CM_ENTRY cmect(unsigned char         CM_PTR,
               CM_CONVERSATION_TYPE  CM_PTR,
               CM_RETURN_CODE        CM_PTR);

CM_ENTRY cmemn(unsigned char  CM_PTR,
               unsigned char  CM_PTR,
               CM_INT32       CM_PTR,
               CM_RETURN_CODE CM_PTR);

CM_ENTRY cmepln(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmelln(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmesl(unsigned char  CM_PTR,
               CM_SYNC_LEVEL  CM_PTR,
               CM_RETURN_CODE CM_PTR);

CM_ENTRY cmflus(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cminit(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cminic(unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmembs(CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmptr(unsigned char  CM_PTR,
               CM_RETURN_CODE CM_PTR);

CM_ENTRY cmrcv(unsigned char               CM_PTR,
               unsigned char               CM_PTR,
               CM_INT32                    CM_PTR,
               CM_DATA_RECEIVED_TYPE       CM_PTR,
               CM_INT32                    CM_PTR,
               CM_STATUS_RECEIVED          CM_PTR,
               CM_REQUEST_TO_SEND_RECEIVED CM_PTR,
               CM_RETURN_CODE              CM_PTR);

CM_ENTRY cmrts(unsigned char  CM_PTR,
               CM_RETURN_CODE CM_PTR);

CM_ENTRY cmsend(unsigned char               CM_PTR,
                unsigned char               CM_PTR,
                CM_INT32                    CM_PTR,
                CM_REQUEST_TO_SEND_RECEIVED CM_PTR,
                CM_RETURN_CODE              CM_PTR);

CM_ENTRY cmserr(unsigned char               CM_PTR,
                CM_REQUEST_TO_SEND_RECEIVED CM_PTR,
                CM_RETURN_CODE              CM_PTR);

CM_ENTRY cmsct(unsigned char         CM_PTR,
               CM_CONVERSATION_TYPE  CM_PTR,
               CM_RETURN_CODE        CM_PTR);

CM_ENTRY cmsdt(unsigned char       CM_PTR,
               CM_DEALLOCATE_TYPE  CM_PTR,
               CM_RETURN_CODE      CM_PTR);

CM_ENTRY cmsed(unsigned char       CM_PTR,
               CM_ERROR_DIRECTION  CM_PTR,
               CM_RETURN_CODE      CM_PTR);

CM_ENTRY cmsf(unsigned char  CM_PTR,
              CM_FILL        CM_PTR,
              CM_RETURN_CODE CM_PTR);

CM_ENTRY cmsld(unsigned char  CM_PTR,
               unsigned char  CM_PTR,
               CM_INT32       CM_PTR,
               CM_RETURN_CODE CM_PTR);

CM_ENTRY cmslln(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmsmn(unsigned char  CM_PTR,
               unsigned char  CM_PTR,
               CM_INT32       CM_PTR,
               CM_RETURN_CODE CM_PTR);

CM_ENTRY cmspln(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmsptr(unsigned char              CM_PTR,
                CM_PREPARE_TO_RECEIVE_TYPE CM_PTR,
                CM_RETURN_CODE             CM_PTR);

CM_ENTRY cmsrt(unsigned char   CM_PTR,
               CM_RECEIVE_TYPE CM_PTR,
               CM_RETURN_CODE  CM_PTR);

CM_ENTRY cmsrc(unsigned char     CM_PTR,
               CM_RETURN_CONTROL CM_PTR,
               CM_RETURN_CODE    CM_PTR);

CM_ENTRY cmsst(unsigned char  CM_PTR,
               CM_SEND_TYPE   CM_PTR,
               CM_RETURN_CODE CM_PTR);

CM_ENTRY cmssl(unsigned char  CM_PTR,
               CM_SYNC_LEVEL  CM_PTR,
               CM_RETURN_CODE CM_PTR);

CM_ENTRY cmstpn(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmtrts(unsigned char               CM_PTR,
                CM_REQUEST_TO_SEND_RECEIVED CM_PTR,
                CM_RETURN_CODE              CM_PTR);

CM_ENTRY cmspm(unsigned char   CM_PTR,
               CM_INT32        CM_PTR,
               CM_RETURN_CODE  CM_PTR);

CM_ENTRY cmcnvi(unsigned char   CM_PTR,
                CM_INT32        CM_PTR,
                CM_RETURN_CODE  CM_PTR);

CM_ENTRY cmcnvo(unsigned char   CM_PTR,
                CM_INT32        CM_PTR,
                CM_RETURN_CODE  CM_PTR);

CM_ENTRY cmsltp(unsigned char   CM_PTR,
                CM_INT32        CM_PTR,
                CM_RETURN_CODE  CM_PTR);

CM_ENTRY cmrltp(unsigned char   CM_PTR,
                CM_INT32        CM_PTR,
                CM_RETURN_CODE  CM_PTR);

CM_ENTRY cmetpn(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY xcmdsi(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY xcecst(unsigned char                 CM_PTR,
                XC_CONVERSATION_SECURITY_TYPE CM_PTR,
                CM_RETURN_CODE                CM_PTR);

CM_ENTRY xcecsu(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmecsu(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmesui(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY xcmesi(CM_INT32       CM_PTR,
                unsigned char  CM_PTR,
                SIDE_INFO      CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY xcscsp(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmscsp(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY xcscst(unsigned char                 CM_PTR,
                XC_CONVERSATION_SECURITY_TYPE CM_PTR,
                CM_RETURN_CODE                CM_PTR);

CM_ENTRY cmscst(unsigned char                 CM_PTR,
                XC_CONVERSATION_SECURITY_TYPE CM_PTR,
                CM_RETURN_CODE                CM_PTR);

CM_ENTRY xcscsu(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmscsu(unsigned char  CM_PTR,
                unsigned char  CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY xcmssi(unsigned char  CM_PTR,
                SIDE_INFO      CM_PTR,
                CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);

CM_ENTRY cmterm(CM_INT32       CM_PTR,
                CM_RETURN_CODE CM_PTR);
#else

#define CM_ENTRY   extern void

CM_ENTRY cmaccp();

CM_ENTRY cmacci();

CM_ENTRY cmallc();

CM_ENTRY cmcanc();

CM_ENTRY cmcfm();

CM_ENTRY cmcfmd();

CM_ENTRY cmdeal();

CM_ENTRY cmwait();

CM_ENTRY cmchck();

CM_ENTRY cmectx();

CM_ENTRY cmsctx();

CM_ENTRY cmecs();

CM_ENTRY cmect();

CM_ENTRY cmemn();

CM_ENTRY cmepln();

CM_ENTRY cmelln();

CM_ENTRY cmesl();

CM_ENTRY cmflus();

CM_ENTRY cminit();

CM_ENTRY cminic();

CM_ENTRY cmembs();

CM_ENTRY cmptr();

CM_ENTRY cmrcv();

CM_ENTRY cmrts();

CM_ENTRY cmsend();

CM_ENTRY cmserr();

CM_ENTRY cmsct();

CM_ENTRY cmsdt();

CM_ENTRY cmsed();

CM_ENTRY cmsf();

CM_ENTRY cmsld();

CM_ENTRY cmslln();

CM_ENTRY cmsmn();

CM_ENTRY cmspln();

CM_ENTRY cmsptr();

CM_ENTRY cmsrt();

CM_ENTRY cmsrc();

CM_ENTRY cmsst();

CM_ENTRY cmssl();

CM_ENTRY cmstpn();

CM_ENTRY cmtrts();

CM_ENTRY cmspm();

CM_ENTRY cmcnvi();

CM_ENTRY cmcnvo();

CM_ENTRY cmsltp();

CM_ENTRY cmrltp();

CM_ENTRY cmetpn();

CM_ENTRY xcmdsi();

CM_ENTRY xcecst();

CM_ENTRY xcecsu();

CM_ENTRY cmecsu();

CM_ENTRY cmesui();

CM_ENTRY xcmesi();

CM_ENTRY xcscsp();

CM_ENTRY cmscsp();

CM_ENTRY xcscst();

CM_ENTRY cmscst();

CM_ENTRY xcscsu();

CM_ENTRY cmscsu();

CM_ENTRY xcmssi();

CM_ENTRY cmterm();

#endif

#ifdef __cplusplus
}
#endif
#endif
