/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.IPAddressName;
import java.io.IOException;

public final class URIName
implements GeneralNameInterface {
    private String name;
    private String scheme;
    private String host;
    private String remainder;
    private IPAddressName hostIP;
    private DNSName hostDNS;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.URIName";

    public URIName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "URIName", derValue);
        }
        this.name = derValue.getIA5String();
        if (debug != null) {
            debug.exit(16384L, className, "URIName");
        }
    }

    public URIName(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "URIName", string);
            debug.exit(16384L, className, "URIName");
        }
        if (string == null || string.length() == 0) {
            throw new IOException("URI name must not be null");
        }
        this.name = string;
        this.parseName();
    }

    private void parseName() throws IOException {
        int n;
        int n2;
        int n3 = this.name.indexOf(58);
        if (n3 < 0) {
            throw new IOException("Name " + this.name + " does not include a <scheme>");
        }
        int n4 = this.name.indexOf("//", n3);
        if (n4 != n3 + 1) {
            throw new IOException("name does not include scheme-specific portion starting with host");
        }
        int n5 = n4 + 2;
        if (n5 == this.name.length()) {
            throw new IOException("Name " + this.name + " doesn't include a <host>");
        }
        int n6 = this.name.indexOf(93, n5);
        if (n6 >= 0) {
            n5 = n6;
        }
        if ((n2 = this.name.indexOf(47, n5)) < 0) {
            n2 = this.name.length();
        }
        if ((n = this.name.indexOf(64, n4 + 2) + 1) <= 0 || n >= n2) {
            n = n4 + 2;
        }
        int n7 = -1;
        if (this.name.charAt(n) == '[') {
            n7 = this.name.indexOf(93, n);
            if (n7 < 0) {
                throw new IOException("Invalid IPv6 address as host: missing ]");
            }
            if (n7 < this.name.length() - 1) {
                char c = this.name.charAt(n7 + 1);
                if (c != ':' && c != '/') {
                    throw new IOException("Invalid host[:port][/] boundary");
                }
                ++n7;
            } else {
                n7 = n2;
            }
        } else {
            n7 = this.name.indexOf(58, n);
            if (n7 < 0 || n7 >= n2) {
                n7 = n2;
            }
        }
        this.scheme = this.name.substring(0, n3);
        this.host = this.name.substring(n, n7);
        if (this.host.length() != 0) {
            if (this.host.charAt(0) == '[') {
                String string = this.host.substring(1, this.host.length() - 1);
                try {
                    this.hostIP = new IPAddressName(string);
                }
                catch (IOException iOException) {
                    throw new IOException("Host portion is not a valid IPv6 address: " + iOException.getMessage());
                }
            }
            try {
                this.hostDNS = this.host.charAt(0) == '.' ? new DNSName(this.host.substring(1)) : new DNSName(this.host);
            }
            catch (Exception exception) {
                try {
                    this.hostIP = new IPAddressName(this.host);
                }
                catch (Exception exception2) {
                    throw new IOException("Host portion is not a valid DNS name, IPv4 address, or IPv6 address");
                }
            }
        }
        this.remainder = this.name.substring(n3, n);
        if (n7 < this.name.length()) {
            this.remainder = this.remainder + this.name.substring(n7);
        }
    }

    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 6);
        }
        return 6;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        derOutputStream.putIA5String(this.name);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", "URIName: " + this.name);
        }
        return "URIName: " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public Object getHostObject() {
        if (this.hostIP != null) {
            return this.hostIP;
        }
        return this.hostDNS;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        if (generalNameInterface == null) {
            n = -1;
        } else if (generalNameInterface.getType() != 6) {
            n = -1;
        } else {
            String string = ((URIName)generalNameInterface).getScheme();
            String string2 = ((URIName)generalNameInterface).getHost();
            if (!this.scheme.equalsIgnoreCase(string)) {
                n = 3;
            } else if (string2.equals(this.host)) {
                n = 0;
            } else {
                if (((URIName)generalNameInterface).getHostObject() instanceof IPAddressName && this.hostIP != null) {
                    return this.hostIP.constrains((IPAddressName)((URIName)generalNameInterface).getHostObject());
                }
                if (string2.charAt(0) == '.' || this.host.charAt(0) == '.') {
                    try {
                        DNSName dNSName = this.host.charAt(0) == '.' ? new DNSName(this.host.substring(1)) : new DNSName(this.host);
                        DNSName dNSName2 = string2.charAt(0) == '.' ? new DNSName(string2.substring(1)) : new DNSName(string2);
                        n = dNSName.constrains(dNSName2);
                    }
                    catch (IOException iOException) {
                        n = 3;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        n = 3;
                    }
                } else {
                    n = 3;
                }
            }
        }
        return n;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        DNSName dNSName = null;
        try {
            dNSName = new DNSName(this.host);
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException(iOException.getMessage());
        }
        int n = dNSName.subtreeDepth();
        return n;
    }
}

