/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertificateFactoryImpl;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.util.DerOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CertPathImpl
extends CertPath {
    private LinkedList certPathList = new LinkedList();
    private CertificateFactoryImpl cf = new CertificateFactoryImpl();
    static final long serialVersionUID = -1365003539579449970L;

    CertPathImpl(String string, List list) {
        super(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            this.certPathList.add(x509Certificate);
        }
    }

    CertPathImpl(String string, List list, boolean bl) {
        super(string);
        if (bl) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                this.certPathList.add(x509Certificate);
            }
        } else {
            for (int i = list.size(); i > 0; --i) {
                X509Certificate x509Certificate = (X509Certificate)list.get(i);
                this.certPathList.add(x509Certificate);
            }
        }
    }

    public Iterator getEncodings() {
        Iterator iterator = this.cf.engineGetCertPathEncodings();
        return iterator;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.pkiPathEncoded();
    }

    private byte[] pkcs7Encoded() throws CertificateEncodingException {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Certificate[] certificateArray = new Certificate[this.certPathList.size()];
        CRL[] cRLArray = null;
        ContentInfo contentInfo = null;
        SignedData signedData = null;
        int n = 0;
        Iterator iterator = this.certPathList.iterator();
        while (iterator.hasNext()) {
            certificateArray[n] = (Certificate)iterator.next();
            ++n;
        }
        try {
            signedData = new SignedData(certificateArray, cRLArray);
            contentInfo = new ContentInfo((Content)signedData);
            contentInfo.encode((OutputStream)byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("Exception caught while encoding certificates in PKCS7 format: " + iOException);
        }
        return byArray;
    }

    public byte[] getEncoded(String string) throws CertificateEncodingException {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object var4_4 = null;
        Iterator iterator = this.certPathList.iterator();
        if (string.equals("PKCS7")) {
            byArray = this.pkcs7Encoded();
            return byArray;
        }
        if (string.equals("PkiPath")) {
            byArray = this.pkiPathEncoded();
            return byArray;
        }
        return byArray;
    }

    public List getCertificates() {
        return new LinkedList(this.certPathList);
    }

    private byte[] pkiPathEncoded() throws CertificateEncodingException {
        LinkedList linkedList = new LinkedList(this.certPathList);
        try {
            int n = linkedList.size();
            DerOutputStream derOutputStream = new DerOutputStream();
            for (int i = n - 1; i >= 0; --i) {
                X509Certificate x509Certificate = (X509Certificate)linkedList.get(i);
                byte[] byArray = x509Certificate.getEncoded();
                derOutputStream.write(byArray);
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            return derOutputStream2.toByteArray();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("Exception caught while encoding certificates in PkiPath format: " + iOException);
        }
    }
}

