/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.IOExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;

abstract class EncodingDeclReader {
    protected static final int CODEPOINT_ILLEGAL = 0;
    protected static final int CODEPOINT_WHITESPACE = 1;
    protected static final int CODEPOINT_EQUALSIGN = 2;
    protected static final int CODEPOINT_SINGLEQUOTE = 3;
    protected static final int CODEPOINT_DOUBLEQUOTE = 4;
    protected static final int CODEPOINT_LETTER = 5;
    protected static final int CODEPOINT_DIGIT = 6;
    protected static final int CODEPOINT_HYPHEN = 7;
    protected static final int CODEPOINT_UNDERSCORE = 8;
    protected static final int CODEPOINT_PERIOD = 9;
    protected static final int CODEPOINT_LESSTHAN = 10;
    protected static final int CODEPOINT_GREATERTHAN = 11;
    protected static final int CODEPOINT_QUESTIONMARK = 12;
    protected static final int LITERAL_STARTPIXML = 0;
    protected static final int LITERAL_VERSION = 1;
    protected static final int LITERAL_VERSION10 = 2;
    protected static final int LITERAL_ENCODING = 3;
    protected static final int LITERAL_STANDALONE = 4;
    protected static final int LITERAL_YES = 5;
    protected static final int LITERAL_NO = 6;
    protected static final int LITERAL_ENDPI = 7;
    protected InputStream fStream;
    protected String fEncodingName;
    protected char[] fEncodingNameBuffer;
    private static final int STATE_START = 0;
    private static final int STATE_VERSION = 1;
    private static final int STATE_ENCODING = 2;
    private static final int STATE_STANDALONE = 3;
    private static final int STATE_FINISHED = 4;

    EncodingDeclReader() {
    }

    protected abstract boolean lookingAtCodePoint(int var1) throws IOException;

    protected abstract boolean skipCodePoint(int var1) throws IOException;

    protected abstract boolean skipLiteral(int var1) throws IOException;

    protected abstract boolean skipSpaces() throws IOException;

    protected abstract boolean scanEncodingName(int var1) throws IOException;

    public String getEncoding(InputStream inputStream, boolean bl) {
        this.fStream = inputStream;
        this.fEncodingName = null;
        try {
            if (!this.readEncodingDecl(bl)) {
                return null;
            }
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
        return this.fEncodingName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readEncodingDecl(boolean bl) throws IOException {
        int n = 0;
        if (!this.skipLiteral(0)) {
            return true;
        }
        this.skipSpaces();
        do {
            if (!bl) {
                if (n == 0 && this.skipLiteral(1)) {
                    n = 1;
                } else {
                    if (!this.skipLiteral(3)) return false;
                    n = 2;
                }
            } else if (n == 0) {
                if (!this.skipLiteral(1)) return false;
                n = 1;
            } else if (n != 1 || !this.skipLiteral(3)) {
                if (!this.skipLiteral(4)) return this.skipLiteral(7);
                n = 3;
            } else {
                n = 2;
            }
            this.skipSpaces();
            if (!this.skipCodePoint(2)) {
                return false;
            }
            this.skipSpaces();
            boolean bl2 = this.skipCodePoint(3);
            if (!bl2 && !this.skipCodePoint(4)) {
                return false;
            }
            int n2 = bl2 ? 3 : 4;
            switch (n) {
                case 1: {
                    if (!this.skipLiteral(2) || !this.skipCodePoint(n2)) {
                        return false;
                    }
                    if (this.skipSpaces()) break;
                    if (!bl) {
                        return false;
                    }
                    n = 4;
                    break;
                }
                case 2: {
                    if (!this.scanEncodingName(n2)) {
                        return false;
                    }
                    this.skipCodePoint(n2);
                    if (!this.skipSpaces()) {
                        n = 4;
                        break;
                    }
                    if (bl) break;
                    n = 4;
                    break;
                }
                case 3: {
                    if (!this.skipLiteral(5) && !this.skipLiteral(6) || !this.skipCodePoint(n2)) {
                        return false;
                    }
                    this.skipSpaces();
                    n = 4;
                }
            }
        } while (n != 4);
        return this.skipLiteral(7);
    }
}

