/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11MechanismInfo {
    public static final int HW = 1;
    public static final int ENCRYPT = 256;
    public static final int DECRYPT = 512;
    public static final int DIGEST = 1024;
    public static final int SIGN = 2048;
    public static final int SIGN_RECOVER = 4096;
    public static final int VERIFY = 8192;
    public static final int VERIFY_RECOVER = 16384;
    public static final int GENERATE = 32768;
    public static final int GENERATE_KEY_PAIR = 65536;
    public static final int WRAP = 131072;
    public static final int UNWRAP = 262144;
    public static final int DERIVE = 524288;
    public static final int EXTENSION = Integer.MIN_VALUE;
    static final int[] flagList = new int[]{1, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, Integer.MIN_VALUE};
    static final String[] flagNames = new String[]{PKCS11MechanismInfo.a("K8"), PKCS11MechanismInfo.a("F!@K@S;"), PKCS11MechanismInfo.a("G*@K@S;"), PKCS11MechanismInfo.a("G&D\\JW"), PKCS11MechanismInfo.a("P&DW"), PKCS11MechanismInfo.a("P&DWFQ*@VOF="), PKCS11MechanismInfo.a("U*QP_Z"), PKCS11MechanismInfo.a("U*QP_Z0Q\\ZL9FK"), PKCS11MechanismInfo.a("D*M\\KB;F"), PKCS11MechanismInfo.a("D*M\\KB;FFRF6\\IXJ="), PKCS11MechanismInfo.a("T=BI"), PKCS11MechanismInfo.a("V!TKXS"), PKCS11MechanismInfo.a("G*QPOF"), PKCS11MechanismInfo.a("F7W\\WP&LW")};
    private int minKeySize;
    private int maxKeySize;
    private int flags;

    public PKCS11MechanismInfo(int n2, int n3, int n4) {
        this.minKeySize = n2;
        this.maxKeySize = n3;
        this.flags = n4;
    }

    public int minKeySize() {
        return this.minKeySize;
    }

    public int maxKeySize() {
        return this.maxKeySize;
    }

    public int flags() {
        return this.flags;
    }

    public String toString() {
        return PKCS11MechanismInfo.a("n\u0006mR|z<jc|>") + this.minKeySize + PKCS11MechanismInfo.a("/OnxaH\nzJpy\n>") + this.maxKeySize + PKCS11MechanismInfo.a("/Oeuxd\u001c>") + this.flagsToString("|");
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 3;
                        break;
                    }
                    case 1: {
                        n5 = 111;
                        break;
                    }
                    case 2: {
                        n5 = 3;
                        break;
                    }
                    case 3: {
                        n5 = 25;
                        break;
                    }
                    default: {
                        n5 = 25;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

