/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.Util;
import java.math.BigInteger;

public final class Message {
    private static int ptrSize;
    private int type;
    private String message;
    private String component;
    private boolean zero = false;
    private String symbol;

    public Message(int n, String string, String string2, String string3) {
        this.type = n;
        this.message = string;
        this.component = string2;
        this.symbol = string3;
    }

    protected StringBuffer processPercents(String string, byte[] byArray, int n) {
        FormatSpec formatSpec = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf("%");
        this.zero = false;
        while (n2 != -1 && n < byArray.length) {
            char c;
            String string2;
            int n3 = 4;
            boolean bl = n2 > 1 ? "0x".equalsIgnoreCase(string.substring(n2 - 2, n2)) : false;
            stringBuffer.append(string.substring(0, n2));
            string = string.substring(n2 + 1, string.length());
            if (string.charAt(0) == '-') {
                formatSpec = new FormatSpec(true);
                string = string.substring(1, string.length());
            }
            if (string.charAt(0) == '0') {
                this.zero = true;
                string = string.substring(1, string.length());
            }
            if (Character.isDigit(string.charAt(0))) {
                if (formatSpec == null) {
                    formatSpec = new FormatSpec();
                }
                string2 = this.readDigits(string);
                formatSpec.width = Integer.valueOf(string2);
                string = string.substring(string2.length(), string.length());
            }
            if (string.charAt(0) == '.') {
                if (formatSpec == null) {
                    formatSpec = new FormatSpec();
                }
                string = string.substring(1, string.length());
                string2 = this.readDigits(string);
                formatSpec.precision = Integer.valueOf(string2);
                string = string.substring(string2.length(), string.length());
            }
            if ((c = string.charAt(0)) == 'l') {
                if (string.charAt(1) == 'l') {
                    n3 = 8;
                    string = string.substring(2, string.length());
                } else {
                    string = string.substring(1, string.length());
                }
            } else if (c == 'I' && string.charAt(1) == '6' && string.charAt(2) == '4') {
                n3 = 8;
                string = string.substring(3, string.length());
            } else if (c == 'h') {
                n3 = 2;
                string = string.substring(1, string.length());
            }
            c = string.charAt(0);
            switch (c) {
                case 'p': {
                    long l = ptrSize == 4 ? Util.constructUnsignedInt(byArray, n) : Util.constructUnsignedLong(byArray, n).longValue();
                    n += ptrSize;
                    if (!bl) {
                        stringBuffer.append("0x");
                    }
                    stringBuffer.append(this.format(l, formatSpec, 16));
                    string = string.substring(1, string.length());
                    break;
                }
                case 's': {
                    String string3 = Util.constructString(byArray, n);
                    n += string3.length() + 1;
                    stringBuffer.append(this.format(string3, formatSpec));
                    string = string.substring(1, string.length());
                    break;
                }
                case 'd': 
                case 'i': {
                    long l = n3 == 4 ? Util.constructUnsignedInt(byArray, n) : Util.constructUnsignedLong(byArray, n).longValue();
                    n += n3;
                    stringBuffer.append(this.format(l, formatSpec));
                    string = string.substring(1, string.length());
                    break;
                }
                case 'u': {
                    long l;
                    if (n3 == 4) {
                        l = Util.constructUnsignedInt(byArray, n);
                        l &= 0xFFFFFFFFL;
                    } else {
                        l = Util.constructUnsignedLong(byArray, n).longValue();
                    }
                    n += n3;
                    stringBuffer.append(this.format(l, formatSpec));
                    string = string.substring(1, string.length());
                    break;
                }
                case 'f': {
                    int n4 = (int)Util.constructUnsignedInt(byArray, n);
                    n += 4;
                    stringBuffer.append(this.format(Float.intBitsToFloat(n4), formatSpec));
                    string = string.substring(1, string.length());
                    break;
                }
                case 'g': {
                    long l = Util.constructUnsignedLong(byArray, n).longValue();
                    n += 8;
                    stringBuffer.append(this.format(Double.longBitsToDouble(l), formatSpec));
                    string = string.substring(1, string.length());
                    break;
                }
                case 'X': 
                case 'x': {
                    long l;
                    if (n3 == 4) {
                        l = Util.constructUnsignedInt(byArray, n);
                        l &= 0xFFFFFFFFL;
                    } else {
                        l = Util.constructUnsignedLong(byArray, n).longValue();
                    }
                    n += n3;
                    if (!bl) {
                        stringBuffer.append("0x");
                    }
                    stringBuffer.append(this.format(l, formatSpec, 16));
                    string = string.substring(1, string.length());
                    break;
                }
                case 'c': {
                    String string3 = Util.constructString(byArray, n, 1);
                    ++n;
                    stringBuffer.append(this.format(string3, formatSpec));
                    string = string.substring(1, string.length());
                    break;
                }
                case '%': {
                    stringBuffer.append("%");
                    string = string.substring(1, string.length());
                    break;
                }
                case ' ': 
                case '#': 
                case '+': {
                    TraceFormat.outStream.println("Used a printf flag not supported " + c);
                    string = string.substring(1, string.length());
                    break;
                }
                default: {
                    TraceFormat.outStream.println("error percent directive looked like => " + string);
                    string = string.substring(1, string.length());
                }
            }
            formatSpec = null;
            this.zero = false;
            n2 = string.indexOf("%");
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    protected StringBuffer skipPercents(String string, byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf("%");
        while (n2 != -1 && n < byArray.length) {
            char c;
            String string2;
            stringBuffer.append(string.substring(0, n2));
            string = string.substring(n2 + 1, string.length());
            if (string.charAt(0) == '-' || string.charAt(0) == '0') {
                string = string.substring(1, string.length());
            }
            if (Character.isDigit(string.charAt(0))) {
                string2 = this.readDigits(string);
                string = string.substring(string2.length(), string.length());
            }
            if (string.charAt(0) == '.') {
                string = string.substring(1, string.length());
                string2 = this.readDigits(string);
                string = string.substring(string2.length(), string.length());
            }
            if ((c = string.charAt(0)) == 'l') {
                string = string.substring(string.charAt(1) == 'l' ? 2 : 1, string.length());
            } else if (c == 'I' && string.charAt(1) == '6' && string.charAt(2) == '4') {
                string = string.substring(3, string.length());
            } else if (c == 'h') {
                string = string.substring(1, string.length());
            }
            c = string.charAt(0);
            switch (c) {
                case 'X': 
                case 'c': 
                case 'd': 
                case 'f': 
                case 'i': 
                case 'p': 
                case 's': 
                case 'u': 
                case 'x': {
                    string = string.substring(1, string.length());
                    stringBuffer.append("???");
                    break;
                }
                case '%': {
                    stringBuffer.append("%");
                    string = string.substring(1, string.length());
                    break;
                }
                case ' ': 
                case '#': 
                case '+': {
                    TraceFormat.outStream.println("Used a printf flag not supported " + c);
                    string = string.substring(1, string.length());
                    break;
                }
                default: {
                    TraceFormat.outStream.println("Error: percent directive looked like => " + string);
                    string = string.substring(1, string.length());
                }
            }
            n2 = string.indexOf("%");
        }
        stringBuffer.append(string);
        return stringBuffer;
    }

    protected static void setPointerSize() {
        ptrSize = Integer.valueOf(Util.getProperty("POINTER_SIZE"));
    }

    private String readDigits(String string) {
        char[] cArray = new char[10];
        int n = 0;
        while (Character.isDigit(string.charAt(n))) {
            if (n >= cArray.length) continue;
            cArray[n] = string.charAt(n);
            ++n;
        }
        return new String(cArray, 0, n);
    }

    private StringBuffer format(BigInteger bigInteger, FormatSpec formatSpec) {
        StringBuffer stringBuffer = new StringBuffer(bigInteger.toString());
        if (formatSpec != null) {
            if (formatSpec.precision != null) {
                Util.padBuffer(stringBuffer, formatSpec.precision, '0');
            }
            if (formatSpec.width != null) {
                Util.padBuffer(stringBuffer, formatSpec.width, ' ', formatSpec.leftJustified);
            }
        }
        return stringBuffer;
    }

    private StringBuffer format(long l, FormatSpec formatSpec) {
        return this.format(l, formatSpec, 10);
    }

    private StringBuffer format(long l, FormatSpec formatSpec, int n) {
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l, n));
        if (formatSpec != null) {
            if (formatSpec.precision != null) {
                Util.padBuffer(stringBuffer, formatSpec.precision, '0');
            }
            if (formatSpec.width != null) {
                Util.padBuffer(stringBuffer, formatSpec.width, this.zero && !formatSpec.leftJustified ? (char)'0' : ' ', formatSpec.leftJustified);
            }
        }
        return stringBuffer;
    }

    private StringBuffer format(float f, FormatSpec formatSpec) {
        StringBuffer stringBuffer = new StringBuffer(Float.toString(f));
        if (formatSpec != null && formatSpec.width != null) {
            Util.padBuffer(stringBuffer, formatSpec.width, ' ', formatSpec.leftJustified);
        }
        return stringBuffer;
    }

    private StringBuffer format(double d, FormatSpec formatSpec) {
        StringBuffer stringBuffer = new StringBuffer(Double.toString(d));
        if (formatSpec != null && formatSpec.width != null) {
            Util.padBuffer(stringBuffer, formatSpec.width, ' ', formatSpec.leftJustified);
        }
        return stringBuffer;
    }

    private StringBuffer format(String string, FormatSpec formatSpec) {
        StringBuffer stringBuffer = new StringBuffer();
        if (formatSpec != null) {
            int n;
            if (formatSpec.precision != null && (n = formatSpec.precision.intValue()) < string.length()) {
                string = string.substring(0, n);
            }
            stringBuffer.append(string);
            if (formatSpec.width != null) {
                Util.padBuffer(stringBuffer, formatSpec.width, ' ', formatSpec.leftJustified);
            }
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    protected String getMessage(byte[] byArray, int n, int n2) {
        String string;
        String string2 = string = TraceArgs.symbolic ? this.symbol + " " : "";
        if (n < n2) {
            if (this.component == "ApplicationTrace") {
                n += 4;
            }
            return string + this.processPercents(this.message, byArray, n).toString();
        }
        return string + this.skipPercents(this.message, byArray, n).toString();
    }

    protected String getComponent() {
        return this.component;
    }

    protected int getType() {
        return this.type;
    }

    class FormatSpec {
        protected Integer width;
        protected Integer precision;
        protected boolean leftJustified = false;

        public FormatSpec(boolean bl) {
            this.leftJustified = bl;
        }

        public FormatSpec() {
            this(false);
        }

        public String toString() {
            return "FormatSpec w: " + this.width + " p:" + this.precision + " just: " + this.leftJustified;
        }
    }
}

