/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.Surrogate;

class DBE_Encoder
extends IBMCharsetEncoder {
    private static final int SBCS = 1;
    private static final int DBCS = 2;
    private static final byte SO = 14;
    private static final byte SI = 15;
    private final int convertType;
    private int replaceLen;
    private int state;
    private final String ByteArray;
    private final String leftPair;
    private final String rightPair;
    private final String bytePair;
    private final int[] SurrogateArray;
    private final int numberOfSurrogates;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private static char[] map;

    DBE_Encoder(Charset charset, byte by, byte[] byArray, String string, String string2, String string3, String string4, int[] nArray, int n, char[] cArray) {
        super(charset, 2.0f, 4.0f);
        this.ByteArray = string;
        this.leftPair = string2;
        this.rightPair = string3;
        this.bytePair = string4;
        this.SurrogateArray = nArray;
        this.numberOfSurrogates = n;
        this.convertType = by;
        int n2 = this.state = by == 2 ? 2 : 1;
        if (byArray != null) {
            this.replaceWith(byArray);
        }
        map = cArray;
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray.length == 1) {
            return true;
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        if (n < 64 || n == 255) {
            return false;
        }
        if (n2 == 64 && n != 64) {
            return false;
        }
        return n2 >= 64 && n2 != 255;
    }

    public boolean canEncode(char c) {
        int n = 0xFFFF & map[c];
        if (n >= 65534) {
            return false;
        }
        switch (this.convertType) {
            default: {
                return true;
            }
            case 1: {
                return n < 256;
            }
            case 2: 
        }
        return n >= 256;
    }

    protected void implReset() {
        if (this.convertType == 0) {
            this.state = 1;
        }
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (this.state == 2 && this.convertType == 0) {
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)15);
            if (this.convertType == 0) {
                this.state = 1;
            }
        }
        return CoderResult.UNDERFLOW;
    }

    protected void implReplaceWith(byte[] byArray) {
        this.replaceLen = byArray.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoderResult setForReplacement(CoderResult coderResult, ByteBuffer byteBuffer) {
        CodingErrorAction codingErrorAction = coderResult.isMalformed() ? this.malformedInputAction() : this.unmappableCharacterAction();
        if (codingErrorAction != CodingErrorAction.REPLACE) return coderResult;
        if (this.replaceLen == 1 && this.state != 1) {
            if (!byteBuffer.hasRemaining()) return CoderResult.OVERFLOW;
            byteBuffer.put((byte)15);
            return coderResult;
        } else {
            if (this.replaceLen != 2 || this.state == 2) return coderResult;
            if (!byteBuffer.hasRemaining()) return CoderResult.OVERFLOW;
            byteBuffer.put((byte)14);
            this.state = 2;
        }
        return coderResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        int n5 = 0;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
            boolean bl;
            boolean bl2;
            block19: {
                int n6;
                int n7;
                int n8;
                block22: {
                    char c;
                    block20: {
                        block21: {
                            c = cArray[n];
                            int n9 = this.leftPair.indexOf(c);
                            bl2 = false;
                            bl = false;
                            if (n + 1 < n2 && n9 > -1) {
                                while (n9 > -1) {
                                    if (this.rightPair.charAt(n9) == cArray[n + 1]) {
                                        n5 = this.bytePair.charAt(n9);
                                        ++n;
                                        bl2 = true;
                                        n9 = -1;
                                        continue;
                                    }
                                    n9 = this.leftPair.indexOf(c, n9 + 1);
                                }
                            }
                            if (bl2) break block19;
                            if (!Surrogate.is(c)) break block20;
                            if (this.sgp.parse(c, cArray, n, n2) < 0) {
                                this.sgp.error();
                                break;
                            }
                            n8 = this.numberOfSurrogates;
                            n7 = -1;
                            boolean bl3 = false;
                            n6 = n8 / 2;
                            if (this.SurrogateArray[0] != this.sgp.character()) break block21;
                            n7 = 0;
                            n6 = 0;
                            break block22;
                        }
                        if (this.SurrogateArray[n8 - 1] != this.sgp.character()) break block22;
                        n7 = n8 - 1;
                        n6 = 0;
                        break block22;
                    }
                    n5 = 0xFFFF & map[c];
                    if (n5 >= 65534) {
                        coderResult = CoderResult.unmappableForLength(1);
                        break;
                    }
                    break block19;
                }
                while (n6 >= 1) {
                    if (this.SurrogateArray[n6] == this.sgp.character()) {
                        n7 = n6;
                        break;
                    }
                    if (this.SurrogateArray[n6] < this.sgp.character()) {
                        if ((n8 + n6) / 2 == n6) {
                            n6 = 0;
                            continue;
                        }
                        n6 = (n8 + n6) / 2;
                        continue;
                    }
                    if (this.SurrogateArray[n6] <= this.sgp.character()) continue;
                    n8 = n6;
                    n6 = n8 / 2;
                }
                if (n7 >= 0) {
                    n5 = this.ByteArray.charAt(n7);
                    ++n;
                    bl = true;
                } else {
                    this.sgp.unmappableResult();
                    break;
                }
            }
            if (this.state == 2 && n5 < 256) {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                this.state = 1;
                byArray[n3++] = 15;
            } else if (this.state == 1 && n5 >= 256) {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = 14;
                this.state = 2;
            }
            if (n4 - n3 < this.state) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            if (this.state == 2 || bl2 || bl) {
                byArray[n3++] = (byte)(n5 >> 8);
            }
            byArray[n3++] = (byte)n5;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        if (!coderResult.isError()) return coderResult;
        if (this.convertType != 0) return coderResult;
        return this.setForReplacement(coderResult, byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private CoderResult encodeBufferLoop(CharBuffer var1_1, ByteBuffer var2_2) {
        var3_3 = var1_1.position();
        var6_4 = 0;
        var7_5 = false;
        try {
            while (var1_1.hasRemaining()) {
                block40: {
                    var4_6 = var1_1.get();
                    var8_7 = this.leftPair.indexOf(var4_6);
                    var9_9 = false;
                    var10_10 = false;
                    if (var1_1.hasRemaining() && var8_7 > -1) {
                        var11_11 = var1_1.position();
                        var12_19 = var1_1.get();
                        while (var8_7 > -1) {
                            if (this.rightPair.charAt(var8_7) == var12_19) {
                                var6_4 = this.bytePair.charAt(var8_7);
                                var9_9 = true;
                                ++var3_3;
                                var8_7 = -1;
                                continue;
                            }
                            var8_7 = this.leftPair.indexOf(var4_6, var8_7 + 1);
                        }
                        if (!var9_9) {
                            var1_1.position(var11_11);
                        }
                    }
                    if (var9_9) break block40;
                    if (!Surrogate.is(var4_6)) ** GOTO lbl62
                    if (this.sgp.parse(var4_6, var1_1) < 0) {
                        var11_12 = this.setForReplacement(this.sgp.error(), var2_2);
                        return var11_12;
                    }
                    var11_11 = this.numberOfSurrogates;
                    var12_19 = -1;
                    var13_20 = false;
                    var14_21 = var11_11 / 2;
                    if (this.SurrogateArray[0] == this.sgp.character()) {
                        var12_19 = 0;
                        var14_21 = 0;
                    } else if (this.SurrogateArray[var11_11 - 1] == this.sgp.character()) {
                        var12_19 = var11_11 - 1;
                        var14_21 = 0;
                    }
                    while (var14_21 >= 1) {
                        if (this.SurrogateArray[var14_21] == this.sgp.character()) {
                            var12_19 = var14_21;
                            break;
                        }
                        if (this.SurrogateArray[var14_21] < this.sgp.character()) {
                            if ((var11_11 + var14_21) / 2 == var14_21) {
                                var14_21 = 0;
                                continue;
                            }
                            var14_21 = (var11_11 + var14_21) / 2;
                            continue;
                        }
                        if (this.SurrogateArray[var14_21] <= this.sgp.character()) continue;
                        var11_11 = var14_21;
                        var14_21 = var11_11 / 2;
                    }
                    if (var12_19 >= 0) {
                        var6_4 = this.ByteArray.charAt(var12_19);
                        ++var3_3;
                        var10_10 = true;
                    } else {
                        var15_22 = this.setForReplacement(this.sgp.unmappableResult(), var2_2);
                        return var15_22;
lbl62:
                        // 1 sources

                        var6_4 = 65535 & DBE_Encoder.map[var4_6];
                        if (var6_4 >= 65534) {
                            var11_13 = this.setForReplacement(CoderResult.unmappableForLength(1), var2_2);
                            return var11_13;
                        }
                    }
                }
                if (this.convertType == 0) {
                    if (this.state == 2 && var6_4 < 256) {
                        if (!var2_2.hasRemaining()) {
                            var11_14 = CoderResult.OVERFLOW;
                            return var11_14;
                        }
                        this.state = 1;
                        var2_2.put((byte)15);
                    } else if (this.state == 1 && var6_4 >= 256) {
                        if (!var2_2.hasRemaining()) {
                            var11_15 = CoderResult.OVERFLOW;
                            return var11_15;
                        }
                        this.state = 2;
                        var2_2.put((byte)14);
                    }
                } else if (this.convertType == 1) {
                    if (var6_4 >= 256) {
                        var11_16 = CoderResult.unmappableForLength(1);
                        return var11_16;
                    }
                } else if (var6_4 < 256) {
                    var11_17 = this.setForReplacement(CoderResult.unmappableForLength(1), var2_2);
                    return var11_17;
                }
                if (var2_2.remaining() < this.state) {
                    var11_18 = CoderResult.OVERFLOW;
                    return var11_18;
                }
                if (this.state == 2 || var9_9) {
                    var2_2.put((byte)(var6_4 >> 8));
                }
                var2_2.put((byte)var6_4);
                ++var3_3;
            }
            var8_8 = CoderResult.UNDERFLOW;
            return var8_8;
        }
        finally {
            var1_1.position(var3_3);
        }
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.convertType == 0 && charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

