/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

class UTF8_Decoder
extends IBMCharsetDecoder {
    private final int flags;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit = "NO";
    public static final int[] States = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 1};
    public static final int[] StateMask = new int[]{0, 0, 31, 15, 7};

    protected UTF8_Decoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.flags = n;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : (String)AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    private boolean validSecond(int n, int n2, int n3) {
        if (n3 < 128 || n3 > 191) {
            return false;
        }
        if ((this.flags & 2) != 0) {
            return true;
        }
        switch (n) {
            case 2: {
                if (n2 >= 2) break;
                return false;
            }
            case 3: {
                if (n2 != 0 || n3 >= 160) break;
                return false;
            }
            case 4: {
                if ((this.flags & 4) != 0) {
                    return false;
                }
                if (n2 == 0 && n3 < 144) {
                    return false;
                }
                if (n2 == 4 && n3 > 143) {
                    return false;
                }
                if (n2 <= 4) break;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeArrayLoop(ByteBuffer var1_1, CharBuffer var2_2) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            var3_3 = var1_1.array();
                            var4_4 = var1_1.arrayOffset() + var1_1.position();
                            var5_5 = var1_1.arrayOffset() + var1_1.limit();
                            var6_6 = var2_2.array();
                            var7_7 = var2_2.arrayOffset() + var2_2.position();
                            var8_8 = var2_2.arrayOffset() + var2_2.limit();
                            var10_9 = 0;
                            var12_10 = 0;
                            var13_11 = 0;
                            var14_12 = var4_4;
                            try {
                                block2: while (var4_4 < var5_5) {
                                    block20: {
                                        block21: {
                                            if (var10_9 == 0) {
                                                block14: {
                                                    do {
                                                        if ((var11_13 = var3_3[var4_4++]) < 0) {
                                                            var14_12 = var4_4 - 1;
                                                            var10_9 = UTF8_Decoder.States[(var11_13 & 255) >> 3];
                                                            var12_10 = 1;
                                                            var13_11 = var11_13 & UTF8_Decoder.StateMask[var10_9];
                                                            if (var10_9 != 1) continue block2;
                                                            break block14;
                                                        }
                                                        if (var8_8 - var7_7 < 1) {
                                                            var14_12 = --var4_4;
                                                            var15_14 = CoderResult.OVERFLOW;
                                                            var17_22 = null;
                                                            var1_1.position(var14_12 - var1_1.arrayOffset());
                                                            var2_2.position(var7_7 - var2_2.arrayOffset());
                                                            return var15_14;
                                                        }
                                                        var6_6[var7_7++] = (char)var11_13;
                                                    } while (var4_4 < var5_5);
                                                    var14_12 = var4_4;
                                                    var15_15 = CoderResult.UNDERFLOW;
                                                    var17_23 = null;
                                                    var1_1.position(var14_12 - var1_1.arrayOffset());
                                                    var2_2.position(var7_7 - var2_2.arrayOffset());
                                                    return var15_15;
                                                }
                                                var15_16 = CoderResult.malformedForLength(1);
                                                var17_24 = null;
                                                var1_1.position(var14_12 - var1_1.arrayOffset());
                                                var2_2.position(var7_7 - var2_2.arrayOffset());
                                                return var15_16;
                                            }
                                            var11_13 = var3_3[var4_4++] & 255;
                                            if (var12_10 == 1) {
                                                if (!this.validSecond(var10_9, var13_11, var11_13)) {
                                                    var15_17 = CoderResult.malformedForLength(var12_10);
                                                    break block15;
                                                }
                                            } else if (var11_13 < 128 || var11_13 > 191) {
                                                var15_18 = CoderResult.malformedForLength(var12_10);
                                                break block16;
                                            }
                                            var13_11 = var13_11 << 6 | var11_13 & 63;
                                            if (var12_10 + 1 < var10_9) break block20;
                                            if (var13_11 >= 65536) break block21;
                                            if (var8_8 - var7_7 < 1) {
                                                var15_19 = CoderResult.OVERFLOW;
                                                break block17;
                                            }
                                            var6_6[var7_7++] = (char)var13_11;
                                            ** GOTO lbl79
                                        }
                                        if (var8_8 - var7_7 < 2) {
                                            var15_20 = CoderResult.OVERFLOW;
                                            break block18;
                                        } else {
                                            var6_6[var7_7++] = (char)((var13_11 - 65536) / 1024 + 55296);
                                            var6_6[var7_7++] = (char)((var13_11 - 65536) % 1024 + 56320);
lbl79:
                                            // 2 sources

                                            var10_9 = 0;
                                            var14_12 = var4_4;
                                            continue;
                                        }
                                    }
                                    ++var12_10;
                                }
                                var15_21 = CoderResult.UNDERFLOW;
                                break block19;
                            }
                            catch (Throwable var16_31) {
                                var17_30 = null;
                                var1_1.position(var14_12 - var1_1.arrayOffset());
                                var2_2.position(var7_7 - var2_2.arrayOffset());
                                throw var16_31;
                            }
                        }
                        var17_25 = null;
                        var1_1.position(var14_12 - var1_1.arrayOffset());
                        var2_2.position(var7_7 - var2_2.arrayOffset());
                        return var15_17;
                    }
                    var17_26 = null;
                    var1_1.position(var14_12 - var1_1.arrayOffset());
                    var2_2.position(var7_7 - var2_2.arrayOffset());
                    return var15_18;
                }
                var17_27 = null;
                var1_1.position(var14_12 - var1_1.arrayOffset());
                var2_2.position(var7_7 - var2_2.arrayOffset());
                return var15_19;
            }
            var17_28 = null;
            var1_1.position(var14_12 - var1_1.arrayOffset());
            var2_2.position(var7_7 - var2_2.arrayOffset());
            return var15_20;
        }
        var17_29 = null;
        var1_1.position(var14_12 - var1_1.arrayOffset());
        var2_2.position(var7_7 - var2_2.arrayOffset());
        return var15_21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            while (byteBuffer.hasRemaining()) {
                int n5;
                if (n2 == 0) {
                    while ((n5 = byteBuffer.get()) >= 0) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put((char)n5);
                        ++n;
                        if (byteBuffer.hasRemaining()) continue;
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    n2 = States[(n5 & 0xFF) >> 3];
                    n3 = 1;
                    n4 = n5 & StateMask[n2];
                    if (n2 != 1) continue;
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                n5 = byteBuffer.get() & 0xFF;
                if (n3 == 1) {
                    if (!this.validSecond(n2, n4, n5)) {
                        CoderResult coderResult = CoderResult.malformedForLength(n3);
                        return coderResult;
                    }
                } else if (n5 < 128 || n5 > 191) {
                    CoderResult coderResult = CoderResult.malformedForLength(n3);
                    return coderResult;
                }
                n4 = n4 << 6 | n5 & 0x3F;
                if (n3 + 1 >= n2) {
                    if (n4 < 65536) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put((char)n4);
                    } else {
                        if (charBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put((char)((n4 - 65536) / 1024 + 55296));
                        charBuffer.put((char)((n4 - 65536) % 1024 + 56320));
                    }
                    n += n2;
                    n2 = 0;
                    continue;
                }
                ++n3;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        BidiConvert bidiConvert;
        int n;
        int n2;
        char[] cArray;
        CoderResult coderResult;
        boolean bl;
        int n3 = charBuffer.position();
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !UseBuffer) {
            bl = true;
            coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
            int n4 = charBuffer.position();
            cArray = charBuffer.array();
            n2 = charBuffer.arrayOffset() + n3;
            n = charBuffer.arrayOffset() + n4;
        } else {
            bl = false;
            coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
            int n5 = charBuffer.position();
            n2 = 0;
            n = n5 - n3;
            cArray = new char[n];
            charBuffer.position(n3);
            charBuffer.get(cArray);
            charBuffer.position(n5);
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n2, n, this.bidiParms, this.toString())) {
            cArray = bidiConvert.toUnicode(cArray, n2, n, this.bidiParms, this.toString());
            if (bl) {
                System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n3, cArray.length);
            } else {
                charBuffer.position(n3);
                charBuffer.put(cArray);
            }
        }
        return coderResult;
    }
}

