/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.general;

import com.sun.javaws.ui.general.Subcontroller;
import java.util.ArrayList;

public abstract class AbstractController {
    private ArrayList subcontrollers = new ArrayList();
    private int activeSubcontrollerIndex = -1;

    public void setActiveSubcontrollerIndex(int n) {
        if (n == this.activeSubcontrollerIndex) {
            return;
        }
        Subcontroller subcontroller = this.getActiveSubcontroller();
        if (subcontroller != null) {
            subcontroller.stop();
        }
        this.ensureSize(n + 1);
        this.activeSubcontrollerIndex = n;
        if (n >= 0) {
            subcontroller = (Subcontroller)this.subcontrollers.get(n);
            if (subcontroller == null) {
                subcontroller = this.createSubcontroller(n);
                this.subcontrollers.set(n, subcontroller);
            }
            if (subcontroller != null) {
                subcontroller.start();
            }
        }
    }

    public void setSubcontroller(int n, Subcontroller subcontroller) {
        this.ensureSize(n + 1);
        if (n == this.getActiveSubcontrollerIndex()) {
            this.getActiveSubcontroller().stop();
        }
        this.subcontrollers.set(n, subcontroller);
        subcontroller.start();
    }

    public int getActiveSubcontrollerIndex() {
        return this.activeSubcontrollerIndex;
    }

    public Subcontroller getActiveSubcontroller() {
        if (this.activeSubcontrollerIndex == -1) {
            return null;
        }
        return (Subcontroller)this.subcontrollers.get(this.activeSubcontrollerIndex);
    }

    public Subcontroller getSubcontroller(int n) {
        if (n >= this.subcontrollers.size()) {
            return null;
        }
        return (Subcontroller)this.subcontrollers.get(n);
    }

    public void apply(boolean bl) {
        if (bl) {
            for (int i = this.subcontrollers.size() - 1; i >= 0; --i) {
                Subcontroller subcontroller = (Subcontroller)this.subcontrollers.get(i);
                if (subcontroller == null) continue;
                subcontroller.apply();
            }
        } else {
            Subcontroller subcontroller = this.getActiveSubcontroller();
            if (subcontroller != null) {
                subcontroller.apply();
            }
        }
    }

    public void revert(boolean bl) {
        if (bl) {
            for (int i = this.subcontrollers.size() - 1; i >= 0; --i) {
                Subcontroller subcontroller = (Subcontroller)this.subcontrollers.get(i);
                if (subcontroller == null) continue;
                subcontroller.revert();
            }
        } else {
            Subcontroller subcontroller = this.getActiveSubcontroller();
            if (subcontroller != null) {
                subcontroller.revert();
            }
        }
    }

    protected abstract Subcontroller createSubcontroller(int var1);

    private void ensureSize(int n) {
        for (int i = this.subcontrollers.size(); i < n; ++i) {
            this.subcontrollers.add(null);
        }
    }
}

