/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AIXCoreHeader;
import com.ibm.jvm.dump.extract.AIXEnvData;
import com.ibm.jvm.dump.extract.AIXHPIModule;
import com.ibm.jvm.dump.extract.AIXLdInfo;
import com.ibm.jvm.dump.extract.AIXProcess;
import com.ibm.jvm.dump.extract.AbstractLayout;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.JVMModule;
import com.ibm.jvm.dump.extract.MemoryMap;
import com.ibm.jvm.dump.format.BigEnd;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.frame.LoadMap;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFDump;
import com.ibm.jvm.dump.sdff.WordLength;
import com.ibm.jvm.dump.sdffArchive.SdffArchiveOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class AIXCore
implements AbstractLayout {
    AIXCoreHeader header;
    ExProcess process;
    DvFileReader reader;
    MemoryMap memoryMap = new MemoryMap();
    Vector ldInfoVector;
    LoadMap[] maps;
    static final byte[] HPIRAS_EYECATCHER = new String("HPIRAS").getBytes();
    static final byte[] JVMRAS_EYECATCHER = new String("JVMRAS").getBytes();
    static final byte[] JITRAS_EYECATCHER = new String("JITRAS").getBytes();
    static final int RAS_MINOR_VERSION = 1;
    static final int RAS_MAJOR_VERSION = 1;
    static final int RAS_VERSION = 65537;
    static final int JVM_MINOR_VERSION = 1;
    static final int JVM_MAJOR_VERSION = 1;
    static final int JVM_VERSION = 65537;
    static final int S64BIT = 1;
    static final int NGPRS = 32;
    static final int NFPRS = 32;
    static final int RLIM_NLIMITS = 8;
    static final int NSIG = 64;
    static final int NSIG64 = 256;
    static final int MAXCOMLEN = 32;

    public AIXCore(RandomAccessFile randomAccessFile) throws IOException {
        WordLength wordLength;
        randomAccessFile.seek(1276L);
        int n = randomAccessFile.readInt();
        if ((n & 1) != 0) {
            DvUtils.trace("64 bits", 2, false);
            wordLength = new WordLength(64);
        } else {
            DvUtils.trace("32 bits", 2, false);
            wordLength = new WordLength(32);
        }
        randomAccessFile.seek(0L);
        DvUtils.trace("Big end", 2, false);
        BigEnd bigEnd = new BigEnd();
        int n2 = 4;
        this.reader = new DvFileReader(randomAccessFile, bigEnd, wordLength, n2);
    }

    public DvFileReader getFileReader(RandomAccessFile randomAccessFile) throws IOException {
        return this.reader;
    }

    public void readHeader() throws IOException {
        DvUtils.trace("Create AIX Core Header", 2, false);
        this.header = new AIXCoreHeader(this);
    }

    public MemoryMap getMemoryMap() {
        return this.memoryMap;
    }

    private void readSegments() throws IOException {
        DvUtils.trace("readSegments", 2, false);
        this.memoryMap.addSegment(this.reader, this.header.c_stacksize, this.header.c_stackorg, this.header.c_stack, "Stack");
        this.memoryMap.addSegment(this.reader, this.header.c_datasize, this.header.c_dataorg, this.header.c_data, "User data");
        this.reader.setPos(this.header.c_vmm);
        int n = 0;
        while ((long)n < this.header.c_vmregions) {
            long l = this.reader.readLong();
            long l2 = this.reader.readLong();
            long l3 = this.reader.readLong();
            this.memoryMap.addSegment(this.reader, l2, l, l3, "Anonymously mapped area");
            ++n;
        }
        this.reader.setPos(this.header.c_segregion);
        int n2 = 0;
        while ((long)n2 < this.header.c_segs) {
            long l = this.reader.readLong();
            long l4 = this.reader.readLong();
            long l5 = this.reader.readLong();
            long l6 = this.reader.readWord();
            long l7 = this.reader.readWord();
            StringBuffer stringBuffer = new StringBuffer();
            if ((l6 & 0L) != 0L) {
                stringBuffer.append("SEG_AVAIL");
            }
            if ((l6 & 1L) != 0L) {
                stringBuffer.append("SEG_SHARED");
            }
            if ((l6 & 2L) != 0L) {
                stringBuffer.append("SEG_MAPPED");
            }
            if ((l6 & 4L) != 0L) {
                stringBuffer.append("SEG_MRDWR");
            }
            if ((l6 & 8L) != 0L) {
                stringBuffer.append("SEG_DEFER");
            }
            if ((l6 & 0x10L) != 0L) {
                stringBuffer.append("SEG_MMAP");
            }
            if ((l6 & 0x20L) != 0L) {
                stringBuffer.append("SEG_WORKING");
            }
            if ((l6 & 0x40L) != 0L) {
                stringBuffer.append("SEG_RMMAP");
            }
            if ((l6 & 0x80L) != 0L) {
                stringBuffer.append("SEG_OTHER");
            }
            if ((l6 & 0x100L) != 0L) {
                stringBuffer.append("SEG_EXTSHM");
            }
            if ((l6 & 0x200L) != 0L) {
                stringBuffer.append("SEG_TEXT ");
            }
            this.memoryMap.addSegment(this.reader, l4, l, l5, stringBuffer.toString());
            ++n2;
        }
    }

    public void readCoreFile() throws IOException {
        this.readHeader();
        this.header.dump();
        this.readSegments();
        this.memoryMap.dump();
        this.ldInfoVector = new Vector();
        if (this.header.c_loader != 0L) {
            this.populateLdInfoData(this.ldInfoVector);
        }
        Iterator iterator = this.ldInfoVector.iterator();
        while (iterator.hasNext()) {
            ((AIXLdInfo)iterator.next()).dump();
        }
        AIXLdInfo aIXLdInfo = this.findLibrary("libhpi.a");
        long l = this.findRasStructure(HPIRAS_EYECATCHER, aIXLdInfo);
        if (l == -1L) {
            throw new RuntimeException("No HPIRAS - all is lost!");
        }
        DvUtils.trace("HPIRAS at 0x" + Long.toHexString(l), 2, false);
        AIXHPIModule aIXHPIModule = new AIXHPIModule(this.memoryMap.getSegmentContaining(l), this.memoryMap.getOffset(l), this.maps);
        AIXLdInfo aIXLdInfo2 = this.findLibrary("libjvm.a");
        long l2 = this.findRasStructure(JVMRAS_EYECATCHER, aIXLdInfo2);
        if (l2 == -1L) {
            throw new RuntimeException("No JVMRAS - all is lost!");
        }
        DvUtils.trace("JVMRAS at 0x" + Long.toHexString(l2), 2, false);
        JVMModule jVMModule = new JVMModule(this.memoryMap.getSegmentContaining(l2), this.memoryMap.getOffset(l2), l2 - 24L);
        this.process = new AIXProcess(this.header.threadVector, this.ldInfoVector);
        this.process.pid = this.header.c_u.pi_pid;
        this.process.signalNumber = this.header.c_signo;
        AIXLdInfo aIXLdInfo3 = (AIXLdInfo)this.ldInfoVector.elementAt(0);
        this.process.commandLine = this.process.command = aIXLdInfo3.filename();
        AIXLdInfo aIXLdInfo4 = this.findLibrary("libjava.a");
        aIXLdInfo3.library = new File(aIXLdInfo4.directory() + "/" + aIXLdInfo3.filename());
        this.process.executable = aIXLdInfo3.name();
        this.process.hpiData = aIXHPIModule;
        this.process.jvmData = jVMModule;
        this.process.environment = new AIXEnvData(aIXLdInfo4.directory());
    }

    void populateLdInfoData(Vector vector) throws IOException {
        AIXLdInfo aIXLdInfo;
        this.reader.setPos(this.header.c_loader);
        while (true) {
            long l = this.reader.getPos();
            aIXLdInfo = new AIXLdInfo(this.reader);
            vector.add(aIXLdInfo);
            this.memoryMap.addSegment(this.reader, aIXLdInfo.datasize, aIXLdInfo.dataorg, aIXLdInfo.core_offset, "SEG_LIBDATA");
            if (aIXLdInfo.next == 0L) break;
            this.reader.setPos(l);
            this.skipBytes(aIXLdInfo.next);
        }
        int n = vector.size();
        this.maps = new LoadMap[n];
        for (int i = 1; i < n; ++i) {
            aIXLdInfo = (AIXLdInfo)vector.elementAt(i);
            this.maps[i] = new LoadMap(aIXLdInfo.name(), aIXLdInfo.textorg, aIXLdInfo.textsize);
        }
    }

    public SDFFDump getHeader() {
        return this.header;
    }

    public DvFileReader getReader() {
        return this.reader;
    }

    public ExProcess getProcess() {
        return this.process;
    }

    void goTo(long l) throws IOException {
        this.reader.setPos(this.addressToOffset(l));
    }

    void skipBytes(long l) throws IOException {
        this.reader.setPos(this.reader.getPos() + l);
    }

    long readLongAt(long l) throws IOException {
        this.goTo(l);
        return this.reader.readLong();
    }

    long readWordAt(long l) throws IOException {
        this.goTo(l);
        return this.reader.readWord();
    }

    long readAddressAt(long l) throws IOException {
        this.goTo(l);
        return this.reader.readAddress();
    }

    private long addressToOffset(long l) {
        if (l >= this.header.c_dataorg && l < this.header.c_dataend) {
            return this.header.c_data + (l - this.header.c_dataorg);
        }
        return 0L;
    }

    AIXLdInfo findLibrary(String string) throws IOException {
        Iterator iterator = this.ldInfoVector.iterator();
        while (iterator.hasNext()) {
            AIXLdInfo aIXLdInfo = (AIXLdInfo)iterator.next();
            if (!aIXLdInfo.filename().equalsIgnoreCase(string)) continue;
            return aIXLdInfo;
        }
        throw new RuntimeException("Can't find " + string);
    }

    long findRasStructure(byte[] byArray, AIXLdInfo aIXLdInfo) throws IOException {
        this.reader.setPos(aIXLdInfo.core_offset);
        DvUtils.trace("Looking for " + new String(byArray) + " Starting from 0x" + Long.toHexString(aIXLdInfo.dataorg) + " for 0x" + Long.toHexString(aIXLdInfo.datasize) + " bytes" + " at offset 0x " + Long.toHexString(this.reader.getPos()) + " in core", 2, false);
        byte[] byArray2 = new byte[512];
        int n = 0;
        long l = aIXLdInfo.dataorg;
        long l2 = this.reader.getPos() + aIXLdInfo.datasize;
        byte[] byArray3 = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        int n2 = 0;
        int n3 = byArray2.length;
        this.reader.read(byArray2);
        while (true) {
            if (n2 >= n3) {
                if (this.reader.getPos() >= l2) break;
                this.reader.read(byArray2);
                l += (long)byArray2.length;
                n2 = 0;
            }
            switch (n) {
                case 0: {
                    if (!this.byteArrayEqual(byArray2, n2, byArray, 0, byArray.length)) break;
                    n = 1;
                    break;
                }
                case 1: {
                    if (this.byteArrayEqual(byArray2, n2, byArray3, 0, byArray3.length)) {
                        long l3 = l + (long)n2 + (long)byArray3.length + 8L;
                        return l3;
                    }
                    n = 0;
                }
            }
            n2 += 8;
        }
        return -1L;
    }

    boolean byteArrayEqual(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }

    public void dumpLibs(SdffArchiveOutputStream sdffArchiveOutputStream) throws IOException {
        Iterator iterator = this.ldInfoVector.iterator();
        HashMap hashMap = new HashMap(this.ldInfoVector.size());
        while (iterator.hasNext()) {
            AIXLdInfo aIXLdInfo = (AIXLdInfo)iterator.next();
            if (hashMap.containsKey(aIXLdInfo.pathname())) continue;
            File file = new File(aIXLdInfo.pathname());
            if (!file.exists()) {
                System.err.println("JVMRAS026: *Warning* library/executable " + aIXLdInfo.pathname() + " does not exist - skipping it");
            } else if (!file.canRead()) {
                System.err.println("JVMRAS027: *Warning* library/executable " + aIXLdInfo.pathname() + " cannot be read - skipping it");
            } else {
                sdffArchiveOutputStream.putFile(aIXLdInfo.library, "Library");
            }
            hashMap.put(aIXLdInfo.pathname(), null);
        }
    }

    public void getJVMLayout(ExProcess exProcess, MemoryMap memoryMap, DvFileReader dvFileReader) throws IOException {
    }
}

