/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AbstractLayout;
import com.ibm.jvm.dump.extract.ElfHeader;
import com.ibm.jvm.dump.extract.ElfSegment;
import com.ibm.jvm.dump.extract.ElfType;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.extract.HPIModule;
import com.ibm.jvm.dump.extract.JVMModule;
import com.ibm.jvm.dump.extract.MemoryMap;
import com.ibm.jvm.dump.format.BigEnd;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.LittleEnd;
import com.ibm.jvm.dump.format.WordType;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFDump;
import com.ibm.jvm.dump.sdff.Segment;
import com.ibm.jvm.dump.sdff.WordLength;
import com.ibm.jvm.dump.sdffArchive.SdffArchiveOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Iterator;

public class Elf
implements AbstractLayout {
    ElfHeader header;
    ElfType elfType;
    DvFileReader reader;
    MemoryMap memoryMap = new MemoryMap();
    static final int ARCH_SOLARIS = 2;
    static final int ARCH_IA32 = 3;
    static final int ARCH_IA64 = 50;
    static final int ARCH_PPC32 = 20;
    static final int ARCH_PPC64 = 21;
    static final int ARCH_S390 = 22;

    public Elf(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        WordType wordType;
        WordLength wordLength;
        byte[] byArray = new byte[2];
        randomAccessFile.seek(4L);
        randomAccessFile.read(byArray);
        switch (byArray[0]) {
            case 1: {
                DvUtils.trace("32 bits", 2, false);
                wordLength = new WordLength(32);
                break;
            }
            case 2: {
                DvUtils.trace("64 bits", 2, false);
                wordLength = new WordLength(64);
                break;
            }
            default: {
                throw new IOException("JVMRAS022: Bad word length detected in core file.");
            }
        }
        switch (byArray[1]) {
            case 1: {
                DvUtils.trace("Little end", 2, false);
                wordType = new LittleEnd();
                break;
            }
            case 2: {
                DvUtils.trace("Big end", 2, false);
                wordType = new BigEnd();
                break;
            }
            default: {
                throw new IOException("JVMRAS023: Bad endian type detected in core file.");
            }
        }
        randomAccessFile.seek(17 + byArray[1]);
        byte by = randomAccessFile.readByte();
        switch (by) {
            case 20: 
            case 21: 
            case 50: {
                n = 4;
                break;
            }
            case 22: {
                n = wordLength.size / 2;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.reader = new DvFileReader(randomAccessFile, wordType, wordLength, n);
    }

    public DvFileReader getFileReader(RandomAccessFile randomAccessFile) throws IOException {
        return this.reader;
    }

    public void readHeader() throws IOException {
        DvUtils.trace("Create Elf Header", 2, false);
        this.header = new ElfHeader(this.reader);
    }

    public MemoryMap getMemoryMap() {
        return this.memoryMap;
    }

    private void readSegments() throws IOException {
        DvUtils.trace("readSegments", 2, false);
        int n = 0;
        this.reader.setPos(this.header.programHeaderOffset);
        int n2 = 0;
        while ((long)n2 < this.header.numProgramHeaders) {
            this.reader.setPos(this.header.programHeaderOffset + (long)n2 * this.header.programHeaderEntrySize);
            ElfSegment elfSegment = new ElfSegment(this);
            switch (elfSegment.getType()) {
                case 4: {
                    if (n++ == 0 && this.header.machine == 2L) break;
                    this.readNoteSegment(elfSegment);
                    break;
                }
                case 7: {
                    break;
                }
                case 1: {
                    this.memoryMap.addSegment(this.reader, elfSegment);
                    break;
                }
                default: {
                    DvUtils.trace("Ignoring section type " + elfSegment.getType(), 2, false);
                }
            }
            ++n2;
        }
    }

    private void readNoteSegment(ElfSegment elfSegment) throws IOException {
        long l = elfSegment.offset;
        this.reader.setPos(l);
        DvUtils.trace("Note start:" + Long.toHexString(elfSegment.offset) + " end:" + Long.toHexString(elfSegment.offset + elfSegment.fileSize), 2, false);
        while (l < elfSegment.offset + elfSegment.fileSize) {
            long l2;
            if (this.reader.getPos() != l) {
                System.err.println("JVMRAS014: Expected to be at offset " + Long.toHexString(l) + " after reading Note, but find " + "myself at " + "offset " + Long.toHexString(this.reader.getPos()) + ".  Adjusting offset.");
                this.reader.setPos(l);
            }
            if ((l2 = this.reader.readWord()) > 4L) {
                l2 = 8L;
            }
            long l3 = this.reader.readWord();
            long l4 = this.reader.readWord();
            String string = this.reader.readString((int)l2);
            string = string.trim();
            DvUtils.trace("-------------------------------------", 2, false);
            DvUtils.trace("nameLen = " + l2, 2, false);
            DvUtils.trace("dataSize = " + l3, 2, false);
            DvUtils.trace("type = " + l4, 2, false);
            DvUtils.trace("name = " + string, 2, false);
            DvUtils.trace("Current file offset = " + Long.toHexString(this.reader.getPos() - 16L), 2, false);
            if (!string.startsWith("CORE") && !string.startsWith("LINUX")) {
                DvUtils.trace("Segment named '" + string + "' found", 2, false);
            }
            l = this.reader.getPos() + l3;
            DvUtils.trace("Next file offset = " + Long.toHexString(l), 2, false);
            this.elfType.readNote((int)l4, l);
        }
    }

    private void createThreadIndex() {
        DvUtils.trace("The thread list has " + this.elfType.process.thread.size() + " elements", 2, false);
        this.elfType.process.setMemoryMap(this.memoryMap);
        Iterator iterator = this.elfType.process.thread.iterator();
        while (iterator.hasNext()) {
            ExThread exThread = null;
            try {
                exThread = (ExThread)iterator.next();
                this.elfType.process.addThreadIndex(exThread);
            }
            catch (Exception exception) {
                System.err.println("JVMRAS028: Could not map stack address 0x" + Long.toHexString(exThread.context.getSp()) + " to a data segment.");
            }
        }
    }

    public void readCoreFile() throws IOException {
        this.readHeader();
        this.header.dump();
        this.elfType = ElfType.makeElfType(this);
        this.readSegments();
        this.createThreadIndex();
    }

    public void getJVMLayout(ExProcess exProcess, MemoryMap memoryMap, DvFileReader dvFileReader) throws IOException {
        DvUtils.trace("JVMLayout", 0, false);
        Enumeration enumeration = memoryMap.segments.elements();
        byte[] byArray = new byte[]{82, 65, 83, 0, 0, 0, 0, 0, 0};
        if (dvFileReader.endType instanceof BigEnd) {
            DvUtils.trace("Look for big-end patterns", 2, false);
            byArray[8] = 85;
            byArray[6] = 85;
            byArray[7] = -86;
            byArray[5] = -86;
        } else {
            DvUtils.trace("Look for little-end patterns", 2, false);
            byArray[7] = 85;
            byArray[5] = 85;
            byArray[8] = -86;
            byArray[6] = -86;
        }
        int n = 2;
        block0: while (enumeration.hasMoreElements()) {
            Segment segment = (Segment)enumeration.nextElement();
            DvUtils.trace("Segment type=" + segment.moduleType + " length=" + segment.moduleSize + " offset=" + Long.toHexString(segment.offset), 2, false);
            if (segment.moduleType != 2 || segment.moduleSize > 0x10000000L) continue;
            DvUtils.trace("Segment type=" + segment.moduleType + " length=" + segment.moduleSize + " offset=" + Long.toHexString(segment.offset), 2, false);
            int n2 = 2048;
            int n3 = (int)segment.moduleSize;
            byte[] byArray2 = new byte[n2];
            long l = segment.moduleAddress.getAddressAsLong();
            int n4 = 0;
            dvFileReader.setPos(segment.offset);
            block1: while (n3 > 0) {
                dvFileReader.read(byArray2);
                n3 -= n2;
                int n5 = 0;
                while (n5 < n2) {
                    while (byArray2[n5++] == byArray[n4]) {
                        long l2;
                        if (++n4 == byArray.length) {
                            l2 = dvFileReader.getPos();
                            DvUtils.trace("Match found", 2, false);
                            dvFileReader.setPos(dvFileReader.getPos() - (long)n2 + (long)n5 - (long)n4 - 3L);
                            String string = dvFileReader.readString(3);
                            long l3 = dvFileReader.getPos() + 21L;
                            DvUtils.trace("match:" + string, 2, false);
                            if (string.compareTo("HPI") == 0) {
                                DvUtils.trace("HPI Found", 2, false);
                                exProcess.hpiData = new HPIModule(segment, l3);
                                --n;
                                dvFileReader.setPos(l2);
                            } else if (string.compareTo("JVM") == 0) {
                                DvUtils.trace("JVM Found", 2, false);
                                exProcess.jvmData = new JVMModule(segment, l3, l + (long)n5 - (long)n4 - 3L);
                                --n;
                                dvFileReader.setPos(l2);
                            }
                            if (n == 0) break block0;
                            n4 = 0;
                        }
                        if (n5 != n2) continue;
                        l2 = dvFileReader.getPos() - (long)n2 + (long)n5;
                        DvUtils.trace("match crosses buffer boundary " + l2, 2, false);
                        l += (long)n2;
                        continue block1;
                    }
                    if (n4 <= 0) continue;
                    n4 = 0;
                    if (n5 <= 0) continue;
                    --n5;
                }
                l += (long)n2;
            }
        }
        if (exProcess.hpiData == null) {
            System.err.println("JVMRAS002: Could not find eyecatcher HPIRAS in core file.");
        }
        if (exProcess.jvmData == null) {
            System.err.println("JVMRAS003: Could not find eyecatcher JVMRAS in core file.");
        }
    }

    public SDFFDump getHeader() {
        return this.header;
    }

    public DvFileReader getReader() {
        return this.reader;
    }

    public ExProcess getProcess() {
        return this.elfType.process;
    }

    public void dumpLibs(SdffArchiveOutputStream sdffArchiveOutputStream) throws IOException {
    }
}

