/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class CType {
    public static final int TYPE_PRIMITIVE = 1;
    public static final int TYPE_STRUCT = 2;
    public static final int TYPE_UNION = 3;
    public static final int TYPE_ENUM = 4;
    public static final int TYPE_POINTER = 5;
    public static final int TYPE_ARRAY = 6;
    public static final int TYPE_FUNCTION = 7;
    public static final int TYPE_ALIAS = 8;
    public static final int TYPE_STRUCTTAG = 9;
    int typeNum;
    int size;
    int baseType;
    String name;
    String description;
    CType aliasType;
    int numFields;
    FieldInfo[] fields;
    CType derefType;
    ArrayInfo arrayInfo;
    static LinkedList declaredTypes = new LinkedList();
    static HashMap typeMap = new HashMap();
    static EnumValues[] enumValues;

    private CType parseTypeNum(String string, int n) {
        String string2 = string.substring(n);
        int n2 = Integer.parseInt(string2);
        CType cType = CType.find(n2);
        if (cType != null) {
            return cType;
        }
        cType = CType.create(n2);
        return cType;
    }

    private int parseField(String string, int n) {
        int n2;
        int n3 = n2 = n;
        FieldInfo fieldInfo = new FieldInfo();
        n3 = string.indexOf(58, n2);
        if (n3 < 0) {
            return string.length();
        }
        fieldInfo.name = string.substring(n2, n3);
        ++n3;
        n2 = n3;
        int n4 = Integer.parseInt(string.substring(n2, n3 = string.indexOf(44, n2)));
        fieldInfo.type = CType.find(n4);
        if (fieldInfo.type == null) {
            fieldInfo.type = CType.create(n4);
        }
        n2 = ++n3;
        n3 = string.indexOf(44, n2);
        fieldInfo.offset = Integer.parseInt(string.substring(n2, n3));
        n2 = ++n3;
        n3 = string.indexOf(59, n2);
        fieldInfo.size = Integer.parseInt(string.substring(n2, n3));
        ++this.numFields;
        FieldInfo[] fieldInfoArray = this.fields;
        this.fields = new FieldInfo[this.numFields];
        if (fieldInfoArray != null) {
            System.arraycopy(fieldInfoArray, 0, this.fields, 0, this.numFields - 1);
        }
        this.fields[this.numFields - 1] = fieldInfo;
        return ++n3;
    }

    private void parseStruct(String string, int n) {
        int n2 = n + 1;
        if (string.equals("s0")) {
            if (this.name == null) {
                this.name = "void";
            }
            return;
        }
        while (string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
            ++n2;
        }
        if (this.size == 0) {
            this.size = Integer.parseInt(string.substring(n + 1, n2));
        }
        this.numFields = 0;
        while (n2 < string.length()) {
            n2 = this.parseField(string, n2);
        }
    }

    private void parseArray(String string, int n) {
        this.arrayInfo = new ArrayInfo();
        int n2 = string.indexOf(59) + 1;
        this.arrayInfo.dimensions = 1;
        this.arrayInfo.start = new int[1];
        this.arrayInfo.end = new int[1];
        int n3 = string.indexOf(59, n2);
        this.arrayInfo.start[0] = Integer.parseInt(string.substring(n2, n3));
        n2 = ++n3;
        n3 = string.indexOf(59, n2);
        this.arrayInfo.end[0] = Integer.parseInt(string.substring(n2, n3));
        n2 = ++n3;
        while (n3 < string.length() && string.charAt(n3) != ';') {
            ++n3;
        }
        this.arrayInfo.type = CType.create(Integer.parseInt(string.substring(n2, n3)));
    }

    private void parseEnum(String string, int n) {
        int n2;
        int n3;
        int n4 = n3 = enumValues != null ? enumValues.length : 0;
        if (string.charAt(++n) == '-') {
            ++n;
        }
        while (string.charAt(n) >= '0' && string.charAt(n) <= '9') {
            ++n;
        }
        int n5 = n2 = n;
        while (n5 < string.length() && (n5 = string.indexOf(58, n2)) >= 0 && n5 != n2) {
            String string2 = string.substring(n2, n5);
            ++n5;
            n2 = n5;
            String string3 = string.substring(n2, n5 = string.indexOf(44, n2));
            if (string3.equals("2147483648")) {
                string3 = "-2147483648";
            }
            int n6 = Integer.parseInt(string3);
            n2 = ++n5;
            EnumValues[] enumValuesArray = new EnumValues[++n3];
            if (enumValues != null) {
                System.arraycopy(enumValues, 0, enumValuesArray, 0, n3 - 1);
            }
            enumValues = enumValuesArray;
            CType.enumValues[n3 - 1] = new EnumValues();
            CType.enumValues[n3 - 1].name = string2;
            CType.enumValues[n3 - 1].value = n6;
        }
    }

    private void parseStab(String string) {
        int n = 0;
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.charAt(n) == 'V' || string.charAt(n) == 'k') {
            ++n;
        }
        switch (string.charAt(n)) {
            case '*': {
                this.baseType = 5;
                this.derefType = this.parseTypeNum(string, n + 1);
                break;
            }
            case 's': {
                this.baseType = 2;
                this.parseStruct(string, n);
                break;
            }
            case 'u': {
                this.baseType = 3;
                this.parseStruct(string, n);
                break;
            }
            case 'e': {
                this.baseType = 4;
                this.parseEnum(string, n);
                break;
            }
            case 'a': {
                this.baseType = 6;
                this.parseArray(string, n);
                break;
            }
            case 'f': {
                this.baseType = 7;
                this.derefType = this.parseTypeNum(string, n + 1);
                break;
            }
            case '-': {
                String string2 = string.substring(n);
                this.baseType = Integer.parseInt(string2);
                break;
            }
            case 'r': {
                break;
            }
            default: {
                this.baseType = 8;
                this.aliasType = this.parseTypeNum(string, n);
            }
        }
    }

    static CType create(int n) {
        CType cType = CType.find(n);
        if (cType == null) {
            cType = new CType();
            cType.typeNum = n;
            declaredTypes.add(cType);
        }
        return cType;
    }

    public static CType create(int n, int n2, int n3, String string, String string2) {
        CType cType = CType.find(n);
        if (cType == null) {
            cType = new CType();
            declaredTypes.add(cType);
        }
        cType.typeNum = n;
        cType.baseType = n2;
        cType.size = n3;
        cType.name = string;
        cType.description = string2;
        if (string2 != null && string2.length() > 0) {
            cType.parseStab(string2);
        }
        return cType;
    }

    public static CType find(String string) {
        CType cType = (CType)typeMap.get(string);
        if (cType == null) {
            Iterator iterator = declaredTypes.iterator();
            while (iterator.hasNext()) {
                cType = (CType)iterator.next();
                if (cType.name == null) continue;
                typeMap.put(cType.name, cType);
            }
            cType = (CType)typeMap.get(string);
        }
        return cType;
    }

    public static CType find(int n) {
        Iterator iterator = declaredTypes.iterator();
        while (iterator.hasNext()) {
            CType cType = (CType)iterator.next();
            if (cType.typeNum != n) continue;
            return cType;
        }
        return null;
    }

    public static int offsetof(String string, String string2, int n) {
        int n2 = n;
        Iterator iterator = declaredTypes.iterator();
        while (iterator.hasNext()) {
            CType cType = (CType)iterator.next();
            if ((cType.name == null || !cType.name.equals(string)) && cType.name != string || (n2 = cType.getFieldOffset(string2)) == -1) continue;
            return n2;
        }
        if (n == -1) {
            throw new Error("Could not find field " + string2 + " in type " + string);
        }
        return n;
    }

    CType getType() {
        CType cType = null;
        CType cType2 = this;
        while (cType2.baseType == 8) {
            if (cType2 == cType) {
                return null;
            }
            cType = cType2;
            cType2 = cType2.aliasType;
        }
        return cType2;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        if (this.getType() != this) {
            return this.getType().size;
        }
        return this.size;
    }

    public int getNumFields() {
        try {
            if (this.getType() != this) {
                return this.getType().numFields;
            }
        }
        catch (Exception exception) {
            return 0;
        }
        return this.numFields;
    }

    public CType getFieldType(int n) {
        if (this.getType() != this) {
            return this.getType().getFieldType(n);
        }
        if (n < this.numFields && n >= 0) {
            return this.fields[n].type.getType();
        }
        return null;
    }

    public int getFieldOffset(int n) {
        if (this.getType() != this) {
            return this.getType().getFieldOffset(n);
        }
        if (n < this.numFields && n >= 0) {
            return this.fields[n].offset / 8;
        }
        return -1;
    }

    public int getFieldSize(int n) {
        if (this.getType() != this) {
            return this.getType().getFieldSize(n);
        }
        if (n < this.numFields && n >= 0) {
            return this.fields[n].size / 8;
        }
        return -1;
    }

    public String getFieldName(int n) {
        if (this.getType() != this) {
            return this.getType().getFieldName(n);
        }
        if (n < this.numFields && n >= 0) {
            return this.fields[n].name;
        }
        return null;
    }

    public CType getFieldType(String string) {
        return this.getFieldType(this.getFieldIndex(string));
    }

    public int getFieldOffset(String string) {
        return this.getFieldOffset(this.getFieldIndex(string));
    }

    public int getFieldSize(String string) {
        return this.getFieldSize(this.getFieldIndex(string));
    }

    public int getFieldIndex(String string) {
        if (this.getType() != this) {
            return this.getType().getFieldIndex(string);
        }
        for (int i = 0; i < this.numFields; ++i) {
            if (!string.equals(this.fields[i].name)) continue;
            return i;
        }
        return -1;
    }

    public static int getConstant(String string) {
        for (int i = 0; i < enumValues.length; ++i) {
            if (!string.equals(CType.enumValues[i].name)) continue;
            return CType.enumValues[i].value;
        }
        return 0;
    }

    public static void list() {
        Iterator iterator = declaredTypes.iterator();
        while (iterator.hasNext()) {
            CType cType = (CType)iterator.next();
            System.out.println(cType);
        }
    }

    public static int listSize() {
        int n = 0;
        Iterator iterator = declaredTypes.iterator();
        while (iterator.hasNext()) {
            CType cType = (CType)iterator.next();
            ++n;
        }
        return n;
    }

    public String toString() {
        String string = "Typenum: " + this.typeNum + "\n";
        string = string + "name = " + this.name + " " + "baseType = " + this.baseType + "\n";
        if (this.baseType == 2 || this.baseType == 3) {
            for (int i = 0; i < this.numFields; ++i) {
                CType cType = this.fields[i].type;
                int n = 0;
                while (cType.derefType != null) {
                    ++n;
                    cType = cType.derefType;
                }
                string = string + "\t" + cType.name + " ";
                for (int j = 0; j < n; ++j) {
                    string = string + "*";
                }
                string = string + "\t" + this.fields[i].name + " : " + this.fields[i].offset / 8 + "\n";
            }
        }
        return string;
    }

    public static void deleteAll() {
        declaredTypes = new LinkedList();
    }

    public int hashCode() {
        return this.typeNum;
    }

    public boolean equals(Object object) {
        CType cType = (CType)object;
        return this.typeNum == cType.typeNum;
    }

    class EnumValues {
        String name;
        int value;

        EnumValues() {
        }
    }

    class ArrayInfo {
        int dimensions;
        int[] start;
        int[] end;
        CType type;

        ArrayInfo() {
        }
    }

    class FieldInfo {
        CType type;
        int offset;
        int size;
        String name;

        FieldInfo() {
        }
    }
}

