/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.OutputStrategy;
import com.ibm.jvm.dump.plugins.STGlobalData;

class MarkStackDetails {
    private final STGlobalData sTGlobalData;
    private DvAddress firstMarkStack = null;
    private int markStackSize;

    MarkStackDetails(STGlobalData sTGlobalData) {
        this.sTGlobalData = sTGlobalData;
        this.firstMarkStack = this.sTGlobalData.getAddressItem("mstackp");
        CType cType = CType.find("MarkStack");
        this.markStackSize = cType != null ? cType.getSize() : 0;
        if (this.markStackSize == 0) {
            cType = CType.find("_MarkStack");
            this.markStackSize = cType != null ? cType.getSize() : 0;
        }
        if (this.markStackSize == 0) {
            this.markStackSize = 16384;
        }
    }

    DvAddress markStackForHelper(int n) {
        long l = this.markStackSize * (n + 1);
        DvAddress dvAddress = this.sTGlobalData.getAddressItem("mstackp");
        try {
            dvAddress.offsetBy(l);
        }
        catch (DvAddressException dvAddressException) {
            dvAddress = null;
        }
        return dvAddress;
    }

    void report(OutputStrategy outputStrategy) {
        outputStrategy.output("Mark Stack Size is " + this.markStackSize);
        outputStrategy.output("First Mark Stack is at 0x" + DvUtils.rJustifyZ(Long.toHexString(this.firstMarkStack.getAddressAsLong()), 0));
        DvAddress dvAddress = this.firstMarkStack;
        for (int i = 0; i < this.sTGlobalData.getGcHelperDetails().getGcHelpersCeiling(); ++i) {
            outputStrategy.output("Next  Mark Stack is at 0x" + DvUtils.rJustifyZ(Long.toHexString(this.markStackForHelper(i).getAddressAsLong()), 0));
        }
    }
}

