/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.CompareVisitor;
import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.Vertex;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.util.BitSetArray;
import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.IntegerMap;
import com.ibm.jvm.util.IntegerStack;
import com.ibm.jvm.util.SortedIntEnumeration;
import com.ibm.jvm.util.SvcdumpProperties;
import com.ibm.jvm.util.html.Document;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Random;
import java.util.Stack;

public class SimpleGraph
extends Base {
    IntegerArray vertexIds = new IntegerArray();
    IntegerArray vertexIndexes = new IntegerArray();
    IntegerArray vertexSizes = new IntegerArray();
    IntegerArray orderedVertexIds;
    BitSetArray edges = new BitSetArray("Edges");
    IntegerMap indexCache;
    int size;
    BitSet deleted = new BitSet();
    boolean recordParents;
    BitSetArray parents;
    boolean complete;
    boolean sizeMatters = true;
    Document doc = new Document();
    BitSet isValid;
    int[] idom;
    PrintClient client;
    boolean exact = false;
    boolean uselessmemory = false;
    boolean usebranches = false;
    boolean usecomplex = false;
    boolean useinterval = false;
    boolean onlymedium = false;
    Stepper stepper;
    static final int pairlimit = SvcdumpProperties.getIntProperty("findroots.pairlimit", 50);
    static final boolean nosubgraph = SvcdumpProperties.getBooleanProperty("findroots.nosubgraph", true);
    static final boolean optinterval = SvcdumpProperties.getBooleanProperty("findroots.optinterval", true);
    HashMap frozenObjects = new HashMap();

    public SimpleGraph() {
        this.doc.setPlainText(!SvcdumpProperties.getBooleanProperty("svcdump.output.html", false));
        this.sizeMatters = SvcdumpProperties.getBooleanProperty("findroots.sizematters", true);
        this.exact = SvcdumpProperties.getBooleanProperty("findroots.exact", false);
        this.uselessmemory = SvcdumpProperties.getBooleanProperty("findroots.uselessmemory", false);
        this.usebranches = SvcdumpProperties.getBooleanProperty("findroots.usebranches", false);
        this.usecomplex = SvcdumpProperties.getBooleanProperty("findroots.usecomplex", false);
        this.useinterval = SvcdumpProperties.getBooleanProperty("findroots.useinterval", false);
        this.onlymedium = SvcdumpProperties.getBooleanProperty("findroots.onlymedium", false);
    }

    public SimpleGraph inverse(SimpleGraph simpleGraph) {
        int n;
        int n2;
        this.complete();
        for (n2 = 0; n2 < this.size; ++n2) {
            n = this.vertexIds.get(n2);
            simpleGraph.addVertex(n, this.vertexSizes.get(n2));
        }
        for (n2 = 0; n2 < this.size; ++n2) {
            n = this.vertexIds.get(n2);
            IntEnumeration intEnumeration = this.edges.elements(n2);
            while (intEnumeration.hasMoreElements()) {
                int n3 = intEnumeration.nextInt();
                simpleGraph.addEdge(this.vertexIds.get(n3), n);
            }
        }
        simpleGraph.complete();
        return simpleGraph;
    }

    public int reachFrom(int n, BitSet bitSet) {
        this.complete();
        int n2 = this.idToIndex(n);
        Integer n3 = (Integer)this.dfs(new Visitor(){
            int n = 0;

            public void enterNode(int n, int n2) {
                this.n += SimpleGraph.this.vertexSizes.get(n);
            }

            public Object result() {
                return new Integer(this.n);
            }
        }, n2, bitSet);
        return n3;
    }

    public int size() {
        return this.size;
    }

    public void setPrintClient(PrintClient printClient) {
        this.client = printClient;
    }

    String className() {
        return "SimpleGraph";
    }

    public IntegerArray biggestIds() {
        IntegerArray integerArray = (IntegerArray)this.vertexIds.clone();
        IntegerArray integerArray2 = (IntegerArray)this.vertexSizes.clone();
        integerArray2.sort(integerArray);
        return integerArray;
    }

    public int getSize(int n) {
        this.complete();
        int n2 = this.idToIndex(n);
        return this.vertexSizes.get(n2);
    }

    public void setSize(int n, int n2) {
        this.complete();
        int n3 = this.idToIndex(n);
        this.vertexSizes.put(n3, n2);
    }

    public IntEnumeration getChildren(int n) {
        int n2 = this.idToIndex(n);
        SimpleGraph.Assert(n2 >= 0);
        IntEnumeration intEnumeration = this.edges.elements(n2);
        class WrapIntEnumeration
        implements IntEnumeration {
            IntEnumeration e;

            WrapIntEnumeration(IntEnumeration intEnumeration) {
                this.e = intEnumeration;
            }

            public boolean hasMoreElements() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return new Integer(this.nextInt());
            }

            public int nextInt() {
                int n = this.e.nextInt();
                return SimpleGraph.this.vertexIds.get(n);
            }

            public void reset() {
                this.e.reset();
            }
        }
        return new WrapIntEnumeration(intEnumeration);
    }

    public boolean isLeaf(int n) {
        return this.getChildCount(n) == 0;
    }

    public int getChildCount(int n) {
        int n2 = this.idToIndex(n);
        return this.edges.numberOfElements(n2);
    }

    public SimpleGraph newInstance() {
        try {
            return (SimpleGraph)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SimpleGraph getSubgraph(int n) {
        this.complete();
        int n2 = this.idToIndex(n);
        SimpleGraph.Assert(n2 >= 0);
        SimpleGraph simpleGraph = (SimpleGraph)this.dfs(new Visitor(){
            SimpleGraph subgraph;

            public void init() {
                this.subgraph = SimpleGraph.this.newInstance();
                this.subgraph.setRecordParents(true);
            }

            public void visitChildAtExit(int n, int n2, boolean bl) {
                int n3 = SimpleGraph.this.vertexIds.get(n2);
                int n4 = SimpleGraph.this.vertexIds.get(n);
                this.subgraph.addVertex(n3, SimpleGraph.this.vertexSizes.get(n2));
                this.subgraph.addVertex(n4, SimpleGraph.this.vertexSizes.get(n));
                this.subgraph.addEdge(n4, n3);
            }

            public Object result() {
                return this.subgraph;
            }
        }, n2);
        simpleGraph.complete();
        this.log("subgraph returned, size " + simpleGraph.size + " our size " + this.size);
        return simpleGraph;
    }

    int ancestorWithLowestSemi(int n, int[] nArray, BitSet bitSet, int[] nArray2, int[] nArray3) {
        int n2 = n;
        while (bitSet.get(n)) {
            if (nArray2[nArray3[n]] < nArray2[nArray3[n2]]) {
                n2 = n;
            }
            n = nArray[n];
        }
        return n2;
    }

    int ancestorWithLowestSemi(int n, int[] nArray, BitSet bitSet, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = nArray[n];
        if (bitSet.get(n2)) {
            int n3 = this.ancestorWithLowestSemi(n2, nArray, bitSet, nArray2, nArray3, nArray4);
            nArray[n] = nArray[n2];
            if (nArray2[nArray3[n3]] < nArray2[nArray3[nArray4[n]]]) {
                nArray4[n] = n3;
            }
        }
        return nArray4[n];
    }

    void link(int n, int n2, BitSet bitSet, int[] nArray) {
        bitSet.set(n2);
        nArray[n2] = n2;
    }

    BitSetArray findDominators(int n, int n2) {
        this.calculateImmediateDominators(n);
        int n3 = this.idToIndex(n2);
        BitSetArray bitSetArray = new BitSetArray("Dominators");
        int n4 = this.idom[n3];
        while (n4 >= 0) {
            bitSetArray.set(n4);
            n4 = this.idom[n4];
        }
        return bitSetArray;
    }

    void calculateImmediateDominators(int n) {
        int n2;
        int n3;
        if (this.idom != null) {
            return;
        }
        this.log("begin calculateImmediateDominators");
        this.complete();
        int n4 = this.idToIndex(n);
        this.idom = new int[this.size];
        int[] nArray = new int[this.size];
        int[] nArray2 = new int[this.size];
        int[] nArray3 = new int[this.size];
        int[] nArray4 = new int[this.size];
        BitSetArray bitSetArray = new BitSetArray(this.size, "pre");
        BitSetArray bitSetArray2 = new BitSetArray(this.size, "bucket");
        int[] nArray5 = new int[this.size];
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.size; ++i) {
            this.idom[i] = -1;
            nArray5[i] = -1;
            nArray2[i] = -1;
        }
        class AssignDfnum
        extends Visitor {
            int N = 1;
            int[] dfnum;
            int[] vertex;
            int[] parent;
            BitSetArray pre;

            AssignDfnum(int[] nArray, int[] nArray2, int[] nArray3, BitSetArray bitSetArray) {
                this.dfnum = nArray;
                this.vertex = nArray2;
                this.parent = nArray3;
                this.pre = bitSetArray;
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (bl) {
                    this.dfnum[n2] = this.N;
                    this.vertex[this.N] = n2;
                    this.parent[n2] = n;
                    ++this.N;
                }
                this.pre.set(n2, n);
            }

            public Object result() {
                return null;
            }
        }
        this.dfs(new AssignDfnum(nArray, nArray2, nArray3, bitSetArray), n4);
        this.log("finished assigning dfs numbers");
        nArray2[0] = n4;
        IntEnumeration intEnumeration = bitSetArray.elements(0);
        IntEnumeration intEnumeration2 = bitSetArray2.elements(0);
        for (n3 = this.size - 1; n3 >= 0; --n3) {
            int n5;
            int n6;
            int n7;
            n2 = nArray2[n3];
            if (n2 == -1 || n2 == n4) continue;
            int n8 = n7 = nArray3[n2];
            IntEnumeration intEnumeration3 = bitSetArray.elements(n2, intEnumeration);
            while (intEnumeration3.hasMoreElements()) {
                n6 = intEnumeration3.nextInt();
                n5 = nArray[n6] <= nArray[n2] ? n6 : nArray5[this.ancestorWithLowestSemi(n6, nArray3, bitSet, nArray, nArray5, nArray4)];
                if (nArray[n5] >= nArray[n8]) continue;
                n8 = n5;
            }
            nArray5[n2] = n8;
            bitSetArray2.set(n8, n2);
            this.link(n7, n2, bitSet, nArray4);
            intEnumeration3 = bitSetArray2.elements(n7, intEnumeration2);
            while (intEnumeration3.hasMoreElements()) {
                n6 = intEnumeration3.nextInt();
                n5 = this.ancestorWithLowestSemi(n6, nArray3, bitSet, nArray, nArray5, nArray4);
                if (nArray5[n5] == nArray5[n6]) {
                    this.idom[n6] = n7;
                    continue;
                }
                this.idom[n6] = n5 | Integer.MIN_VALUE;
            }
            bitSetArray2.clearAll(n7);
        }
        this.log("finished idom calculation");
        for (n3 = 0; n3 < this.size; ++n3) {
            n2 = nArray2[n3];
            if (n2 == -1 || n2 == n4 || this.idom[n2] >= 0) continue;
            SimpleGraph.Assert(this.idom[n2] != -1);
            this.idom[n2] = this.idom[this.idom[n2] & Integer.MAX_VALUE];
        }
        this.log("end calculateImmediateDominators");
    }

    public int id(int n) {
        return this.vertexIds.get(n);
    }

    public BitSetArray getDominators(int n, int n2) {
        int n3;
        int n4;
        this.complete();
        int n5 = this.idToIndex(n);
        SimpleGraph.Assert(n5 >= 0);
        IntegerArray integerArray = (IntegerArray)this.dfs(new Visitor(){
            IntegerArray reversePostOrder = new IntegerArray();

            public void exitNode(int n) {
                this.reversePostOrder.add(n);
            }

            public Object result() {
                return this.reversePostOrder;
            }
        }, n5);
        BitSetArray bitSetArray = new BitSetArray(this.size + 1, "getDoms");
        bitSetArray.set(n5, n5);
        BitSet bitSet = new BitSet();
        for (n4 = 0; n4 < this.size; ++n4) {
            if (n4 == n5) continue;
            bitSet.set(n4);
            bitSetArray.setAll(n4, this.size);
        }
        n4 = 0;
        int n6 = 0;
        do {
            int n7 = 0;
            n4 = 0;
            for (int i = this.size - 1; i >= 0; --i) {
                if (i == n5) continue;
                n3 = 0;
                IntEnumeration intEnumeration = this.parents.elements(i);
                while (intEnumeration.hasMoreElements()) {
                    int n8 = intEnumeration.nextInt();
                    if (!bitSet.get(n8)) continue;
                    n3 = 1;
                    break;
                }
                if (n6 != 0 && n3 == 0) continue;
                boolean bl = true;
                bitSetArray.clearAll(this.size);
                IntEnumeration intEnumeration2 = this.parents.elements(i);
                while (intEnumeration2.hasMoreElements()) {
                    int n9 = intEnumeration2.nextInt();
                    if (bl) {
                        bitSetArray.copy(n9, this.size);
                        bl = false;
                        continue;
                    }
                    bitSetArray.and(this.size, n9);
                }
                bitSetArray.set(this.size, i);
                if (!bitSetArray.equals(i, this.size)) {
                    bitSetArray.copy(this.size, i);
                    bitSet.set(i);
                    n4 = 1;
                    ++n7;
                    continue;
                }
                bitSet.clear(i);
            }
            ++n6;
        } while (n4 != 0);
        BitSetArray bitSetArray2 = new BitSetArray("idoms");
        n5 = this.idToIndex(n2);
        IntEnumeration intEnumeration = bitSetArray.elements(n5);
        while (intEnumeration.hasMoreElements()) {
            n3 = intEnumeration.nextInt();
            if (n3 == n5) continue;
            bitSetArray2.set(n3);
        }
        return bitSetArray2;
    }

    public int[] getReferences(int n) {
        this.complete();
        int n2 = this.idToIndex(n);
        SimpleGraph.Assert(n2 >= 0);
        int[] nArray = new int[this.edges.numberOfElements(n2)];
        int n3 = 0;
        IntEnumeration intEnumeration = this.edges.elements(n2);
        while (intEnumeration.hasMoreElements()) {
            int n4 = intEnumeration.nextInt();
            nArray[n3++] = this.vertexIds.get(n4);
        }
        return nArray;
    }

    void freeze(Object object, String string) {
        this.log("freeze " + string);
        try {
            File file = File.createTempFile("tmp", ".freeze");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            this.frozenObjects.put(string, file);
            this.log("freeze " + string + " complete");
        }
        catch (Exception exception) {
            throw new Error("Error freezing object: " + exception);
        }
    }

    Object unfreeze(String string) {
        this.log("unfreeze " + string);
        try {
            File file = (File)this.frozenObjects.get(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            this.frozenObjects.remove(string);
            file.delete();
            this.log("unfreeze " + string + " complete");
            return object;
        }
        catch (Exception exception) {
            throw new Error("Error unfreezing object: " + exception);
        }
    }

    void addEdgeByIndex(int n, int n2) {
        this.edges.set(n, n2);
        if (this.recordParents) {
            this.parents.set(n2, n);
        }
    }

    public void addEdge(int n, int n2) {
        int n3 = this.idToIndex(n);
        int n4 = this.idToIndex(n2);
        this.edges.set(n3, n4);
        if (this.recordParents) {
            this.parents.set(n4, n3);
        }
    }

    void flushCache() {
        if (this.indexCache == null) {
            return;
        }
        IntEnumeration intEnumeration = this.indexCache.getKeys();
        while (intEnumeration.hasMoreElements()) {
            int n = intEnumeration.nextInt();
            int n2 = this.indexCache.get(n);
            this.vertexIndexes.add(n2);
            this.vertexIds.add(n);
        }
        this.vertexIds.sort(this.vertexIndexes);
        this.indexCache = null;
    }

    public void complete() {
        if (!this.complete) {
            this.flushCache();
            this.vertexIndexes.sort(this.vertexIds);
            this.vertexIndexes = null;
            if (this.isValid != null) {
                IntEnumeration intEnumeration = this.edges.elements(0);
                for (int i = 1; i < this.size; ++i) {
                    if (this.isValid.get(i) || !SimpleGraph.verbose()) continue;
                    System.out.println("warning: found invalid ref 0x" + SimpleGraph.hex(this.vertexIds.get(i)) + " at index " + i);
                    for (int j = 0; j < this.size; ++j) {
                        IntEnumeration intEnumeration2 = this.edges.elements(j, intEnumeration);
                        while (intEnumeration2.hasMoreElements()) {
                            int n = intEnumeration2.nextInt();
                            if (n != i) continue;
                            System.out.println("    referenced from 0x" + SimpleGraph.hex(this.vertexIds.get(j)));
                        }
                    }
                }
            }
            this.edges.close();
            if (this.recordParents) {
                this.parents.close();
            }
            this.complete = true;
        }
    }

    void createSlot() {
        this.edges.addSlot();
        if (this.recordParents) {
            this.parents.addSlot();
        }
        this.vertexSizes.add(1);
    }

    public int idToIndex(int n) {
        if (this.complete) {
            int n2;
            if (this.orderedVertexIds == null) {
                this.orderedVertexIds = new IntegerArray();
                this.vertexIndexes = new IntegerArray();
                for (n2 = 0; n2 < this.vertexIds.size(); ++n2) {
                    this.orderedVertexIds.add(this.vertexIds.get(n2));
                    this.vertexIndexes.add(n2);
                }
                this.orderedVertexIds.sort(this.vertexIndexes);
            }
            if ((n2 = this.orderedVertexIds.indexOf(n)) == -1) {
                System.out.println("warning! could not find id " + SimpleGraph.hex(n));
            }
            return this.vertexIndexes.get(n2);
        }
        int n3 = this.vertexIds.indexOf(n);
        if (n3 == -1) {
            if (this.indexCache == null) {
                this.indexCache = new IntegerMap();
            }
            if ((n3 = this.indexCache.get(n)) == -1) {
                this.createSlot();
                n3 = this.vertexIds.size() + this.indexCache.size();
                this.indexCache.put(n, n3);
                if (this.indexCache.size() == 500000) {
                    this.flushCache();
                }
                ++this.size;
            }
        } else {
            n3 = this.vertexIndexes.get(n3);
        }
        return n3;
    }

    public void setRecordParents(boolean bl) {
        this.recordParents = bl;
        if (this.parents == null) {
            this.parents = new BitSetArray("parents");
        }
    }

    public int[] getParents(int n) {
        SimpleGraph.Assert(this.recordParents);
        this.complete();
        int n2 = this.idToIndex(n);
        int[] nArray = new int[this.parents.numberOfElements(n2)];
        int n3 = 0;
        IntEnumeration intEnumeration = this.parents.elements(n2);
        while (intEnumeration.hasMoreElements()) {
            int n4 = intEnumeration.nextInt();
            nArray[n3++] = this.vertexIds.get(n4);
        }
        return nArray;
    }

    public int pruneLeaves() {
        SimpleGraph.Assert(this.recordParents);
        this.complete();
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.parents.numberOfElements(i) != 0) continue;
            IntEnumeration intEnumeration = this.parents.elements(i);
            while (intEnumeration.hasMoreElements()) {
                int n2 = intEnumeration.nextInt();
            }
            this.parents.clearAll(i);
            this.vertexIds.put(i, -1);
            ++n;
        }
        return n;
    }

    void setValid(int n) {
        if (this.isValid == null) {
            this.isValid = new BitSet();
        }
        this.isValid.set(n);
    }

    public void addToVertex(int n, int n2) {
        int n3 = this.idToIndex(n);
        this.vertexSizes.put(n3, this.vertexSizes.get(n3) + n2);
    }

    public void addVertex(int n, int n2) {
        int n3 = this.idToIndex(n);
        if (this.sizeMatters) {
            this.vertexSizes.put(n3, n2);
        }
        this.setValid(n3);
    }

    public void addVertex(int n, int[] nArray, int n2) {
        int n3 = this.idToIndex(n);
        if (this.sizeMatters) {
            this.vertexSizes.put(n3, n2);
        }
        for (int i = 0; i < nArray.length; ++i) {
            SimpleGraph.Assert(nArray[i] != 0);
            int n4 = this.idToIndex(nArray[i]);
            this.edges.set(n3, n4);
            if (!this.recordParents) continue;
            this.parents.set(n4, n3);
        }
        this.setValid(n3);
    }

    public void deleteTree(int n) {
        this.dfs(new Visitor(){

            public void exitNode(int n) {
                SimpleGraph.this.deleted.set(n);
            }
        }, n);
    }

    Object dfs(Visitor visitor) {
        BitSet bitSet = new BitSet();
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        for (int i = 0; i < this.size; ++i) {
            this.dfs(visitor, stack, integerStack, bitSet, i);
        }
        return visitor.result();
    }

    public Object dfs(Visitor visitor, int n) {
        BitSet bitSet = new BitSet();
        return this.dfs(visitor, n, bitSet);
    }

    Object dfs(Visitor visitor, int n, BitSet bitSet) {
        Stack stack = new Stack();
        IntegerStack integerStack = new IntegerStack();
        visitor.init();
        return this.dfs(visitor, stack, integerStack, bitSet, n);
    }

    Object dfs(Visitor visitor, Stack stack, IntegerStack integerStack, BitSet bitSet, int n) {
        SimpleGraph.Assert(this.complete);
        if (this.stepper == null) {
            this.stepper = new Stepper(visitor, stack, integerStack, bitSet, n);
        } else {
            this.stepper.reset(visitor, stack, integerStack, bitSet, n);
        }
        int n2 = 1;
        int[] nArray = null;
        BitSet bitSet2 = null;
        boolean bl = visitor.ignoreDownEdges();
        if (bl) {
            nArray = new int[this.size];
            bitSet2 = new BitSet();
        }
        while (this.stepper.hasMoreElements()) {
            IntEnumeration intEnumeration = this.stepper.children();
            boolean bl2 = true;
            if (intEnumeration != null) {
                int n3;
                int n4 = this.stepper.currentNode();
                if (visitor.continueSearch(n4, integerStack.depth()) && intEnumeration.hasMoreElements()) {
                    n3 = intEnumeration.nextInt();
                    if (this.stepper.childAlreadyVisited(n3)) continue;
                    this.stepper.enterNode(n3);
                    if (bl) {
                        nArray[n3] = n2++;
                    }
                    bl2 = false;
                } else {
                    intEnumeration.reset();
                    while (intEnumeration.hasMoreElements()) {
                        n3 = intEnumeration.nextInt();
                        if (this.deleted.get(n3)) continue;
                        visitor.visitChildAtExit(n4, n3, bl && bitSet2.get(n3) && nArray[n3] > nArray[n4]);
                        if (!bl) continue;
                        bitSet2.set(n3);
                    }
                }
            }
            if (!bl2) continue;
            this.stepper.exitNode();
        }
        return visitor.result();
    }

    boolean dfsCompare(CompareVisitor compareVisitor, int n, int n2) {
        BitSet bitSet = new BitSet();
        int n3 = this.idToIndex(n);
        int n4 = this.idToIndex(n2);
        Stepper stepper = new Stepper(compareVisitor, new Stack(), new IntegerStack(), bitSet, n3);
        Stepper stepper2 = new Stepper(compareVisitor, new Stack(), new IntegerStack(), bitSet, n4);
        compareVisitor.init();
        while (stepper.hasMoreElements() || stepper2.hasMoreElements()) {
            if (!stepper.hasMoreElements() || !stepper2.hasMoreElements()) {
                return false;
            }
            IntEnumeration intEnumeration = stepper.children();
            IntEnumeration intEnumeration2 = stepper2.children();
            boolean bl = true;
            if (intEnumeration != null || intEnumeration2 != null) {
                if (intEnumeration == null || intEnumeration2 == null || intEnumeration.hasMoreElements() != intEnumeration2.hasMoreElements()) {
                    return false;
                }
                if (compareVisitor.continueSearch(stepper.currentNode(), stepper2.currentNode()) && intEnumeration.hasMoreElements()) {
                    boolean bl2;
                    int n5 = intEnumeration.nextInt();
                    int n6 = intEnumeration2.nextInt();
                    boolean bl3 = !stepper.childAlreadyVisited(n5);
                    boolean bl4 = bl2 = !stepper2.childAlreadyVisited(n6);
                    if (bl3 != bl2) {
                        return false;
                    }
                    if (!bl3) continue;
                    stepper.enterNode(n5);
                    stepper2.enterNode(n6);
                    if (!compareVisitor.compare(stepper.currentNode(), stepper2.currentNode())) {
                        return false;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            stepper.exitNode();
            stepper2.exitNode();
        }
        return true;
    }

    BitSetArray edges() {
        return this.edges;
    }

    IntEnumeration elements(Visitor visitor, int n, IntEnumeration intEnumeration) {
        IntEnumeration intEnumeration2;
        IntEnumeration intEnumeration3 = intEnumeration2 = intEnumeration == null ? this.edges().elements(n) : this.edges().elements(n, intEnumeration);
        if (visitor.sort()) {
            SortedIntEnumeration sortedIntEnumeration = new SortedIntEnumeration();
            while (intEnumeration2.hasMoreElements()) {
                int n2 = intEnumeration2.nextInt();
                int n3 = visitor.getCount(n2);
                sortedIntEnumeration.add(n2, n3);
            }
            sortedIntEnumeration.sort();
            intEnumeration2 = sortedIntEnumeration;
        }
        return intEnumeration2;
    }

    void random(int n, int n2, int n3) {
        int n4;
        Random random = new Random(n);
        for (n4 = 1; n4 <= n2; ++n4) {
            this.addVertex(n4, 1);
        }
        n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = random.nextInt(n2) + 1;
            if (n6 == (n5 = random.nextInt(n2) + 1)) continue;
            this.addEdge(n6, n5);
            ++n4;
        }
        this.complete();
    }

    public Vertex getVertex(int n) {
        return new Vertex(this, this.idToIndex(n));
    }

    public String toString() {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        if (this.exact || this.sizeMatters) {
            printStream.println("vertex sizes:");
            for (n = 0; n < this.size; ++n) {
                printStream.println(n + ": " + this.vertexSizes.get(n));
            }
        }
        printStream.println("digraph G {");
        printStream.println("    size = \"5,5\";");
        for (n = 0; n < this.size; ++n) {
            IntEnumeration intEnumeration = this.edges.elements(n);
            while (intEnumeration.hasMoreElements()) {
                int n2 = intEnumeration.nextInt();
                printStream.println("    " + n + " -> " + n2);
            }
        }
        printStream.println("}");
        printStream.flush();
        return byteArrayOutputStream.toString();
    }

    class Stepper {
        Visitor visitor;
        Stack enums;
        IntegerStack stack;
        BitSet grey;
        int initialNode;
        Stack reuseEnums;

        Stepper(Visitor visitor, Stack stack, IntegerStack integerStack, BitSet bitSet, int n) {
            this.reset(visitor, stack, integerStack, bitSet, n);
        }

        void reset(Visitor visitor, Stack stack, IntegerStack integerStack, BitSet bitSet, int n) {
            this.visitor = visitor;
            this.enums = stack;
            this.stack = integerStack;
            this.grey = bitSet;
            this.initialNode = n;
            this.reuseEnums = new Stack();
            if (!bitSet.get(n) && !SimpleGraph.this.deleted.get(n)) {
                this.enterNode(n);
            }
        }

        void enterNode(int n) {
            IntEnumeration intEnumeration = SimpleGraph.this.elements(this.visitor, n, this.reuseEnums.empty() ? null : (IntEnumeration)this.reuseEnums.pop());
            this.visitor.enterNode(n, this.stack.depth());
            this.stack.push(n);
            this.enums.push(intEnumeration);
            this.grey.set(n);
        }

        void exitNode() {
            this.visitor.exitNode(this.currentNode());
            this.stack.pop();
            IntEnumeration intEnumeration = (IntEnumeration)this.enums.pop();
            if (!(intEnumeration instanceof SortedIntEnumeration)) {
                this.reuseEnums.push(intEnumeration);
            }
        }

        boolean hasMoreElements() {
            return !this.stack.empty();
        }

        int currentNode() {
            return this.stack.peek();
        }

        String id() {
            int n = SimpleGraph.this.vertexIds.get(this.currentNode());
            return Base.hex(n);
        }

        IntEnumeration children() {
            return (IntEnumeration)this.enums.peek();
        }

        boolean childAlreadyVisited(int n) {
            if (SimpleGraph.this.deleted.get(n)) {
                return true;
            }
            this.visitor.visitChild(this.currentNode(), n, !this.grey.get(n), this.stack.depth());
            return this.grey.get(n);
        }
    }
}

