/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util;

import com.ibm.jvm.util.IntEnumeration;
import java.util.HashMap;
import java.util.Random;

public final class IntegerMap {
    static final int INITIAL_SIZE = 16;
    static final int EMPTY = 0;
    static final int OCCUPIED = 1;
    static final int OVERFLOW = 2;
    static final int OVERFLOW_SCALE = 1;
    int[] keys = new int[16];
    int[] values = new int[16];
    int[] overflow = new int[32];
    int tableSize = 16;
    int slotsInUse;
    byte[] flags = new byte[16];
    int overflowOffset = 0;
    int size;
    boolean useOpenAddressing;
    static final boolean doCheck = false;
    static final int[] smallPrimes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37};

    public IntegerMap(boolean bl) {
        this.useOpenAddressing = bl;
        if (bl) {
            this.tableSize = 17;
            this.keys = new int[this.tableSize];
            this.values = new int[this.tableSize];
            this.flags = new byte[this.tableSize];
            this.overflow = null;
        }
    }

    public IntegerMap() {
        this(true);
    }

    private int oget(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.tableSize;
        if (this.flags[n2] == 0) {
            return -1;
        }
        if (this.flags[n2] == 1) {
            if (this.keys[n2] == n) {
                return this.values[n2];
            }
            return -1;
        }
        int n3 = this.keys[n2];
        while (n3 != -1) {
            if (this.overflow[n3] == n) {
                return this.overflow[n3 + 1];
            }
            n3 = this.overflow[n3 + 2];
        }
        return -1;
    }

    private void oput(int n, int n2) {
        if (n == -1) {
            throw new Error("attempt to use key of -1 which is a reserved value");
        }
        if (n2 == -1) {
            throw new Error("attempt to use value of -1 which is a reserved value");
        }
        int n3 = (n & Integer.MAX_VALUE) % this.tableSize;
        if (this.flags[n3] == 0) {
            this.flags[n3] = 1;
            this.keys[n3] = n;
            this.values[n3] = n2;
        } else if (this.flags[n3] == 1) {
            this.flags[n3] = 2;
            int n4 = this.alloc(this.keys[n3], this.values[n3], -1);
            this.keys[n3] = this.alloc(n, n2, n4);
        } else {
            this.keys[n3] = this.alloc(n, n2, this.keys[n3]);
        }
        if (this.overflowOffset + 6 >= this.overflow.length) {
            this.orehash();
        }
    }

    int alloc(int n, int n2, int n3) {
        this.overflow[this.overflowOffset] = n;
        this.overflow[this.overflowOffset + 1] = n2;
        this.overflow[this.overflowOffset + 2] = n3;
        this.overflowOffset += 3;
        return this.overflowOffset - 3;
    }

    void orehash() {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        int[] nArray3 = this.overflow;
        byte[] byArray = this.flags;
        this.tableSize <<= 1;
        this.overflowOffset = 0;
        this.keys = new int[this.tableSize];
        this.values = new int[this.tableSize];
        this.overflow = new int[this.tableSize << 1];
        this.flags = new byte[this.tableSize];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (byArray[i] == 1) {
                this.oput(nArray[i], nArray2[i]);
                continue;
            }
            if (byArray[i] == 2) {
                int n2 = nArray[i];
                while (n2 != -1) {
                    this.oput(nArray3[n2], nArray3[n2 + 1]);
                    n2 = nArray3[n2 + 2];
                }
                continue;
            }
            ++n;
        }
    }

    void rehash() {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        int[] nArray3 = this.overflow;
        byte[] byArray = this.flags;
        this.tableSize <<= 1;
        while (!this.isprime(++this.tableSize)) {
        }
        this.keys = new int[this.tableSize];
        this.values = new int[this.tableSize];
        this.flags = new byte[this.tableSize];
        int n = 0;
        this.slotsInUse = 0;
        int n2 = this.size;
        for (int i = 0; i < nArray.length; ++i) {
            if (byArray[i] == 1) {
                this.put(nArray[i], nArray2[i]);
                continue;
            }
            ++n;
        }
        this.size = n2;
    }

    public int get(int n) {
        for (int i = 0; i < this.tableSize; ++i) {
            int n2 = this.h(n & Integer.MAX_VALUE, i);
            if (this.flags[n2] == 0) {
                return -1;
            }
            if (this.keys[n2] != n) continue;
            return this.values[n2];
        }
        return -1;
    }

    public void put(int n, int n2) {
        ++this.size;
        for (int i = 0; i < this.tableSize; ++i) {
            int n3 = this.h(n & Integer.MAX_VALUE, i);
            if (this.flags[n3] == 0) {
                this.keys[n3] = n;
                this.values[n3] = n2;
                this.flags[n3] = 1;
                if (++this.slotsInUse > this.tableSize * 3 / 4) {
                    this.rehash();
                }
                return;
            }
            if (this.keys[n3] != n) continue;
            this.values[n3] = n2;
            return;
        }
        throw new Error("table full!");
    }

    public int size() {
        return this.size;
    }

    public IntEnumeration getKeys() {
        return new KeyEnum();
    }

    private void _put(int n, int n2) {
        if (this.useOpenAddressing) {
            this.put(n, n2);
        } else {
            this.oput(n, n2);
        }
    }

    private int _get(int n) {
        if (this.useOpenAddressing) {
            return this.get(n);
        }
        return this.oget(n);
    }

    private int h1(int n) {
        return n % this.tableSize;
    }

    private int h2(int n) {
        return 1 + n % (this.tableSize - 2);
    }

    private int h(int n, int n2) {
        long l = (long)this.h1(n) + (long)n2 * (long)this.h2(n);
        return (int)(l % (long)this.tableSize);
    }

    private boolean isprime(int n) {
        int n2;
        int n3 = 0;
        for (int i = 0; i < smallPrimes.length; ++i) {
            n3 = smallPrimes[i];
            if (n % n3 != 0) continue;
            return false;
        }
        for (n2 = n; n / n2 < n2; n2 >>= 1) {
        }
        n2 <<= 1;
        n3 += 2;
        while (n3 < n2) {
            if (n % n3 == 0) {
                return false;
            }
            n3 += 2;
        }
        return true;
    }

    void test() {
        Random random = new Random(23L);
        HashMap hashMap = new HashMap();
        for (int i = 0; i < 500000; ++i) {
            int n = random.nextInt();
            int n2 = random.nextInt();
            if (this._get(n) != -1) continue;
            this._put(n, n2);
        }
    }

    public static void main(String[] stringArray) {
        IntegerMap integerMap = new IntegerMap(false);
        integerMap.test();
        integerMap = new IntegerMap(true);
        integerMap.test();
        integerMap = new IntegerMap(false);
        long l = System.currentTimeMillis();
        integerMap.test();
        long l2 = System.currentTimeMillis();
        System.out.println("first test used " + (l2 - l) + " millis usage " + 16 * integerMap.tableSize);
        integerMap = new IntegerMap(true);
        long l3 = System.currentTimeMillis();
        integerMap.test();
        long l4 = System.currentTimeMillis();
        System.out.println("second test used " + (l4 - l3) + " millis usage " + 8 * integerMap.tableSize);
        int n = 0;
        IntEnumeration intEnumeration = integerMap.getKeys();
        while (intEnumeration.hasMoreElements()) {
            int n2 = intEnumeration.nextInt();
            if (integerMap.get(n2) == -1) {
                throw new Error("huh");
            }
            ++n;
        }
        System.out.println("finished!");
    }

    class KeyEnum
    implements IntEnumeration {
        int index = 0;
        boolean hasMore = true;

        KeyEnum() {
            this.reset();
        }

        void next() {
            while (this.index < IntegerMap.this.tableSize && IntegerMap.this.flags[this.index] != 1) {
                ++this.index;
            }
            if (this.index == IntegerMap.this.tableSize) {
                this.hasMore = false;
            }
        }

        public boolean hasMoreElements() {
            return this.hasMore;
        }

        public Object nextElement() {
            return new Integer(this.nextInt());
        }

        public int nextInt() {
            int n = IntegerMap.this.keys[this.index++];
            this.next();
            return n;
        }

        public int peekInt() {
            return IntegerMap.this.keys[this.index];
        }

        public void reset() {
            this.index = 0;
            this.hasMore = true;
            this.next();
        }
    }
}

