/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.CircularIdentityList;
import com.sun.java.swing.plaf.gtk.DefaultSynthStyle;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.PixmapEngine;
import com.sun.java.swing.plaf.gtk.SynthContext;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.ImageIcon;

class PixmapStyle
extends GTKStyle
implements GTKConstants {
    private static final GTKEngine PIXMAP_ENGINE = new PixmapEngine();
    private Info[] info;

    public PixmapStyle(DefaultSynthStyle defaultSynthStyle) {
        super(defaultSynthStyle);
        if (defaultSynthStyle instanceof PixmapStyle) {
            this.info = ((PixmapStyle)defaultSynthStyle).info;
        }
    }

    public PixmapStyle(DefaultSynthStyle.StateInfo[] stateInfoArray, CircularIdentityList circularIdentityList, Font font, int n, int n2, GTKStyle.GTKStockIconInfo[] gTKStockIconInfoArray, Info[] infoArray) {
        super(stateInfoArray, circularIdentityList, font, n, n2, gTKStockIconInfoArray);
        this.info = infoArray;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (!(defaultSynthStyle instanceof PixmapStyle)) {
            defaultSynthStyle = new PixmapStyle(defaultSynthStyle);
        }
        PixmapStyle pixmapStyle = (PixmapStyle)super.addTo(defaultSynthStyle);
        if (this.info != null) {
            if (pixmapStyle.info == null) {
                pixmapStyle.info = this.info;
            } else {
                Info[] infoArray = new Info[pixmapStyle.info.length + this.info.length];
                System.arraycopy(this.info, 0, infoArray, 0, this.info.length);
                System.arraycopy(pixmapStyle.info, 0, infoArray, this.info.length, pixmapStyle.info.length);
                pixmapStyle.info = infoArray;
            }
        }
        return pixmapStyle;
    }

    public Object clone() {
        PixmapStyle pixmapStyle = (PixmapStyle)super.clone();
        pixmapStyle.info = this.info;
        return pixmapStyle;
    }

    public GTKEngine getEngine(SynthContext synthContext) {
        return PIXMAP_ENGINE;
    }

    public Info getInfo(String string, String string2, int n, int n2, int n3, int n4, int n5) {
        if (this.info != null) {
            int n6 = this.info.length;
            for (int i = 0; i < n6; ++i) {
                if (this.info[i].getFunction() != string || this.info[i].getMatchCount(string2, n, n2, n3, n4, n5) == -1) continue;
                return this.info[i];
            }
        }
        return null;
    }

    private int getMaxMatchCount(int n, int n2, int n3, int n4, int n5, String string) {
        int n6 = 0;
        if (string != null) {
            ++n6;
        }
        if (n != -100) {
            ++n6;
        }
        if (n2 != -100) {
            ++n6;
        }
        if (n3 != -100) {
            ++n6;
        }
        if (n4 != -100) {
            ++n6;
        }
        if (n5 != -100) {
            ++n6;
        }
        return n6;
    }

    public String toString() {
        if (this.info == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (stringBuffer.length() > 0) {
            stringBuffer.append('\n');
        }
        stringBuffer.append("*** Pixmap Engine Info ***\n");
        for (int i = 0; i < this.info.length; ++i) {
            stringBuffer.append(this.info[i].toString()).append('\n');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static class Info {
        private String function = null;
        private String detail = null;
        int gapSide = -100;
        int orientation = -100;
        int componentState = -100;
        int shadow = -100;
        int arrowDirection = -100;
        boolean recolorable = false;
        Object image = null;
        Insets fileInsets = null;
        boolean stretch = false;
        Object overlayImage = null;
        Insets overlayInsets = null;
        boolean overlayStretch = false;
        Object gapStartImage = null;
        Insets gapStartInsets = null;
        Object gapImage = null;
        Insets gapInsets = null;
        Object gapEndImage = null;
        Insets gapEndInsets = null;

        public void setFunction(String string) {
            this.function = string.intern();
        }

        public void setDetail(String string) {
            this.detail = string.intern();
        }

        public String getFunction() {
            return this.function;
        }

        public Image getImage() {
            this.image = this.getImage(this.image);
            return (Image)this.image;
        }

        public boolean isRecolorable() {
            return this.recolorable;
        }

        public Insets getImageInsets() {
            return this.fileInsets;
        }

        public boolean getStretch() {
            return this.stretch;
        }

        public String getDetail() {
            return this.detail;
        }

        public int getComponentState() {
            return this.componentState;
        }

        public int getShadow() {
            return this.shadow;
        }

        public int getGapSide() {
            return this.gapSide;
        }

        public Image getGapImage() {
            this.gapImage = this.getImage(this.gapImage);
            return (Image)this.gapImage;
        }

        public Insets getGapInsets() {
            return this.gapInsets;
        }

        public Image getGapStartImage() {
            this.gapStartImage = this.getImage(this.gapStartImage);
            return (Image)this.gapStartImage;
        }

        public Insets getGapStartInsets() {
            return this.gapStartInsets;
        }

        public Image getGapEndImage() {
            this.gapEndImage = this.getImage(this.gapEndImage);
            return (Image)this.gapEndImage;
        }

        public Insets getGapEndInsets() {
            return this.gapEndInsets;
        }

        public Image getOverlayImage() {
            this.overlayImage = this.getImage(this.overlayImage);
            return (Image)this.overlayImage;
        }

        public Insets getOverlayInsets() {
            return this.overlayInsets;
        }

        public boolean getOverlayStretch() {
            return this.overlayStretch;
        }

        public int getArrowDirection() {
            return this.arrowDirection;
        }

        public int getOrientation() {
            return this.orientation;
        }

        private Image getImage(Object object) {
            if (object == null || object instanceof Image) {
                return (Image)object;
            }
            ImageIcon imageIcon = (ImageIcon)AccessController.doPrivileged(new PrivilegedAction(this, object){
                private final /* synthetic */ Object val$o;
                private final /* synthetic */ Info this$0;
                {
                    this.this$0 = info;
                    this.val$o = object;
                }

                public Object run() {
                    return new ImageIcon((String)this.val$o);
                }
            });
            if (imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0) {
                return imageIcon.getImage();
            }
            return null;
        }

        int getMatchCount(String string, int n, int n2, int n3, int n4, int n5) {
            int n6 = 0;
            if (this.componentState != -100) {
                if (n != -100 && this.componentState != n) {
                    return -1;
                }
                ++n6;
            }
            if (this.shadow != -100) {
                if (n2 != -100 && this.shadow != n2) {
                    return -1;
                }
                ++n6;
            }
            if (this.orientation != -100) {
                if (n3 != -100 && this.orientation != n3) {
                    return -1;
                }
                ++n6;
            }
            if (this.gapSide != -100) {
                if (n4 != -100 && this.gapSide != n4) {
                    return -1;
                }
                ++n6;
            }
            if (this.arrowDirection != -100) {
                if (n5 != -100 && this.arrowDirection != n5) {
                    return -1;
                }
                ++n6;
            }
            if (this.detail != null) {
                if (this.detail != string) {
                    return -1;
                }
                ++n6;
            }
            return n6;
        }

        boolean matches(Info info) {
            return info.function == this.function && info.detail == this.detail && info.componentState == this.componentState && info.shadow == this.shadow && info.gapSide == this.gapSide && info.arrowDirection == this.arrowDirection && info.orientation == this.orientation;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("IMAGE:\n");
            if (this.function != null) {
                stringBuffer.append("    function=").append(this.function).append('\n');
            }
            if (this.detail != null) {
                stringBuffer.append("    detail=").append(this.detail).append('\n');
            }
            if (this.gapSide != -100) {
                stringBuffer.append("    gapSide=");
                stringBuffer.append(Info.getSideName(this.gapSide)).append('\n');
            }
            if (this.orientation != -100) {
                stringBuffer.append("    orientation=");
                stringBuffer.append(Info.getOrientName(this.orientation)).append('\n');
            }
            if (this.componentState != -100) {
                stringBuffer.append("    componentState=");
                stringBuffer.append(GTKStyle.getStateName(this.componentState, "UNDEFINED")).append('\n');
            }
            if (this.shadow != -100) {
                stringBuffer.append("    shadow=");
                stringBuffer.append(Info.getShadowName(this.shadow)).append('\n');
            }
            if (this.arrowDirection != -100) {
                stringBuffer.append("    arrowDirection=");
                stringBuffer.append(Info.getArrowDirectionName(this.arrowDirection)).append('\n');
            }
            if (this.recolorable) {
                stringBuffer.append("    recolorable=").append(this.recolorable).append('\n');
            }
            if (this.image != null) {
                stringBuffer.append("    image=").append(this.image).append('\n');
            }
            if (this.fileInsets != null) {
                stringBuffer.append("    fileInsets=").append(this.fileInsets).append('\n');
            }
            if (this.stretch) {
                stringBuffer.append("    stretch=").append(this.stretch).append('\n');
            }
            if (this.overlayImage != null) {
                stringBuffer.append("    overlayImage=").append(this.overlayImage).append('\n');
            }
            if (this.overlayInsets != null) {
                stringBuffer.append("    overlayInsets=").append(this.overlayInsets).append('\n');
            }
            if (this.overlayStretch) {
                stringBuffer.append("    overlayStretch=").append(this.overlayStretch).append('\n');
            }
            if (this.gapStartImage != null) {
                stringBuffer.append("    gapStartImage=").append(this.gapStartImage).append('\n');
            }
            if (this.gapStartInsets != null) {
                stringBuffer.append("    gapStartInsets=").append(this.gapStartInsets).append('\n');
            }
            if (this.gapImage != null) {
                stringBuffer.append("    gapImage=").append(this.gapImage).append('\n');
            }
            if (this.gapInsets != null) {
                stringBuffer.append("    gapInsets=").append(this.gapInsets).append('\n');
            }
            if (this.gapEndImage != null) {
                stringBuffer.append("    gapEndImage=").append(this.gapEndImage).append('\n');
            }
            if (this.gapEndInsets != null) {
                stringBuffer.append("    gapEndInsets=").append(this.gapEndInsets).append('\n');
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            return stringBuffer.toString();
        }

        private static String getSideName(int n) {
            switch (n) {
                case 2: {
                    return "TOP";
                }
                case 3: {
                    return "BOTTOM";
                }
                case 0: {
                    return "LEFT";
                }
                case 1: {
                    return "RIGHT";
                }
                case -100: {
                    return "UNDEFINED";
                }
            }
            return "UNKNOWN";
        }

        private static String getOrientName(int n) {
            switch (n) {
                case 0: {
                    return "HORIZONTAL";
                }
                case 1: {
                    return "VERTICAL";
                }
                case -100: {
                    return "UNDEFINED";
                }
            }
            return "UNKNOWN";
        }

        private static String getShadowName(int n) {
            switch (n) {
                case 0: {
                    return "SHADOW_IN";
                }
                case 1: {
                    return "SHADOW_OUT";
                }
                case 2: {
                    return "SHADOW_ETCHED_IN";
                }
                case 3: {
                    return "SHADOW_ETCHED_OUT";
                }
                case 4: {
                    return "SHADOW_NONE";
                }
                case -100: {
                    return "UNDEFINED";
                }
            }
            return "UNKNOWN";
        }

        private static String getArrowDirectionName(int n) {
            switch (n) {
                case 100: {
                    return "ARROW_UP";
                }
                case 101: {
                    return "ARROW_DOWN";
                }
                case 102: {
                    return "ARROW_LEFT";
                }
                case 103: {
                    return "ARROW_RIGHT";
                }
                case -100: {
                    return "UNDEFINED";
                }
            }
            return "UNKNOWN";
        }
    }
}

