/*
 * Decompiled with CFR 0.152.
 */
package javax.accessibility;

import java.util.Vector;
import javax.accessibility.AccessibleState;

public class AccessibleStateSet {
    protected Vector states = null;

    public AccessibleStateSet() {
        this.states = null;
    }

    public AccessibleStateSet(AccessibleState[] accessibleStateArray) {
        if (accessibleStateArray.length != 0) {
            this.states = new Vector(accessibleStateArray.length);
            for (int i = 0; i < accessibleStateArray.length; ++i) {
                if (this.states.contains(accessibleStateArray[i])) continue;
                this.states.addElement(accessibleStateArray[i]);
            }
        }
    }

    public boolean add(AccessibleState accessibleState) {
        if (this.states == null) {
            this.states = new Vector();
        }
        if (!this.states.contains(accessibleState)) {
            this.states.addElement(accessibleState);
            return true;
        }
        return false;
    }

    public void addAll(AccessibleState[] accessibleStateArray) {
        if (accessibleStateArray.length != 0) {
            if (this.states == null) {
                this.states = new Vector(accessibleStateArray.length);
            }
            for (int i = 0; i < accessibleStateArray.length; ++i) {
                if (this.states.contains(accessibleStateArray[i])) continue;
                this.states.addElement(accessibleStateArray[i]);
            }
        }
    }

    public boolean remove(AccessibleState accessibleState) {
        if (this.states == null) {
            return false;
        }
        return this.states.removeElement(accessibleState);
    }

    public void clear() {
        if (this.states != null) {
            this.states.removeAllElements();
        }
    }

    public boolean contains(AccessibleState accessibleState) {
        if (this.states == null) {
            return false;
        }
        return this.states.contains(accessibleState);
    }

    public AccessibleState[] toArray() {
        if (this.states == null) {
            return new AccessibleState[0];
        }
        AccessibleState[] accessibleStateArray = new AccessibleState[this.states.size()];
        for (int i = 0; i < accessibleStateArray.length; ++i) {
            accessibleStateArray[i] = (AccessibleState)this.states.elementAt(i);
        }
        return accessibleStateArray;
    }

    public String toString() {
        String string = null;
        if (this.states != null && this.states.size() > 0) {
            string = ((AccessibleState)this.states.elementAt(0)).toDisplayString();
            for (int i = 1; i < this.states.size(); ++i) {
                string = string + "," + ((AccessibleState)this.states.elementAt(i)).toDisplayString();
            }
        }
        return string;
    }
}

