/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.util.IntEnumeration;

public class Vertex
extends Base {
    protected SimpleGraph graph;
    protected int index;
    protected Vertex[] children;
    protected Vertex parent;

    String className() {
        return "Vertex";
    }

    protected Vertex(SimpleGraph simpleGraph, int n) {
        this.graph = simpleGraph;
        this.index = n;
    }

    public int id() {
        return this.graph.vertexIds.get(this.index);
    }

    public int reachability() {
        Base.Assert(false);
        return 0;
    }

    public boolean isLeaf() {
        return this.graph.isLeaf(this.id());
    }

    public int getChildCount() {
        return this.graph.getChildCount(this.id());
    }

    public Vertex getChild(int n) {
        if (this.children == null) {
            this.children = new Vertex[this.getChildCount()];
            int n2 = 0;
            IntEnumeration intEnumeration = this.graph.getChildren(this.id());
            while (intEnumeration.hasMoreElements()) {
                int n3 = intEnumeration.nextInt();
                this.children[n2] = this.graph.getVertex(n3);
                ++n2;
            }
        }
        return this.children[n];
    }

    public String toString() {
        if (this.graph.client == null) {
            return "0x" + Base.hex(this.id());
        }
        return this.graph.client.getName(this.id());
    }
}

