/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.util.html;

import com.ibm.jvm.util.html.Base;
import com.ibm.jvm.util.html.Element;
import com.ibm.jvm.util.html.Text;
import java.util.ArrayList;
import java.util.Iterator;

public class Document
extends Base {
    protected boolean usePlainText;
    protected ArrayList elements = new ArrayList();
    protected String title;
    protected static final String lineSeparator = System.getProperty("line.separator");
    protected int marginwidth = -1;
    protected int marginheight = -1;
    boolean firstFlush = true;

    public Document(String string) {
        this.title = string;
    }

    public Document(String string, int n, int n2) {
        this.title = string;
        this.marginwidth = n;
        this.marginheight = n2;
    }

    public Document() {
        this.title = "";
    }

    public Document(boolean bl) {
        this.title = "";
        this.usePlainText = bl;
    }

    public void addElement(Element element) {
        element.setDocument(this);
        this.elements.add(element);
        this.flush();
    }

    public void add(Element element) {
        this.addElement(element);
    }

    public void setPlainText(boolean bl) {
        this.usePlainText = bl;
    }

    public void print(String string) {
        this.addElement(new Text(string));
    }

    public void println(String string) {
        this.addElement(new Text(string, true));
    }

    public void printHeader(String string) {
        this.printHeader(string, 2);
    }

    public void printHeader(String string, int n) {
        this.addElement(new Text(string, n));
    }

    protected String toHtmlString() {
        String string = "<html><head><title>" + this.title + "</title></head>";
        String string2 = "<body";
        if (this.marginwidth != -1) {
            string2 = string2 + " marginwidth=\"" + this.marginwidth + "\"";
        }
        if (this.marginheight != -1) {
            string2 = string2 + " marginheight=\"" + this.marginheight + "\"";
        }
        string2 = string2 + ">";
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            string2 = string2 + element.toHtmlString();
        }
        return string + string2 + "</body></html>";
    }

    protected static String pad(int n, char c) {
        Base.Assert(n >= 0);
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + c;
            ++n2;
        }
        return string;
    }

    protected String toTextString() {
        String string = "";
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            string = string + element.toTextString();
        }
        return string;
    }

    public String toString() {
        if (this.usePlainText) {
            return this.toTextString();
        }
        return this.toHtmlString();
    }

    void flush() {
        Object object;
        String string;
        if (this.firstFlush) {
            this.firstFlush = false;
            if (!this.usePlainText) {
                string = "<html><head><title>" + this.title + "</title></head>";
                object = "<body";
                if (this.marginwidth != -1) {
                    object = (String)object + " marginwidth=\"" + this.marginwidth + "\"";
                }
                if (this.marginheight != -1) {
                    object = (String)object + " marginheight=\"" + this.marginheight + "\"";
                }
                object = (String)object + ">";
                System.out.println(string);
                System.out.println((String)object);
            }
        }
        string = "";
        object = this.elements.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            string = this.usePlainText ? string + element.toTextString() : string + element.toHtmlString();
        }
        System.out.print(string);
        this.elements = new ArrayList();
    }

    public void close() {
        this.flush();
        if (!this.usePlainText) {
            System.out.println("</body></html>");
        }
    }
}

